/*
 * Decompiled with CFR 0.152.
 */
package mcp.mobius.waila.plugin.core.provider;

import mcp.mobius.waila.api.IEntityAccessor;
import mcp.mobius.waila.api.IEntityComponentProvider;
import mcp.mobius.waila.api.IModInfo;
import mcp.mobius.waila.api.IPluginConfig;
import mcp.mobius.waila.api.ITooltip;
import mcp.mobius.waila.api.ITooltipComponent;
import mcp.mobius.waila.api.IWailaConfig;
import mcp.mobius.waila.api.WailaConstants;
import mcp.mobius.waila.api.component.ItemComponent;
import mcp.mobius.waila.plugin.core.component.HealthComponent;
import mcp.mobius.waila.plugin.core.config.Options;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1799;
import net.minecraft.class_2378;
import net.minecraft.class_2561;
import org.jetbrains.annotations.Nullable;

public enum EntityProvider implements IEntityComponentProvider
{
    INSTANCE;


    @Override
    @Nullable
    public ITooltipComponent getIcon(IEntityAccessor accessor, IPluginConfig config) {
        Object entity = accessor.getEntity();
        if (entity instanceof class_1308) {
            return null;
        }
        class_1799 stack = entity.method_31480();
        return stack != null ? new ItemComponent(stack) : null;
    }

    @Override
    public void appendHead(ITooltip tooltip, IEntityAccessor accessor, IPluginConfig config) {
        Object entity = accessor.getEntity();
        IWailaConfig.Formatter formatter = IWailaConfig.get().getFormatter();
        tooltip.setLine(WailaConstants.OBJECT_NAME_TAG, formatter.entityName(entity.method_5476().getString()));
        if (config.getBoolean(WailaConstants.CONFIG_SHOW_REGISTRY)) {
            tooltip.setLine(WailaConstants.REGISTRY_NAME_TAG, formatter.registryName(class_2378.field_11145.method_10221((Object)entity.method_5864())));
        }
    }

    @Override
    public void appendBody(ITooltip tooltip, IEntityAccessor accessor, IPluginConfig config) {
        Object t;
        if (config.getBoolean(Options.ENTITY_HEALTH) && (t = accessor.getEntity()) instanceof class_1309) {
            class_1309 living = (class_1309)t;
            float health = living.method_6032();
            float maxHealth = living.method_6063();
            if (living.method_6063() > (float)IWailaConfig.get().getGeneral().getMaxHealthForRender()) {
                tooltip.addLine((class_2561)class_2561.method_43469((String)"tooltip.waila.health", (Object[])new Object[]{String.format("%.2f", Float.valueOf(health)), String.format("%.2f", Float.valueOf(maxHealth))}));
            } else {
                tooltip.addLine(new HealthComponent(health / 2.0f, maxHealth / 2.0f));
            }
        }
    }

    @Override
    public void appendTail(ITooltip tooltip, IEntityAccessor accessor, IPluginConfig config) {
        if (config.getBoolean(WailaConstants.CONFIG_SHOW_MOD_NAME)) {
            tooltip.setLine(WailaConstants.MOD_NAME_TAG, IWailaConfig.get().getFormatter().modName(IModInfo.get(accessor.getEntity()).getName()));
        }
    }
}

