/*
 * Decompiled with CFR 0.152.
 */
package mcp.mobius.waila;

import java.util.List;
import mcp.mobius.waila.Waila;
import mcp.mobius.waila.api.IEventListener;
import mcp.mobius.waila.api.IWailaConfig;
import mcp.mobius.waila.api.WailaConstants;
import mcp.mobius.waila.config.PluginConfig;
import mcp.mobius.waila.config.WailaConfig;
import mcp.mobius.waila.gui.screen.HomeScreen;
import mcp.mobius.waila.hud.ClientTickHandler;
import mcp.mobius.waila.registry.Registrar;
import mcp.mobius.waila.service.IClientService;
import net.minecraft.class_1799;
import net.minecraft.class_2535;
import net.minecraft.class_2561;
import net.minecraft.class_304;
import net.minecraft.class_310;
import net.minecraft.class_437;

public abstract class WailaClient {
    public static class_304 openConfig;
    public static class_304 showOverlay;
    public static class_304 toggleLiquid;
    public static class_304 showRecipeInput;
    public static class_304 showRecipeOutput;
    public static Runnable onShowRecipeInput;
    public static Runnable onShowRecipeOutput;

    protected static void registerKeyBinds() {
        openConfig = IClientService.INSTANCE.createKeyBind("config", 320);
        showOverlay = IClientService.INSTANCE.createKeyBind("show_overlay", 321);
        toggleLiquid = IClientService.INSTANCE.createKeyBind("toggle_liquid", 322);
        showRecipeInput = IClientService.INSTANCE.createKeyBind("show_recipe_input", 323);
        showRecipeOutput = IClientService.INSTANCE.createKeyBind("show_recipe_output", 324);
    }

    protected static void onClientTick() {
        class_310 client = class_310.method_1551();
        WailaConfig config = Waila.CONFIG.get();
        ClientTickHandler.tick();
        while (openConfig.method_1436()) {
            client.method_1507((class_437)new HomeScreen(null));
        }
        while (showOverlay.method_1436()) {
            if (config.getGeneral().getDisplayMode() != IWailaConfig.General.DisplayMode.TOGGLE) continue;
            config.getGeneral().setDisplayTooltip(!config.getGeneral().isDisplayTooltip());
        }
        while (toggleLiquid.method_1436()) {
            PluginConfig.INSTANCE.set(WailaConstants.CONFIG_SHOW_FLUID, !PluginConfig.INSTANCE.getBoolean(WailaConstants.CONFIG_SHOW_FLUID));
        }
        while (showRecipeInput.method_1436() && onShowRecipeInput != null) {
            onShowRecipeInput.run();
        }
        while (showRecipeOutput.method_1436() && onShowRecipeOutput != null) {
            onShowRecipeOutput.run();
        }
    }

    protected static void onItemTooltip(class_1799 stack, List<class_2561> tooltip) {
        if (PluginConfig.INSTANCE.getBoolean(WailaConstants.CONFIG_SHOW_MOD_NAME)) {
            for (IEventListener listener : Registrar.INSTANCE.eventListeners.get(Object.class)) {
                String name = listener.getHoveredItemModName(stack, PluginConfig.INSTANCE);
                if (name == null) continue;
                tooltip.add(IWailaConfig.get().getFormatter().modName(name));
                return;
            }
        }
    }

    protected static void onServerLogIn(class_2535 connection) {
        Waila.BLACKLIST_CONFIG.invalidate();
        if (!connection.method_10756()) {
            Waila.LOGGER.info("Connecting to dedicated server, resetting syncable config to client-only values");
            PluginConfig.INSTANCE.getSyncableConfigs().forEach(config -> config.setValue(config.getClientOnlyValue()));
        }
    }

    protected static void onServerLogout(class_2535 connection) {
        Waila.BLACKLIST_CONFIG.invalidate();
        if (!connection.method_10756()) {
            PluginConfig.INSTANCE.reload();
        }
    }
}

