/*
 * Decompiled with CFR 0.152.
 */
package dev.quantumfusion.dashloader.registry;

import dev.quantumfusion.dashloader.DashLoader;
import dev.quantumfusion.dashloader.registry.chunk.data.AbstractDataChunk;
import dev.quantumfusion.taski.Task;
import dev.quantumfusion.taski.builtin.StepTask;
import java.util.function.Consumer;
import org.jetbrains.annotations.Nullable;

public final class RegistryReader {
    private final AbstractDataChunk<?, ?>[] dataChunks;
    private final Object[][] data;

    public RegistryReader(AbstractDataChunk<?, ?>[] data) {
        this.dataChunks = data;
        this.data = new Object[data.length][];
    }

    public final void export(@Nullable Consumer<Task> taskConsumer) {
        StepTask task = new StepTask("Exporting", this.dataChunks.length);
        if (taskConsumer != null) {
            taskConsumer.accept((Task)task);
        }
        for (int i = 0; i < this.dataChunks.length; ++i) {
            AbstractDataChunk<?, ?> chunk = this.dataChunks[i];
            int size = chunk.getDashableSize();
            Object[] dataObjects = new Object[size];
            this.data[i] = dataObjects;
            task.run((Task)new StepTask(chunk.name, 3), subTask -> {
                DashLoader.DL.log.info("Loading " + size + " " + chunk.name + "s");
                chunk.preExport(this);
                subTask.next();
                chunk.export(dataObjects, this);
                subTask.next();
                chunk.postExport(this);
                subTask.next();
            });
        }
    }

    public final <R> R get(int pointer) {
        return (R)this.data[pointer & 0x3F][pointer >>> 6];
    }
}

