/*
 * Decompiled with CFR 0.152.
 */
package dev.quantumfusion.dashloader.mixin.option.state;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSortedMap;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Decoder;
import com.mojang.serialization.Encoder;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.MapDecoder;
import com.mojang.serialization.MapEncoder;
import dev.quantumfusion.dashloader.mixin.accessor.StateManagerAccessor;
import dev.quantumfusion.dashloader.util.UnsafeHelper;
import dev.quantumfusion.dashloader.util.mixins.StateDuck;
import dev.quantumfusion.dashloader.util.mixins.StateMath;
import it.unimi.dsi.fastutil.Hash;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenCustomHashMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.class_2688;
import net.minecraft.class_2689;
import net.minecraft.class_2769;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;

@Mixin(value={class_2689.class_2690.class})
public abstract class StateManagerBuilderMixin<O, S extends class_2688<O, S>> {
    @Shadow
    @Final
    private O field_12318;
    @Shadow
    @Final
    private Map<String, class_2769<?>> field_12319;

    @Shadow
    public abstract class_2689.class_2690<O, S> method_11667(class_2769<?> ... var1);

    @Overwrite
    public class_2689<O, S> method_11668(Function<O, S> ownerToStateFunction, class_2689.class_2691<O, S> factory) {
        Object access;
        ImmutableSortedMap properties = ImmutableSortedMap.copyOf(this.field_12319);
        Supplier<class_2688> supplier = () -> (class_2688)ownerToStateFunction.apply(this.field_12318);
        MapCodec<class_2688> mapCodec = MapCodec.of((MapEncoder)Encoder.empty(), (MapDecoder)Decoder.unit(supplier));
        for (Map.Entry entry : properties.entrySet()) {
            mapCodec = StateMath.createCodec(mapCodec, supplier, (String)entry.getKey(), (class_2769)entry.getValue());
        }
        class_2769[] propertiesRaw = (class_2769[])this.field_12319.values().toArray(class_2769[]::new);
        Comparable<?>[][] propertyValues = StateMath.createPropertyValues(propertiesRaw);
        MapCodec<class_2688> finalMapCodec = mapCodec;
        ArrayList<class_2688> stateList = new ArrayList<class_2688>();
        ArrayList<Comparable[]> stateValues = new ArrayList<Comparable[]>();
        Object2ObjectOpenCustomHashMap stateLookup = new Object2ObjectOpenCustomHashMap((Hash.Strategy)new Hash.Strategy<Comparable<?>[]>(){

            public int hashCode(Comparable<?>[] o) {
                return Arrays.hashCode(o);
            }

            public boolean equals(Comparable<?>[] a, Comparable<?>[] b) {
                return Arrays.equals(a, b);
            }
        });
        for (Pair<ImmutableMap<class_2769<?>, Comparable<?>>, Comparable<?>[]> entry : StateMath.generateCombinations2Mod(propertiesRaw, propertyValues)) {
            ImmutableMap entries = (ImmutableMap)entry.getFirst();
            class_2688 state = (class_2688)factory.create(this.field_12318, entries, finalMapCodec);
            stateLookup.put((Object)((Comparable[])entry.getSecond()), (Object)state);
            stateValues.add((Comparable[])entry.getSecond());
            stateList.add(state);
        }
        for (int i = 0; i < stateValues.size(); ++i) {
            access = (StateDuck)stateList.get(i);
            Comparable[] values = (Comparable[])stateValues.get(i);
            access.setFastWithTable(StateMath.createWithFast(values, propertyValues, stateLookup, propertiesRaw.length));
            access.setPropertiesMap(propertiesRaw);
            access.setValuesMap(propertyValues);
        }
        class_2689 stateManager = UnsafeHelper.allocateInstance(class_2689.class);
        access = (StateManagerAccessor)stateManager;
        access.setOwner(this.field_12318);
        access.setStates(ImmutableList.copyOf(stateList));
        access.setProperties(properties);
        return stateManager;
    }
}

