/*
 * Decompiled with CFR 0.152.
 */
package dev.quantumfusion.dashloader.mixin.option.cache.sprite;

import dev.quantumfusion.dashloader.DashLoader;
import dev.quantumfusion.dashloader.data.image.DashSpriteAtlasTextureData;
import dev.quantumfusion.dashloader.fallback.sprite.FakeTextureStitcher;
import dev.quantumfusion.dashloader.mixin.accessor.SpriteAccessor;
import dev.quantumfusion.dashloader.util.mixins.SpriteAtlasTextureDuck;
import dev.quantumfusion.dashloader.util.mixins.SpriteInfoDuck;
import java.util.HashMap;
import java.util.Map;
import java.util.Queue;
import net.minecraft.class_1055;
import net.minecraft.class_1058;
import net.minecraft.class_1059;
import net.minecraft.class_1079;
import net.minecraft.class_2960;
import net.minecraft.class_3300;
import org.apache.commons.lang3.tuple.MutablePair;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={class_1059.class})
public class SpriteAtlasTextureMixin
implements SpriteAtlasTextureDuck {
    private boolean dashLoaded = false;
    private DashSpriteAtlasTextureData data;
    private Map<class_2960, MutablePair<class_1058, class_1058.class_4727>> cachedSprites;

    @Inject(method={"upload(Lnet/minecraft/client/texture/SpriteAtlasTexture$Data;)V"}, at={@At(value="HEAD")})
    private void saveAtlasInfo(class_1059.class_4007 data, CallbackInfo ci) {
        if (DashLoader.DL.isWrite()) {
            DashLoader.DL.getData().getWriteContextData().atlasData.put((Object)((class_1059)this), (Object)new DashSpriteAtlasTextureData(data));
        }
    }

    @Redirect(method={"stitch"}, at=@At(value="NEW", target="Lnet/minecraft/client/texture/TextureStitcher;<init>"))
    private class_1055 textureStitcher(int maxWidth, int maxHeight, int mipLevel) {
        if (this.dashLoaded) {
            return new FakeTextureStitcher(this.data.width(), this.data.height(), this.data.mipLevel(), this.cachedSprites);
        }
        return new class_1055(maxWidth, maxHeight, mipLevel);
    }

    @Inject(method={"method_18160*"}, at={@At(value="HEAD")}, cancellable=true)
    private void loadSpriteInfo(class_2960 identifier, class_3300 resourceManager, Queue<class_1058.class_4727> queue, CallbackInfo ci) {
        if (this.dashLoaded) {
            MutablePair<class_1058, class_1058.class_4727> entry = this.cachedSprites.get(identifier);
            if (entry != null) {
                class_1058 cached = (class_1058)entry.left;
                class_1058.class_4727 info = new class_1058.class_4727(identifier, cached.method_4578(), cached.method_4595(), class_1079.field_21768);
                ((SpriteInfoDuck)info).setCached(cached);
                entry.right = info;
                queue.add(info);
                ci.cancel();
            } else {
                DashLoader.DL.log.warn("Could not find cached sprite {}. This may cause huge visual issues and/or NPE.", (Object)identifier);
            }
        }
    }

    @Inject(method={"loadSprite*"}, at={@At(value="HEAD")}, cancellable=true)
    private void loadSprite(class_3300 container, class_1058.class_4727 info, int atlasWidth, int atlasHeight, int maxLevel, int x, int y, CallbackInfoReturnable<class_1058> cir) {
        class_1058 cached = ((SpriteInfoDuck)info).getCached();
        if (cached != null) {
            SpriteAccessor access = (SpriteAccessor)cached;
            access.setAtlas((class_1059)this);
            access.setId(info.method_24121());
            cir.setReturnValue((Object)cached);
        }
    }

    @Inject(method={"clear"}, at={@At(value="TAIL")})
    private void clearAtlas(CallbackInfo ci) {
        this.dashLoaded = false;
        this.data = null;
        this.cachedSprites = null;
    }

    @Override
    public void dashLoaded(DashSpriteAtlasTextureData data, Map<class_2960, class_1058> sprites) {
        this.dashLoaded = true;
        this.data = data;
        this.cachedSprites = new HashMap<class_2960, MutablePair<class_1058, class_1058.class_4727>>();
        sprites.forEach((identifier, sprite) -> this.cachedSprites.put((class_2960)identifier, (MutablePair<class_1058, class_1058.class_4727>)new MutablePair(sprite, null)));
    }

    @Override
    public Map<class_2960, MutablePair<class_1058, class_1058.class_4727>> getCachedSprites() {
        return this.cachedSprites;
    }
}

