/*
 * Decompiled with CFR 0.152.
 */
package dev.quantumfusion.dashloader.io.serializer;

import com.github.luben.zstd.Zstd;
import dev.quantumfusion.dashloader.DashLoader;
import dev.quantumfusion.dashloader.DashObjectClass;
import dev.quantumfusion.dashloader.Dashable;
import dev.quantumfusion.dashloader.registry.chunk.data.AbstractDataChunk;
import dev.quantumfusion.dashloader.registry.chunk.data.DataChunk;
import dev.quantumfusion.dashloader.registry.chunk.data.StagedDataChunk;
import dev.quantumfusion.hyphen.ClassDefiner;
import dev.quantumfusion.hyphen.HyphenSerializer;
import dev.quantumfusion.hyphen.SerializerFactory;
import dev.quantumfusion.hyphen.io.ByteBufferIO;
import dev.quantumfusion.hyphen.io.IOInterface;
import dev.quantumfusion.hyphen.scan.annotations.DataSubclasses;
import dev.quantumfusion.taski.Task;
import dev.quantumfusion.taski.builtin.StepTask;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.FileChannel;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DashSerializer<O> {
    private static final int HEADER_SIZE = 5;
    private final Class<O> dataClass;
    private final HyphenSerializer<ByteBufferIO, O> serializer;
    private final byte compressionLevel;

    public DashSerializer(Class<O> dataClass, HyphenSerializer<ByteBufferIO, O> serializer) {
        this.dataClass = dataClass;
        this.serializer = serializer;
        this.compressionLevel = DashLoader.DL.config.config.compression;
    }

    public static <F> DashSerializer<F> create(Path cacheArea, Class<F> holderClass, List<DashObjectClass<?, ?>> dashObjects, Class<? extends Dashable<?>>[] dashables) {
        Path serializerFileLocation = cacheArea.resolve(holderClass.getSimpleName().toLowerCase() + ".dlc");
        DashSerializer.prepareFile(serializerFileLocation);
        if (Files.exists(serializerFileLocation, new LinkOption[0])) {
            ClassDefiner classDefiner = new ClassDefiner(Thread.currentThread().getContextClassLoader());
            try {
                classDefiner.def(DashSerializer.getSerializerName(holderClass), Files.readAllBytes(serializerFileLocation));
                return new DashSerializer<F>(holderClass, ClassDefiner.SERIALIZER);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        SerializerFactory factory = SerializerFactory.createDebug(ByteBufferIO.class, holderClass);
        factory.addGlobalAnnotation(AbstractDataChunk.class, DataSubclasses.class, (Object)new Class[]{DataChunk.class, StagedDataChunk.class});
        factory.setClassName(DashSerializer.getSerializerName(holderClass));
        factory.setExportPath(serializerFileLocation);
        for (Class<? extends Dashable<?>> dashable : dashables) {
            ArrayList dashClasses = new ArrayList();
            for (DashObjectClass<?, ?> dashObject : dashObjects) {
                if (dashable != dashObject.getTag()) continue;
                dashClasses.add(dashObject.getDashClass());
            }
            dashClasses.remove(dashable);
            if (dashClasses.size() <= 0) continue;
            factory.addGlobalAnnotation(dashable, DataSubclasses.class, dashClasses.toArray(Class[]::new));
        }
        return new DashSerializer<F>(holderClass, factory.build());
    }

    @NotNull
    private static <O> String getSerializerName(Class<O> holderClass) {
        return holderClass.getSimpleName().toLowerCase() + "-serializer";
    }

    private static void prepareFile(Path path) {
        try {
            Files.createDirectories(path.getParent(), new FileAttribute[0]);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void encode(O object, Path subCache, @Nullable Consumer<Task> taskConsumer) throws IOException {
        StepTask task = new StepTask(this.dataClass.getSimpleName(), this.compressionLevel > 0 ? 5 : 2);
        if (taskConsumer != null) {
            taskConsumer.accept((Task)task);
        }
        Path outPath = this.getFilePath(subCache);
        DashSerializer.prepareFile(outPath);
        try (FileChannel channel = FileChannel.open(outPath, StandardOpenOption.CREATE, StandardOpenOption.WRITE, StandardOpenOption.READ);){
            int rawFileSize = this.serializer.measure(object);
            if (this.compressionLevel > 0) {
                long maxSize = Zstd.compressBound((long)rawFileSize);
                ByteBufferIO dst = ByteBufferIO.createDirect((int)((int)maxSize));
                ByteBufferIO src = ByteBufferIO.createDirect((int)rawFileSize);
                task.next();
                this.serializer.put((IOInterface)src, object);
                task.next();
                src.rewind();
                long size = Zstd.compress((ByteBuffer)dst.byteBuffer, (ByteBuffer)src.byteBuffer, (int)this.compressionLevel);
                task.next();
                dst.rewind();
                dst.byteBuffer.limit((int)size);
                ByteBuffer map = channel.map(FileChannel.MapMode.READ_WRITE, 0L, size + 5L).order(ByteOrder.LITTLE_ENDIAN);
                task.next();
                map.put(this.compressionLevel);
                map.putInt(rawFileSize);
                map.put(dst.byteBuffer);
                src.close();
                dst.close();
            } else {
                ByteBuffer map = channel.map(FileChannel.MapMode.READ_WRITE, 0L, rawFileSize + 1).order(ByteOrder.LITTLE_ENDIAN);
                task.next();
                ByteBufferIO file = ByteBufferIO.wrap((ByteBuffer)map);
                file.putByte(this.compressionLevel);
                this.serializer.put((IOInterface)file, object);
            }
        }
        task.next();
    }

    @NotNull
    private Path getFilePath(Path subCache) {
        return subCache.resolve(this.dataClass.getSimpleName().toLowerCase() + ".dld");
    }

    public O decode(Path subCache, @Nullable Consumer<Task> taskConsumer) throws IOException {
        DashSerializer.prepareFile(subCache);
        StepTask task = new StepTask(this.dataClass.getSimpleName(), 4);
        if (taskConsumer != null) {
            taskConsumer.accept((Task)task);
        }
        try (FileChannel channel = FileChannel.open(this.getFilePath(subCache), new OpenOption[0]);){
            task.next();
            ByteBuffer buffer = channel.map(FileChannel.MapMode.READ_ONLY, 0L, channel.size()).order(ByteOrder.LITTLE_ENDIAN);
            task.next();
            byte compression = buffer.get();
            if (compression > 0) {
                int size = buffer.getInt();
                ByteBufferIO dst = ByteBufferIO.createDirect((int)size);
                Zstd.decompress((ByteBuffer)dst.byteBuffer, (ByteBuffer)buffer);
                task.next();
                dst.rewind();
                Object object = this.serializer.get((IOInterface)dst);
                task.next();
                dst.close();
                Object object2 = object;
                return (O)object2;
            }
            task.next();
            Object object = this.serializer.get((IOInterface)ByteBufferIO.wrap((ByteBuffer)buffer));
            task.next();
            Object object3 = object;
            return (O)object3;
        }
    }
}

