/*
 * Decompiled with CFR 0.152.
 */
package dev.quantumfusion.dashloader.io;

import dev.quantumfusion.dashloader.io.SubCacheArea;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.List;

public class CacheArea {
    public final List<SubCacheArea> subCaches;
    public final String name;

    public CacheArea(List<SubCacheArea> subCaches, String name) {
        this.subCaches = subCaches;
        this.name = name;
    }

    public Path getPath(Path cacheDir, SubCacheArea subCacheArea) {
        return cacheDir.resolve(this.name + "/" + subCacheArea.name + "/");
    }

    public void clear(Path cacheDir) {
        for (SubCacheArea subCache : this.subCaches) {
            Path path = this.getPath(cacheDir, subCache);
            try {
                Files.deleteIfExists(path);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        try {
            Files.deleteIfExists(cacheDir.resolve(this.name + "/"));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.name).append('\n');
        for (SubCacheArea subCache : this.subCaches) {
            sb.append("\t").append(subCache.name).append(" | ").append(subCache.used).append('\n');
        }
        return sb.toString();
    }
}

