/*
 * Decompiled with CFR 0.152.
 */
package dev.quantumfusion.dashloader.data.image;

import dev.quantumfusion.dashloader.data.image.DashSpriteAnimationFrame;
import dev.quantumfusion.dashloader.data.image.DashSpriteInterpolation;
import dev.quantumfusion.dashloader.mixin.accessor.SpriteAnimationAccessor;
import dev.quantumfusion.dashloader.registry.RegistryReader;
import dev.quantumfusion.dashloader.registry.RegistryWriter;
import dev.quantumfusion.dashloader.util.DashUtil;
import dev.quantumfusion.hyphen.scan.annotations.DataNullable;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_1058;

public class DashSpriteAnimation {
    public final List<DashSpriteAnimationFrame> frames;
    public final int frameCount;
    @DataNullable
    public final DashSpriteInterpolation interpolation;

    public DashSpriteAnimation(List<DashSpriteAnimationFrame> frames, int frameCount, DashSpriteInterpolation interpolation) {
        this.frames = frames;
        this.frameCount = frameCount;
        this.interpolation = interpolation;
    }

    public DashSpriteAnimation(class_1058.class_5790 animation, RegistryWriter registry) {
        SpriteAnimationAccessor access = (SpriteAnimationAccessor)animation;
        this.frames = new ArrayList<DashSpriteAnimationFrame>();
        for (class_1058.class_5791 frame : access.getFrames()) {
            this.frames.add(new DashSpriteAnimationFrame(frame));
        }
        this.frameCount = access.getFrameCount();
        this.interpolation = DashUtil.nullable(access.getInterpolation(), registry, DashSpriteInterpolation::new);
    }

    public class_1058.class_5790 export(class_1058 owner, RegistryReader registry) {
        ArrayList<class_1058.class_5791> framesOut = new ArrayList<class_1058.class_5791>();
        for (DashSpriteAnimationFrame frame : this.frames) {
            framesOut.add(frame.export(registry));
        }
        return SpriteAnimationAccessor.init(owner, framesOut, this.frameCount, DashUtil.nullable(this.interpolation, interpolation -> interpolation.export(owner, registry)));
    }
}

