/*
 * Decompiled with CFR 0.152.
 */
package dev.quantumfusion.dashloader.data.image;

import dev.quantumfusion.dashloader.Dashable;
import dev.quantumfusion.dashloader.api.DashObject;
import dev.quantumfusion.dashloader.mixin.accessor.NativeImageAccessor;
import dev.quantumfusion.dashloader.registry.RegistryReader;
import java.io.IOException;
import java.nio.ByteBuffer;
import net.minecraft.class_1011;
import org.lwjgl.system.MemoryUtil;

@DashObject(value=class_1011.class)
public class DashImage
implements Dashable<class_1011> {
    public final byte[] image;
    public final class_1011.class_1012 format;
    public final boolean useSTB;
    public final int width;
    public final int height;

    public DashImage(class_1011 nativeImage) {
        try {
            NativeImageAccessor nativeImageAccess = (NativeImageAccessor)nativeImage;
            this.format = nativeImage.method_4318();
            this.width = nativeImage.method_4307();
            this.height = nativeImage.method_4323();
            this.image = this.write(nativeImageAccess.getPointer());
            this.useSTB = nativeImageAccess.getIsStbImage();
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to create image. Reason: ", e);
        }
    }

    public DashImage(byte[] image, class_1011.class_1012 format, boolean useSTB, int width, int height) {
        this.image = image;
        this.format = format;
        this.useSTB = useSTB;
        this.width = width;
        this.height = height;
    }

    private byte[] write(long pointer) throws IOException {
        int capacity = this.width * this.height * this.format.method_4335();
        ByteBuffer byteBuffer = MemoryUtil.memByteBuffer((long)pointer, (int)capacity);
        byte[] bytes = new byte[capacity];
        byteBuffer.get(bytes);
        return bytes;
    }

    @Override
    public final class_1011 export(RegistryReader registry) {
        ByteBuffer buf = MemoryUtil.memAlloc((int)this.image.length);
        buf.put(this.image);
        buf.rewind();
        return NativeImageAccessor.init(this.format, this.width, this.height, this.useSTB, MemoryUtil.memAddress((ByteBuffer)buf));
    }
}

