/*
 * Decompiled with CFR 0.152.
 */
package dev.quantumfusion.dashloader.data.font;

import dev.quantumfusion.dashloader.api.DashObject;
import dev.quantumfusion.dashloader.common.IntIntList;
import dev.quantumfusion.dashloader.data.font.DashFont;
import dev.quantumfusion.dashloader.mixin.accessor.UnicodeTextureFontAccessor;
import dev.quantumfusion.dashloader.registry.RegistryReader;
import dev.quantumfusion.dashloader.registry.RegistryWriter;
import dev.quantumfusion.dashloader.util.UnsafeHelper;
import java.util.ArrayList;
import java.util.HashMap;
import net.minecraft.class_1011;
import net.minecraft.class_2960;
import net.minecraft.class_391;

@DashObject(value=class_391.class)
public class DashUnicodeFont
implements DashFont {
    public final IntIntList images;
    public final byte[] sizes;
    public final String template;

    public DashUnicodeFont(IntIntList images, byte[] sizes, String template) {
        this.images = images;
        this.sizes = sizes;
        this.template = template;
    }

    public DashUnicodeFont(class_391 rawFont, RegistryWriter writer) {
        this.images = new IntIntList(new ArrayList<IntIntList.IntInt>());
        UnicodeTextureFontAccessor font = (UnicodeTextureFontAccessor)rawFont;
        font.getImages().forEach((identifier, nativeImage) -> this.images.put(writer.add(identifier), writer.add(nativeImage)));
        this.sizes = font.getSizes();
        this.template = font.getTemplate();
    }

    @Override
    public class_391 export(RegistryReader handler) {
        HashMap<class_2960, class_1011> out = new HashMap<class_2960, class_1011>(this.images.list().size());
        this.images.forEach((key, value) -> out.put((class_2960)handler.get(key), (class_1011)handler.get(value)));
        class_391 font = UnsafeHelper.allocateInstance(class_391.class);
        UnicodeTextureFontAccessor accessor = (UnicodeTextureFontAccessor)font;
        accessor.setSizes(this.sizes);
        accessor.setImages(out);
        accessor.setTemplate(this.template);
        return font;
    }
}

