/*
 * Decompiled with CFR 0.152.
 */
package dev.quantumfusion.dashloader.config;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import dev.quantumfusion.dashloader.config.DashConfig;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.function.Consumer;
import org.apache.commons.io.monitor.FileAlterationListener;
import org.apache.commons.io.monitor.FileAlterationMonitor;
import org.apache.commons.io.monitor.FileAlterationObserver;
import org.jetbrains.annotations.Nullable;

public class ConfigHandler {
    private final Gson gson = new GsonBuilder().setPrettyPrinting().create();
    private final Path configPath;
    public DashConfig config = new DashConfig();
    @Nullable
    private FileAlterationObserver observer;

    public ConfigHandler(Path configPath) {
        this.configPath = configPath;
    }

    public void reloadConfig() {
        try {
            if (Files.exists(this.configPath, new LinkOption[0])) {
                BufferedReader json = Files.newBufferedReader(this.configPath);
                this.config = (DashConfig)this.gson.fromJson((Reader)json, DashConfig.class);
                json.close();
                return;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        this.saveConfig();
    }

    public void saveConfig() {
        try {
            Files.createDirectories(this.configPath.getParent(), new FileAttribute[0]);
            BufferedWriter writer = Files.newBufferedWriter(this.configPath, StandardOpenOption.CREATE);
            this.gson.toJson((Object)this.config, (Appendable)writer);
            writer.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void addListener(final Consumer<DashConfig> configListener) {
        if (this.observer == null) {
            File directory = this.configPath.getParent().toFile();
            this.observer = new FileAlterationObserver(directory);
            FileAlterationMonitor monitor = new FileAlterationMonitor(100L);
            monitor.addObserver(this.observer);
            try {
                monitor.start();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        this.observer.addListener(new FileAlterationListener(){

            public void onStart(FileAlterationObserver observer) {
            }

            public void onDirectoryCreate(File directory) {
            }

            public void onDirectoryChange(File directory) {
            }

            public void onDirectoryDelete(File directory) {
            }

            public void onFileCreate(File file) {
            }

            public void onFileChange(File file) {
                try {
                    if (Files.isSameFile(Path.of(file.toURI()), ConfigHandler.this.configPath)) {
                        ConfigHandler.this.reloadConfig();
                        configListener.accept(ConfigHandler.this.config);
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }

            public void onFileDelete(File file) {
            }

            public void onStop(FileAlterationObserver observer) {
            }
        });
    }
}

