/*
 * Decompiled with CFR 0.152.
 */
package dev.quantumfusion.dashloader.client;

import com.mojang.blaze3d.systems.RenderSystem;
import java.awt.Color;
import java.util.Objects;
import net.minecraft.class_1041;
import net.minecraft.class_1159;
import net.minecraft.class_2561;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_290;
import net.minecraft.class_293;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_4587;
import net.minecraft.class_757;

public class UIDrawer {
    private class_4587 ms;
    private class_327 tr;
    private int width;
    private int height;
    private GradientConsumer gradientConsumer;

    public void update(class_310 client, GradientConsumer gradientConsumer) {
        this.gradientConsumer = gradientConsumer;
        class_1041 window = client.method_22683();
        this.width = window.method_4486();
        this.height = window.method_4502();
    }

    public void push(class_4587 matrixStack, class_327 textRenderer) {
        this.ms = matrixStack;
        this.tr = textRenderer;
    }

    public void drawQuad(Color color, int x, int y, int width, int height) {
        int x2 = width + x;
        int y2 = height + y;
        class_332.method_25294((class_4587)this.ms, (int)x, (int)y, (int)x2, (int)y2, (int)(color.getRGB() | 0xFF000000));
    }

    public void drawGradient(GradientOrientation orientation, Color colorStart, Color colorEnd, int x, int y, int width, int height) {
        int x2 = width + x;
        int y2 = height + y;
        this.drawInternalGradient(orientation, x, y, x2, y2, colorStart, colorEnd);
    }

    private void drawInternalGradient(GradientOrientation orientation, int startX, int startY, int endX, int endY, Color colorStart, Color colorEnd) {
        RenderSystem.disableTexture();
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.setShader(class_757::method_34540);
        class_289 tessellator = class_289.method_1348();
        class_287 bufferBuilder = tessellator.method_1349();
        bufferBuilder.method_1328(class_293.class_5596.field_27382, class_290.field_1576);
        this.fillGradient(orientation, this.ms.method_23760().method_23761(), bufferBuilder, startX, startY, endX, endY, colorStart, colorEnd);
        tessellator.method_1350();
        RenderSystem.disableBlend();
        RenderSystem.enableTexture();
    }

    private void fillGradient(GradientOrientation orientation, class_1159 b4, class_287 bb, int startX, int startY, int endX, int endY, Color colorStart, Color colorEnd) {
        int ordinal = orientation.ordinal();
        UIDrawer.drawVertex(b4, bb, endX, startY, ordinal == 0 || ordinal == 3 ? colorStart : colorEnd);
        UIDrawer.drawVertex(b4, bb, startX, startY, ordinal == 1 || ordinal == 0 ? colorStart : colorEnd);
        UIDrawer.drawVertex(b4, bb, startX, endY, ordinal == 2 || ordinal == 1 ? colorStart : colorEnd);
        UIDrawer.drawVertex(b4, bb, endX, endY, ordinal == 3 || ordinal == 4 ? colorStart : colorEnd);
    }

    private static void drawVertex(class_1159 m4f, class_287 bb, int x, int y, Color color) {
        bb.method_22918(m4f, (float)x, (float)y, 0.0f).method_1336(color.getRed(), color.getGreen(), color.getBlue(), color.getAlpha()).method_1344();
    }

    public void drawText(TextOrientation orientation, String text, Color color, int x, int y) {
        switch (orientation) {
            case TEXT_LEFT: {
                this.drawInternalText(text, color, x, y);
                break;
            }
            case TEXT_CENTER: {
                this.drawInternalText(text, color, x - this.tr.method_1727(text) / 2, y);
                break;
            }
            case TEXT_RIGHT: {
                this.drawInternalText(text, color, x - this.tr.method_1727(text), y);
            }
        }
    }

    public int getHeight() {
        return this.height;
    }

    public int getWidth() {
        return this.width;
    }

    private void drawInternalText(String text, Color color, int xDraw, int yDraw) {
        class_2561 class_25612 = class_2561.method_30163((String)text);
        Objects.requireNonNull(this.tr);
        class_332.method_27535((class_4587)this.ms, (class_327)this.tr, (class_2561)class_25612, (int)xDraw, (int)(yDraw - 9 / 2), (int)(color.getRGB() | 0xFF000000));
    }

    @FunctionalInterface
    public static interface GradientConsumer {
        public void fillGradient(class_4587 var1, int var2, int var3, int var4, int var5, int var6, int var7);
    }

    public static enum GradientOrientation {
        GRADIENT_TOP(0, -1),
        GRADIENT_LEFT(-1, 0),
        GRADIENT_DOWN(0, 1),
        GRADIENT_RIGHT(1, 0);

        public final int xDir;
        public final int yDir;

        private GradientOrientation(int xDir, int yDir) {
            this.xDir = xDir;
            this.yDir = yDir;
        }
    }

    public static enum TextOrientation {
        TEXT_LEFT,
        TEXT_CENTER,
        TEXT_RIGHT;

    }
}

