/*
 * Decompiled with CFR 0.152.
 */
package dev.quantumfusion.dashloader.client;

import dev.quantumfusion.dashloader.config.DashConfig;
import java.awt.Color;
import java.util.HashMap;
import java.util.Map;

public class UIColors {
    public static Color BACKGROUND_COLOR = null;
    public static Color PROGRESS_LANE_COLOR = null;
    public static Color TEXT_COLOR = null;
    public static Map<String, Color> COLORS = new HashMap<String, Color>();
    public static Color[] PROGRESS_COLORS = null;

    public static Color parseColor(String str) {
        if (COLORS.containsKey(str.toLowerCase())) {
            return COLORS.get(str.toLowerCase());
        }
        try {
            return Color.decode(str.toUpperCase());
        }
        catch (NumberFormatException formatException) {
            return Color.MAGENTA;
        }
    }

    public static void loadConfig(DashConfig config) {
        COLORS.clear();
        config.colorVariables.forEach((s, s2) -> COLORS.put((String)s, Color.decode(s2)));
        String[] progressColors = config.progressColors;
        if (progressColors.length == 0) {
            throw new RuntimeException("Progress Colors length is 0");
        }
        PROGRESS_COLORS = new Color[progressColors.length];
        for (int i = 0; i < progressColors.length; ++i) {
            UIColors.PROGRESS_COLORS[i] = UIColors.parseColor(progressColors[i]);
        }
        BACKGROUND_COLOR = UIColors.parseColor(config.backgroundColor);
        PROGRESS_LANE_COLOR = UIColors.parseColor(config.progressTrackColor);
        TEXT_COLOR = UIColors.parseColor(config.foregroundColor);
    }

    public static Color getProgressColor(double progress) {
        return UIColors.mix(progress, PROGRESS_COLORS);
    }

    public static Color mix(double pos, Color ... colors) {
        if (colors.length == 1) {
            return colors[0];
        }
        pos = Math.min(1.0, Math.max(0.0, pos));
        int breaks = colors.length - 1;
        if (pos == 1.0) {
            return colors[breaks];
        }
        int colorPos = (int)Math.floor(pos * (double)breaks);
        double step = 1.0 / (double)breaks;
        double localRatio = pos % step * (double)breaks;
        return UIColors.blend(colors[colorPos], colors[colorPos + 1], localRatio);
    }

    public static Color blend(Color i1, Color i2, double ratio) {
        if (ratio > 1.0) {
            ratio = 1.0;
        } else if (ratio < 0.0) {
            ratio = 0.0;
        }
        double iRatio = 1.0 - ratio;
        int a = (int)((double)i1.getAlpha() * iRatio + (double)i2.getAlpha() * ratio);
        int r = (int)((double)i1.getRed() * iRatio + (double)i2.getRed() * ratio);
        int g = (int)((double)i1.getGreen() * iRatio + (double)i2.getGreen() * ratio);
        int b = (int)((double)i1.getBlue() * iRatio + (double)i2.getBlue() * ratio);
        return new Color(r, g, b, a);
    }

    public static void print(int color) {
        int r2 = (color & 0xFF0000) >> 16;
        int g2 = (color & 0xFF00) >> 8;
        int b2 = color & 0xFF;
        System.out.println("\u001b[48;2;" + r2 + ";" + g2 + ";" + b2 + "m");
    }
}

