/*
 * Decompiled with CFR 0.152.
 */
package dev.quantumfusion.dashloader.client;

import com.mojang.blaze3d.systems.RenderSystem;
import dev.quantumfusion.dashloader.DashLoader;
import dev.quantumfusion.dashloader.ProgressHandler;
import dev.quantumfusion.dashloader.client.HahaManager;
import dev.quantumfusion.dashloader.client.UIColors;
import dev.quantumfusion.dashloader.client.UIDrawer;
import dev.quantumfusion.dashloader.config.DashConfig;
import dev.quantumfusion.taski.builtin.StaticTask;
import java.awt.Color;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Random;
import net.minecraft.class_1159;
import net.minecraft.class_2561;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_290;
import net.minecraft.class_293;
import net.minecraft.class_310;
import net.minecraft.class_437;
import net.minecraft.class_4587;
import net.minecraft.class_757;
import org.apache.commons.lang3.tuple.Pair;

public class DashCachingScreen
extends class_437 {
    public static final List<String> SUPPORTERS = new ArrayList<String>();
    public static Status STATUS = Status.IDLE;
    private static final Color FAILED_COLOR = new Color(255, 75, 69);
    private final class_437 previousScreen;
    private final Random random = new Random();
    private final UIDrawer drawer = new UIDrawer();
    private final List<Line> lines = new ArrayList<Line>();
    private final List<Pair<Color, Integer>> lineColorSelectors = new ArrayList<Pair<Color, Integer>>();
    private float weight = 0.0f;
    private boolean debug;
    private int padding;
    private int progressBarHeight = 0;
    private float lineSpeedDifference = 0.0f;
    private boolean configRequiresUpdate = false;
    private final String fact = HahaManager.getFact();
    private long oldTime = System.currentTimeMillis();

    public DashCachingScreen(class_437 previousScreen) {
        super(class_2561.method_30163((String)"Caching"));
        UIColors.loadConfig(DashLoader.DL.config.config);
        this.previousScreen = previousScreen;
        this.drawer.update(class_310.method_1551(), (x$0, x$1, x$2, x$3, x$4, x$5, x$6) -> this.method_25296(x$0, x$1, x$2, x$3, x$4, x$5, x$6));
        this.updateConfig();
    }

    private void updateConfig() {
        int toRemove;
        String lineDirection;
        DashConfig config = DashLoader.DL.config.config;
        UIColors.loadConfig(config);
        this.padding = config.paddingSize;
        this.debug = config.debugMode;
        this.progressBarHeight = config.progressBarHeight;
        this.lineSpeedDifference = config.lineSpeedDifference;
        int lineAmount = config.lineAmount;
        this.weight = 0.0f;
        this.lineColorSelectors.clear();
        config.lineColors.forEach((s, integer) -> {
            this.weight += (float)integer.intValue();
            this.lineColorSelectors.add((Pair<Color, Integer>)Pair.of((Object)UIColors.parseColor(s), (Object)integer));
        });
        UIDrawer.GradientOrientation lineOrientation = UIDrawer.GradientOrientation.GRADIENT_LEFT;
        switch (lineDirection = config.lineDirection) {
            case "UP": {
                lineOrientation = UIDrawer.GradientOrientation.GRADIENT_TOP;
                break;
            }
            case "LEFT": {
                lineOrientation = UIDrawer.GradientOrientation.GRADIENT_LEFT;
                break;
            }
            case "RIGHT": {
                lineOrientation = UIDrawer.GradientOrientation.GRADIENT_RIGHT;
                break;
            }
            case "DOWN": {
                lineOrientation = UIDrawer.GradientOrientation.GRADIENT_DOWN;
                break;
            }
            default: {
                DashLoader.DL.log.error("Direction {} does not exist. (LEFT, RIGHT, UP, DOWN)", (Object)lineDirection);
            }
        }
        this.lineSpeedDifference = config.lineSpeedDifference;
        if (lineAmount > this.lines.size()) {
            for (int i = 0; i < lineAmount - this.lines.size(); ++i) {
                this.lines.add(new Line());
            }
        } else if (lineAmount < this.lines.size() && (toRemove = this.lines.size() - lineAmount) > 0) {
            this.lines.subList(0, toRemove).clear();
        }
        for (Line line : this.lines) {
            line.speed = config.lineSpeed;
            line.width = config.lineWidth;
            int bound = config.lineMaxHeight - config.lineMinHeight;
            line.height = config.lineMinHeight + (bound > 0 ? this.random.nextInt(bound) : 0);
            line.orientation = lineOrientation;
            line.updateStep();
        }
        if (this.debug) {
            DashLoader.DL.progress.setCurrentTask("debug");
            DashLoader.DL.config.addListener(listener -> {
                this.configRequiresUpdate = true;
            });
        }
    }

    public boolean method_25422() {
        return false;
    }

    public Color getLineColor() {
        float target = this.random.nextFloat() * this.weight;
        float countWeight = 0.0f;
        for (Pair<Color, Integer> item : this.lineColorSelectors) {
            if (!((countWeight += (float)((Integer)item.getValue()).intValue()) >= target)) continue;
            return (Color)item.getKey();
        }
        throw new RuntimeException("Could not get line color.");
    }

    protected void method_25426() {
        if (!this.debug) {
            Thread thread = new Thread(DashLoader.DL::saveDashCache);
            thread.setName("dld-thread");
            thread.start();
        }
    }

    public boolean method_25404(int keyCode, int scanCode, int modifiers) {
        if (keyCode == 257 && STATUS == Status.CRASHED) {
            STATUS = Status.DONE;
        }
        return super.method_25404(keyCode, scanCode, modifiers);
    }

    public void method_25394(class_4587 matrices, int mouseX, int mouseY, float delta) {
        Color currentProgressColor;
        double currentProgress;
        if (STATUS == Status.DONE && !this.debug) {
            class_310.method_1551().method_1507(this.previousScreen);
            DashLoader.DL.resetDashLoader();
            STATUS = Status.IDLE;
        }
        if (this.configRequiresUpdate) {
            this.updateConfig();
            this.configRequiresUpdate = false;
        }
        this.drawer.push(matrices, this.field_22793);
        int width = this.drawer.getWidth();
        int height = this.drawer.getHeight();
        int barY = height - this.padding - this.progressBarHeight;
        if (this.debug) {
            currentProgress = Math.max(Math.min(1.0, (double)mouseX / (double)width), 0.0);
            currentProgressColor = UIColors.getProgressColor(currentProgress);
        } else if (STATUS == Status.CRASHED) {
            ProgressHandler.TASK = new StaticTask("Crash", 1.0f);
            DashLoader.DL.progress.setCurrentTask("Internal crash. Please check logs or press ENTER.");
            currentProgress = DashLoader.DL.progress.getProgress();
            currentProgressColor = FAILED_COLOR;
        } else {
            currentProgress = DashLoader.DL.progress.getProgress();
            currentProgressColor = UIColors.getProgressColor(currentProgress);
        }
        this.drawer.drawQuad(UIColors.BACKGROUND_COLOR, 0, 0, width, height);
        while (this.oldTime < System.currentTimeMillis()) {
            for (Line line : this.lines) {
                line.tick();
            }
            this.oldTime += 17L;
        }
        this.drawLines(this.lines, matrices);
        this.drawer.drawQuad(UIColors.PROGRESS_LANE_COLOR, 0, barY, width, this.progressBarHeight);
        this.drawer.drawQuad(currentProgressColor, 0, barY, (int)((double)width * currentProgress), this.progressBarHeight);
        this.drawer.drawText(UIDrawer.TextOrientation.TEXT_LEFT, DashLoader.DL.progress.getCurrentTask(), UIColors.TEXT_COLOR, this.padding, barY - this.padding);
        Objects.requireNonNull(this.field_22793);
        this.drawer.drawText(UIDrawer.TextOrientation.TEXT_LEFT, this.fact, UIColors.TEXT_COLOR, this.padding, this.padding + 9);
        super.method_25394(matrices, mouseX, mouseY, delta);
    }

    public void method_25410(class_310 client, int width, int height) {
        super.method_25410(client, width, height);
        this.drawer.update(client, (x$0, x$1, x$2, x$3, x$4, x$5, x$6) -> this.method_25296(x$0, x$1, x$2, x$3, x$4, x$5, x$6));
    }

    private void drawLines(List<Line> lines, class_4587 ms) {
        RenderSystem.disableTexture();
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.setShader(class_757::method_34540);
        class_289 tessellator = class_289.method_1348();
        class_287 bufferBuilder = tessellator.method_1349();
        bufferBuilder.method_1328(class_293.class_5596.field_27382, class_290.field_1576);
        for (Line line : lines) {
            Color color = line.color;
            Color end = new Color(color.getRed(), color.getGreen(), color.getBlue(), 0);
            if (STATUS == Status.CRASHED) {
                color = FAILED_COLOR.darker().darker();
            }
            this.fillGradient(line.orientation, ms.method_23760().method_23761(), bufferBuilder, (int)line.x, (int)line.y, (int)line.x + line.width, (int)line.y + line.height, color, end);
        }
        tessellator.method_1350();
        RenderSystem.disableBlend();
        RenderSystem.enableTexture();
    }

    private void fillGradient(UIDrawer.GradientOrientation orientation, class_1159 b4, class_287 bb, int startX, int startY, int endX, int endY, Color colorStart, Color colorEnd) {
        int ordinal = orientation.ordinal();
        DashCachingScreen.drawVertex(b4, bb, endX, startY, ordinal == 0 || ordinal == 3 ? colorStart : colorEnd);
        DashCachingScreen.drawVertex(b4, bb, startX, startY, ordinal == 1 || ordinal == 0 ? colorStart : colorEnd);
        DashCachingScreen.drawVertex(b4, bb, startX, endY, ordinal == 2 || ordinal == 1 ? colorStart : colorEnd);
        DashCachingScreen.drawVertex(b4, bb, endX, endY, ordinal == 3 || ordinal == 4 ? colorStart : colorEnd);
    }

    private static void drawVertex(class_1159 m4f, class_287 bb, int x, int y, Color color) {
        bb.method_22918(m4f, (float)x, (float)y, 0.0f).method_1336(color.getRed(), color.getGreen(), color.getBlue(), color.getAlpha()).method_1344();
    }

    static {
        try (InputStream input = URI.create("https://quantumfusion.dev/supporters.txt").toURL().openStream();){
            String s = new String(input.readAllBytes(), StandardCharsets.UTF_8);
            SUPPORTERS.addAll(Arrays.asList(s.split("\n")));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private final class Line {
        public UIDrawer.GradientOrientation orientation;
        public Color color;
        public float x;
        public float y;
        public int width;
        public int height;
        public float speed;
        public float xStep;
        public float yStep;

        public Line() {
            this(UIDrawer.GradientOrientation.GRADIENT_LEFT, -100.0f, -100.0f, 0, 0, Color.WHITE, 1.0f);
        }

        private Line(UIDrawer.GradientOrientation orientation, float x, float y, int width, int height, Color color, float speed) {
            this.orientation = orientation;
            this.x = x;
            this.y = y;
            this.width = width;
            this.height = height;
            this.color = color;
            this.speed = speed;
        }

        public void tick() {
            this.x += this.xStep;
            this.y += this.yStep;
            int screenHeight = DashCachingScreen.this.drawer.getHeight();
            int screenWidth = DashCachingScreen.this.drawer.getWidth();
            if (this.x - (float)this.width > (float)screenWidth) {
                this.x = 0.0f;
                this.y = DashCachingScreen.this.random.nextInt(screenHeight);
                this.update();
            } else if (this.x + (float)this.width < 0.0f) {
                this.x = screenWidth;
                this.y = DashCachingScreen.this.random.nextInt(screenHeight);
                this.update();
            } else if (this.y - (float)this.height > (float)screenHeight) {
                this.y = -this.height;
                this.x = DashCachingScreen.this.random.nextInt(screenWidth);
                this.update();
            } else if (this.y + (float)this.height < 0.0f) {
                this.y = screenHeight;
                this.x = DashCachingScreen.this.random.nextInt(screenWidth);
                this.update();
            }
        }

        private void update() {
            this.updateColor();
            this.updateStep();
        }

        private void updateColor() {
            this.color = DashCachingScreen.this.getLineColor();
        }

        private void updateStep() {
            this.xStep = (float)this.orientation.xDir * (this.speed * (1.0f + DashCachingScreen.this.random.nextFloat() * DashCachingScreen.this.lineSpeedDifference)) / 2.0f;
            this.yStep = (float)this.orientation.yDir * (this.speed * (1.0f + DashCachingScreen.this.random.nextFloat() * DashCachingScreen.this.lineSpeedDifference)) / 2.0f;
        }
    }

    public static enum Status {
        IDLE,
        CACHING,
        CRASHED,
        DONE;

    }
}

