/*
 * Decompiled with CFR 0.152.
 */
package dev.quantumfusion.dashloader.api.option;

import dev.quantumfusion.dashloader.DashLoader;
import dev.quantumfusion.dashloader.api.option.Option;
import java.util.EnumMap;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.ModContainer;
import net.fabricmc.loader.api.metadata.CustomValue;
import net.fabricmc.loader.api.metadata.ModMetadata;

public class ConfigHandler {
    private static final EnumMap<Option, Boolean> OPTION_ACTIVE = new EnumMap(Option.class);
    private static final String DISABLE_OPTION_TAG = "dashloader:disableoption";

    public static void update() {
        OPTION_ACTIVE.put(Option.FAST_STATE_INIT, false);
        DashLoader.DL.config.reloadConfig();
        DashLoader.DL.config.config.options.forEach((s, aBoolean) -> {
            try {
                Option option = Option.valueOf(s.toUpperCase());
                OPTION_ACTIVE.put(option, false);
                DashLoader.DL.log.warn("Disabled Optional Feature {} from DashLoader config.", s);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                DashLoader.DL.log.error("Could not disable Optional Feature {} as it does not exist.", s);
            }
        });
        for (ModContainer modContainer : FabricLoader.getInstance().getAllMods()) {
            ModMetadata mod = modContainer.getMetadata();
            if (!mod.containsCustomValue(DISABLE_OPTION_TAG)) continue;
            for (CustomValue value : mod.getCustomValue(DISABLE_OPTION_TAG).getAsArray()) {
                String feature = value.getAsString();
                try {
                    Option option = Option.valueOf(feature.toUpperCase());
                    OPTION_ACTIVE.put(option, false);
                    DashLoader.DL.log.warn("Disabled Optional Feature {} from {} config. {}", (Object)feature, (Object)mod.getId(), (Object)mod.getName());
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    DashLoader.DL.log.error("Could not disable Optional Feature {} as it does not exist.", (Object)feature);
                }
            }
        }
    }

    public static boolean shouldApplyMixin(String name) {
        for (Option value : Option.values()) {
            if (!name.contains(value.mixinContains)) continue;
            return OPTION_ACTIVE.get((Object)value);
        }
        return true;
    }

    public static String getJsonName(Option option) {
        char[] name = option.name().toCharArray();
        StringBuilder sb = new StringBuilder();
        boolean nextHighCase = false;
        for (char c : name) {
            if (c == '_') {
                nextHighCase = true;
                continue;
            }
            if (nextHighCase) {
                sb.append(Character.toUpperCase(c));
                nextHighCase = false;
                continue;
            }
            sb.append(Character.toLowerCase(c));
        }
        return sb.toString();
    }

    public static boolean optionActive(Option option) {
        return OPTION_ACTIVE.get((Object)option);
    }

    static {
        for (Option value : Option.values()) {
            OPTION_ACTIVE.put(value, true);
        }
    }
}

