/*
 * Decompiled with CFR 0.152.
 */
package dev.quantumfusion.dashloader;

import dev.quantumfusion.dashloader.DashLoader;
import dev.quantumfusion.dashloader.util.TimeUtil;
import java.lang.management.ManagementFactory;

public class ProfilerHandler {
    public long reload_start = 0L;
    public long export_time = -1L;
    public long export_file_reading_time = -1L;
    public long export_asset_exporting_time = -1L;
    public long export_asset_loading_time = -1L;
    public long fallback_models_count = -1L;
    public long cached_models_count = -1L;
    public long bootstrap_start = -1L;
    public long bootstrap_end = -1L;
    public long total_loading = -1L;

    public void print() {
        DashLoader.DL.log.info("\u250f DashLoader Statistics.");
        if (this.export_time != -1L) {
            DashLoader.DL.log.info("\u2520\u2500\u2500\u252c {} DashLoader load", (Object)TimeUtil.getTimeString(this.export_time));
            DashLoader.DL.log.info("\u2503  \u251c\u2500\u2500 {} File reading", (Object)TimeUtil.getTimeString(this.export_file_reading_time));
            DashLoader.DL.log.info("\u2503  \u251c\u2500\u2500 {} Asset exporting", (Object)TimeUtil.getTimeString(this.export_asset_exporting_time));
            DashLoader.DL.log.info("\u2503  \u2514\u2500\u2500 {} Asset loading", (Object)TimeUtil.getTimeString(this.export_asset_loading_time));
            this.export_time = -1L;
        }
        if (this.fallback_models_count != -1L) {
            long totalModels = this.cached_models_count + this.fallback_models_count;
            DashLoader.DL.log.info("\u2520\u2500\u2500\u252c {}% Cache coverage", (Object)((int)((float)this.cached_models_count / (float)totalModels * 100.0f)));
            DashLoader.DL.log.info("\u2503  \u251c\u2500\u2500 {} Fallback models", (Object)this.fallback_models_count);
            DashLoader.DL.log.info("\u2503  \u2514\u2500\u2500 {} Cached models", (Object)this.cached_models_count);
            this.cached_models_count = -1L;
            this.fallback_models_count = -1L;
        }
        DashLoader.DL.log.info("\u2520\u2500\u2500 {} Minecraft client reload", (Object)TimeUtil.getTimeStringFromStart(this.reload_start));
        DashLoader.DL.log.info("\u2520\u2500\u2500 {} Minecraft bootstrap", (Object)TimeUtil.getTimeString(this.bootstrap_end - this.bootstrap_start));
        if (this.total_loading == -1L) {
            this.total_loading = ManagementFactory.getRuntimeMXBean().getUptime();
        }
        DashLoader.DL.log.info("\u2516\u2500\u2500 {} Total loading", (Object)TimeUtil.getTimeString(this.total_loading));
    }
}

