/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.fabric.impl.client.keybinding;

import com.google.common.collect.Lists;
import it.unimi.dsi.fastutil.objects.ReferenceArrayList;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.mixin.client.keybinding.KeyBindingAccessor;
import net.minecraft.class_304;

@Environment(value=EnvType.CLIENT)
public final class KeyBindingRegistryImpl {
    private static final List<class_304> moddedKeyBindings = new ReferenceArrayList();

    private KeyBindingRegistryImpl() {
    }

    private static Map<String, Integer> getCategoryMap() {
        return KeyBindingAccessor.fabric_getCategoryMap();
    }

    private static boolean hasCategory(String categoryTranslationKey) {
        return KeyBindingRegistryImpl.getCategoryMap().containsKey(categoryTranslationKey);
    }

    public static boolean addCategory(String categoryTranslationKey) {
        Map<String, Integer> map = KeyBindingRegistryImpl.getCategoryMap();
        if (map.containsKey(categoryTranslationKey)) {
            return false;
        }
        Optional<Integer> largest = map.values().stream().max(Integer::compareTo);
        int largestInt = largest.orElse(0);
        map.put(categoryTranslationKey, largestInt + 1);
        return true;
    }

    public static class_304 registerKeyBinding(class_304 binding) {
        for (class_304 existingKeyBindings : moddedKeyBindings) {
            if (existingKeyBindings == binding) {
                throw null;
            }
            if (!existingKeyBindings.method_1431().equals(binding.method_1431())) continue;
            throw new RuntimeException("Attempted to register two key bindings with equal ID: " + binding.method_1431() + "!");
        }
        if (!KeyBindingRegistryImpl.hasCategory(binding.method_1423())) {
            KeyBindingRegistryImpl.addCategory(binding.method_1423());
        }
        return moddedKeyBindings.add(binding) ? binding : null;
    }

    public static class_304[] process(class_304[] keysAll) {
        ArrayList newKeysAll = Lists.newArrayList((Object[])keysAll);
        newKeysAll.removeAll(moddedKeyBindings);
        newKeysAll.addAll(moddedKeyBindings);
        return newKeysAll.toArray(new class_304[0]);
    }
}

