/*
 * Decompiled with CFR 0.152.
 */
package com.ishland.c2me.notickvd.common;

import com.ishland.c2me.base.mixin.access.IChunkTicketManager;
import com.ishland.c2me.notickvd.common.Config;
import com.ishland.c2me.notickvd.common.NoTickSystem;
import com.mojang.logging.LogUtils;
import it.unimi.dsi.fastutil.longs.Long2BooleanLinkedOpenHashMap;
import it.unimi.dsi.fastutil.longs.Long2BooleanMap;
import it.unimi.dsi.fastutil.longs.Long2IntOpenHashMap;
import it.unimi.dsi.fastutil.longs.LongOpenHashSet;
import it.unimi.dsi.fastutil.longs.LongSet;
import it.unimi.dsi.fastutil.objects.ObjectBidirectionalIterator;
import it.unimi.dsi.fastutil.objects.ObjectSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import net.minecraft.class_1923;
import net.minecraft.class_3196;
import net.minecraft.class_3204;
import net.minecraft.class_3230;
import net.minecraft.class_3532;
import org.slf4j.Logger;

public class PlayerNoTickDistanceMap
extends class_3196 {
    private static final Logger LOGGER = LogUtils.getLogger();
    public static final class_3230<class_1923> TICKET_TYPE = class_3230.method_14291((String)"c2me_no_tick_vd", Comparator.comparingLong(class_1923::method_8324));
    private static final int MAX_TICKET_UPDATES_PER_TICK = Config.updatesPerTick;
    private final LongSet sourceChunks = new LongOpenHashSet();
    private final Long2IntOpenHashMap distanceFromNearestPlayer = new Long2IntOpenHashMap();
    private final Long2BooleanLinkedOpenHashMap pendingTicketUpdates = new Long2BooleanLinkedOpenHashMap();
    private final LongOpenHashSet managedChunkTickets = new LongOpenHashSet();
    private final class_3204 chunkTicketManager;
    private final NoTickSystem noTickSystem;
    private volatile int viewDistance;
    private volatile int pendingTicketUpdatesCount = 0;

    public PlayerNoTickDistanceMap(class_3204 chunkTicketManager, NoTickSystem noTickSystem) {
        super(251, 16, 256);
        this.chunkTicketManager = chunkTicketManager;
        this.noTickSystem = noTickSystem;
        this.distanceFromNearestPlayer.defaultReturnValue(251);
        this.setViewDistance(12);
    }

    protected int method_14028(long chunkPos) {
        ObjectSet players = (ObjectSet)((IChunkTicketManager)this.chunkTicketManager).getPlayersByChunkPos().get(chunkPos);
        return players != null && !players.isEmpty() ? 249 - this.viewDistance : Integer.MAX_VALUE;
    }

    protected int method_15480(long chunkPos) {
        return this.distanceFromNearestPlayer.get(chunkPos);
    }

    protected void method_15485(long chunkPos, int level) {
        if (level > 249) {
            if (this.distanceFromNearestPlayer.containsKey(chunkPos)) {
                this.pendingTicketUpdates.put(chunkPos, false);
                this.distanceFromNearestPlayer.remove(chunkPos);
            }
        } else {
            if (!this.distanceFromNearestPlayer.containsKey(chunkPos)) {
                this.pendingTicketUpdates.put(chunkPos, true);
            }
            this.distanceFromNearestPlayer.put(chunkPos, level);
        }
    }

    public void addSource(class_1923 chunkPos) {
        this.method_14027(chunkPos.method_8324(), 249 - this.viewDistance, true);
        this.sourceChunks.add(chunkPos.method_8324());
    }

    public void removeSource(class_1923 chunkPos) {
        this.method_14027(chunkPos.method_8324(), Integer.MAX_VALUE, false);
        this.sourceChunks.remove(chunkPos.method_8324());
    }

    public boolean update() {
        boolean hasUpdates;
        int pendingRawUpdateCount = this.method_24208();
        if (pendingRawUpdateCount == 0) {
            return false;
        }
        boolean bl = hasUpdates = this.method_15492(Integer.MAX_VALUE) != Integer.MAX_VALUE;
        if (hasUpdates) {
            ArrayList<Long2BooleanMap.Entry> entries = new ArrayList<Long2BooleanMap.Entry>((Collection<Long2BooleanMap.Entry>)this.pendingTicketUpdates.long2BooleanEntrySet());
            entries.sort(Comparator.comparingInt(o -> this.distanceFromNearestPlayer.get(o.getLongKey())));
            for (Long2BooleanMap.Entry entry : entries) {
                this.pendingTicketUpdates.getAndMoveToLast(entry.getLongKey());
            }
        }
        this.pendingTicketUpdatesCount = this.pendingTicketUpdates.size();
        return true;
    }

    void runPendingTicketUpdates() {
        ObjectBidirectionalIterator iterator = this.pendingTicketUpdates.long2BooleanEntrySet().iterator();
        int i = 0;
        while (iterator.hasNext() && i <= MAX_TICKET_UPDATES_PER_TICK) {
            Long2BooleanMap.Entry entry = (Long2BooleanMap.Entry)iterator.next();
            long chunkPos = entry.getLongKey();
            class_1923 pos = new class_1923(chunkPos);
            if (entry.getBooleanValue()) {
                if (this.managedChunkTickets.add(chunkPos)) {
                    this.noTickSystem.noThreadScheduler.execute(() -> this.chunkTicketManager.method_17290(TICKET_TYPE, pos, 33, (Object)pos));
                    ++i;
                }
            } else if (this.managedChunkTickets.remove(chunkPos)) {
                this.noTickSystem.noThreadScheduler.execute(() -> this.chunkTicketManager.method_20444(TICKET_TYPE, pos, 33, (Object)pos));
                ++i;
            }
            iterator.remove();
        }
        this.pendingTicketUpdatesCount = this.pendingTicketUpdates.size();
    }

    public void setViewDistance(int viewDistance) {
        this.viewDistance = class_3532.method_15340((int)viewDistance, (int)3, (int)249);
        this.sourceChunks.forEach(value -> {
            this.removeSource(new class_1923(value));
            this.addSource(new class_1923(value));
        });
    }

    public int getPendingTicketUpdatesCount() {
        return this.pendingTicketUpdatesCount;
    }

    public LongSet getChunks() {
        return this.managedChunkTickets;
    }
}

