/*
 * Decompiled with CFR 0.152.
 */
package com.ishland.c2me.notickvd.common;

import com.ishland.c2me.base.mixin.access.IChunkTicket;
import com.ishland.c2me.base.mixin.access.IChunkTicketManager;
import com.ishland.c2me.notickvd.common.PlayerNoTickDistanceMap;
import it.unimi.dsi.fastutil.longs.Long2IntOpenHashMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.longs.LongSet;
import it.unimi.dsi.fastutil.objects.ObjectIterator;
import net.minecraft.class_3196;
import net.minecraft.class_3204;
import net.minecraft.class_3228;
import net.minecraft.class_4706;

public class NormalTicketDistanceMap
extends class_3196 {
    private final class_3204 chunkTicketManager;
    private final Long2IntOpenHashMap distanceMap = new Long2IntOpenHashMap();
    private final Long2ObjectOpenHashMap<class_4706<class_3228<?>>> ticketsByPosition = new Long2ObjectOpenHashMap();

    public NormalTicketDistanceMap(class_3204 chunkTicketManager) {
        super(35, 16, 256);
        this.chunkTicketManager = chunkTicketManager;
        this.distanceMap.defaultReturnValue(35);
    }

    protected int method_14028(long id) {
        class_4706 sortedArraySet = (class_4706)((IChunkTicketManager)this.chunkTicketManager).getTicketsByPosition().get(id);
        if (sortedArraySet != null) {
            if (sortedArraySet.isEmpty()) {
                return Integer.MAX_VALUE;
            }
            for (class_3228 next : sortedArraySet) {
                if (next.method_14281() == PlayerNoTickDistanceMap.TICKET_TYPE) continue;
                return next.method_14283();
            }
        }
        return Integer.MAX_VALUE;
    }

    protected int method_15480(long id) {
        return this.distanceMap.get(id);
    }

    protected void method_15485(long id, int level) {
        if (level > 33) {
            this.distanceMap.remove(id);
        } else {
            this.distanceMap.put(id, level);
        }
    }

    private static int getLevel(class_4706<class_3228<?>> sortedArraySet) {
        return !sortedArraySet.isEmpty() ? ((class_3228)sortedArraySet.method_23865()).method_14283() : Integer.MAX_VALUE;
    }

    public void addTicket(long position, class_3228<?> ticket) {
        if (ticket.method_14281() == PlayerNoTickDistanceMap.TICKET_TYPE) {
            return;
        }
        class_4706<class_3228<?>> sortedArraySet = this.getTicketSet(position);
        int i = NormalTicketDistanceMap.getLevel(sortedArraySet);
        sortedArraySet.add(ticket);
        if (ticket.method_14283() < i) {
            this.method_14027(position, ticket.method_14283(), true);
        }
    }

    public void removeTicket(long pos, class_3228<?> ticket) {
        if (ticket.method_14281() == PlayerNoTickDistanceMap.TICKET_TYPE) {
            return;
        }
        class_4706<class_3228<?>> sortedArraySet = this.getTicketSet(pos);
        sortedArraySet.remove(ticket);
        if (sortedArraySet.isEmpty()) {
            this.ticketsByPosition.remove(pos);
        }
        this.method_14027(pos, NormalTicketDistanceMap.getLevel(sortedArraySet), false);
    }

    public void purge(long age) {
        ObjectIterator iterator = this.ticketsByPosition.long2ObjectEntrySet().fastIterator();
        while (iterator.hasNext()) {
            Long2ObjectMap.Entry entry = (Long2ObjectMap.Entry)iterator.next();
            boolean isModified = ((class_4706)entry.getValue()).removeIf(chunkTicket -> ((IChunkTicket)chunkTicket).invokeIsExpired(age));
            if (isModified) {
                this.method_14027(entry.getLongKey(), NormalTicketDistanceMap.getLevel((class_4706)entry.getValue()), false);
            }
            if (!((class_4706)entry.getValue()).isEmpty()) continue;
            iterator.remove();
        }
    }

    public class_4706<class_3228<?>> getTicketSet(long pos) {
        return (class_4706)this.ticketsByPosition.computeIfAbsent(pos, l -> class_4706.method_23859((int)4));
    }

    public boolean update() {
        return Integer.MAX_VALUE - this.method_15492(Integer.MAX_VALUE) != 0;
    }

    public LongSet getChunks() {
        return this.distanceMap.keySet();
    }
}

