/*
 * Decompiled with CFR 0.152.
 */
package com.ishland.c2me.notickvd.common;

import com.ishland.c2me.base.common.scheduler.SchedulerThread;
import com.ishland.c2me.notickvd.common.NormalTicketDistanceMap;
import com.ishland.c2me.notickvd.common.PlayerNoTickDistanceMap;
import it.unimi.dsi.fastutil.longs.LongIterator;
import it.unimi.dsi.fastutil.longs.LongOpenHashSet;
import it.unimi.dsi.fastutil.longs.LongSet;
import it.unimi.dsi.fastutil.longs.LongSets;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import net.minecraft.class_1923;
import net.minecraft.class_3204;
import net.minecraft.class_3228;
import org.threadly.concurrent.NoThreadScheduler;

public class NoTickSystem {
    private final PlayerNoTickDistanceMap playerNoTickDistanceMap;
    private final NormalTicketDistanceMap normalTicketDistanceMap;
    private final class_3204 chunkTicketManager;
    private final ConcurrentLinkedQueue<Runnable> pendingActions = new ConcurrentLinkedQueue();
    final NoThreadScheduler noThreadScheduler = new NoThreadScheduler();
    private final AtomicBoolean isTicking = new AtomicBoolean();
    private volatile LongSet noTickOnlyChunksSnapshot = LongSets.EMPTY_SET;
    private volatile boolean pendingPurge = false;
    private volatile long age = 0L;

    public NoTickSystem(class_3204 chunkTicketManager) {
        this.chunkTicketManager = chunkTicketManager;
        this.playerNoTickDistanceMap = new PlayerNoTickDistanceMap(chunkTicketManager, this);
        this.normalTicketDistanceMap = new NormalTicketDistanceMap(chunkTicketManager);
    }

    public void onTicketAdded(long position, class_3228<?> ticket) {
        this.pendingActions.add(() -> this.normalTicketDistanceMap.addTicket(position, ticket));
    }

    public void onTicketRemoved(long position, class_3228<?> ticket) {
        this.pendingActions.add(() -> this.normalTicketDistanceMap.removeTicket(position, ticket));
    }

    public void addPlayerSource(class_1923 chunkPos) {
        this.pendingActions.add(() -> this.playerNoTickDistanceMap.addSource(chunkPos));
    }

    public void removePlayerSource(class_1923 chunkPos) {
        this.pendingActions.add(() -> this.playerNoTickDistanceMap.removeSource(chunkPos));
    }

    public void setNoTickViewDistance(int viewDistance) {
        this.pendingActions.add(() -> this.playerNoTickDistanceMap.setViewDistance(viewDistance));
    }

    public void tickScheduler() {
        this.noThreadScheduler.tick(Throwable::printStackTrace);
    }

    public void tick() {
        this.tickScheduler();
        this.scheduleTick();
    }

    private void scheduleTick() {
        if (this.isTicking.compareAndSet(false, true)) {
            SchedulerThread.INSTANCE.execute(() -> {
                Runnable runnable;
                while ((runnable = this.pendingActions.poll()) != null) {
                    try {
                        runnable.run();
                    }
                    catch (Throwable t) {
                        t.printStackTrace();
                    }
                }
                if (this.pendingPurge) {
                    this.normalTicketDistanceMap.purge(this.age);
                    this.playerNoTickDistanceMap.runPendingTicketUpdates();
                }
                boolean hasNormalTicketUpdates = this.normalTicketDistanceMap.update();
                boolean hasNoTickUpdates = this.playerNoTickDistanceMap.update();
                if (hasNormalTicketUpdates || hasNoTickUpdates) {
                    LongSet noTickChunks = this.playerNoTickDistanceMap.getChunks();
                    LongSet normalChunks = this.normalTicketDistanceMap.getChunks();
                    LongOpenHashSet longs = new LongOpenHashSet(noTickChunks.size() * 3 / 2);
                    LongIterator iterator = noTickChunks.iterator();
                    while (iterator.hasNext()) {
                        long chunk = iterator.nextLong();
                        if (normalChunks.contains(chunk)) continue;
                        longs.add(chunk);
                    }
                    this.noTickOnlyChunksSnapshot = LongSets.unmodifiable((LongSet)longs);
                }
                this.isTicking.set(false);
                if (hasNormalTicketUpdates || hasNoTickUpdates) {
                    this.scheduleTick();
                }
            });
        }
    }

    public void runPurge(long age) {
        this.age = age;
        this.pendingPurge = true;
    }

    public LongSet getNoTickOnlyChunksSnapshot() {
        return this.noTickOnlyChunksSnapshot;
    }

    public int getPendingNoTickTicketUpdatesCount() {
        return this.playerNoTickDistanceMap.getPendingTicketUpdatesCount();
    }
}

