/*
 * Decompiled with CFR 0.152.
 */
package net.earthcomputer.multiconnect.api;

import java.util.Collections;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.earthcomputer.multiconnect.api.ICustomPayloadListener;
import net.earthcomputer.multiconnect.api.IIdentifierCustomPayloadListener;
import net.earthcomputer.multiconnect.api.IProtocol;
import net.earthcomputer.multiconnect.api.IStringCustomPayloadListener;
import net.earthcomputer.multiconnect.api.ThreadSafe;
import net.minecraft.class_155;
import net.minecraft.class_2378;
import net.minecraft.class_2540;
import net.minecraft.class_2596;
import net.minecraft.class_2817;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_5321;
import net.minecraft.class_634;

public class MultiConnectAPI {
    private static final MultiConnectAPI INSTANCE;

    @ThreadSafe
    public static MultiConnectAPI instance() {
        return INSTANCE;
    }

    @ThreadSafe
    public int getProtocolVersion() {
        return class_155.method_16673().getProtocolVersion();
    }

    @ThreadSafe
    public IProtocol byProtocolVersion(int version) {
        return version == class_155.method_16673().getProtocolVersion() ? CurrentVersionProtocol.INSTANCE : null;
    }

    @ThreadSafe
    public List<IProtocol> getSupportedProtocols() {
        return Collections.singletonList(CurrentVersionProtocol.INSTANCE);
    }

    public void addClientboundIdentifierCustomPayloadListener(ICustomPayloadListener<class_2960> listener) {
    }

    public void removeClientboundIdentifierCustomPayloadListener(ICustomPayloadListener<class_2960> listener) {
    }

    public void addClientboundStringCustomPayloadListener(ICustomPayloadListener<String> listener) {
    }

    public void removeClientboundStringCustomPayloadListener(ICustomPayloadListener<String> listener) {
    }

    @ThreadSafe
    public void forceSendCustomPayload(class_634 networkHandler, class_2960 channel, class_2540 data) {
        if (networkHandler == null) {
            throw new IllegalArgumentException("Trying to send custom payload when not in-game");
        }
        networkHandler.method_2883((class_2596)new class_2817(channel, data));
    }

    @ThreadSafe
    public void forceSendStringCustomPayload(class_634 networkHandler, String channel, class_2540 data) {
        throw new IllegalStateException("Trying to send custom payload to " + class_155.method_16673().getName() + " server");
    }

    public void addServerboundIdentifierCustomPayloadListener(ICustomPayloadListener<class_2960> listener) {
    }

    public void removeServerboundIdentifierCustomPayloadListener(ICustomPayloadListener<class_2960> listener) {
    }

    public void addServerboundStringCustomPayloadListener(ICustomPayloadListener<String> listener) {
    }

    public void removeServerboundStringCustomPayloadListener(ICustomPayloadListener<String> listener) {
    }

    @ThreadSafe
    public <T> boolean doesServerKnow(class_2378<T> registry, T value) {
        return registry.method_29113(value).isPresent();
    }

    @ThreadSafe
    public <T> boolean doesServerKnow(class_2378<T> registry, class_5321<T> key) {
        return key.method_31163(registry.method_30517()) && registry.method_17966(key.method_29177()).isPresent();
    }

    @Deprecated
    public void addIdentifierCustomPayloadListener(IIdentifierCustomPayloadListener listener) {
    }

    @Deprecated
    public void removeIdentifierCustomPayloadListener(IIdentifierCustomPayloadListener listener) {
    }

    @Deprecated
    public void addStringCustomPayloadListener(IStringCustomPayloadListener listener) {
    }

    @Deprecated
    public void removeStringCustomPayloadListener(IStringCustomPayloadListener listener) {
    }

    @Deprecated
    public void forceSendCustomPayload(class_2960 channel, class_2540 data) {
        this.forceSendCustomPayload(class_310.method_1551().method_1562(), channel, data);
    }

    @Deprecated
    public void forceSendStringCustomPayload(String channel, class_2540 data) {
        this.forceSendStringCustomPayload(class_310.method_1551().method_1562(), channel, data);
    }

    @Deprecated
    public void addServerboundIdentifierCustomPayloadListener(IIdentifierCustomPayloadListener listener) {
    }

    @Deprecated
    public void removeServerboundIdentifierCustomPayloadListener(IIdentifierCustomPayloadListener listener) {
    }

    @Deprecated
    public void addServerboundStringCustomPayloadListener(IStringCustomPayloadListener listener) {
    }

    @Deprecated
    public void removeServerboundStringCustomPayloadListener(IStringCustomPayloadListener listener) {
    }

    static {
        MultiConnectAPI api;
        try {
            api = (MultiConnectAPI)Class.forName("net.earthcomputer.multiconnect.impl.APIImpl").getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (ClassNotFoundException e) {
            api = new MultiConnectAPI();
        }
        catch (ReflectiveOperationException e) {
            throw new AssertionError((Object)e);
        }
        INSTANCE = api;
    }

    private static class CurrentVersionProtocol
    implements IProtocol {
        public static CurrentVersionProtocol INSTANCE = new CurrentVersionProtocol();
        private String majorReleaseName;

        private CurrentVersionProtocol() {
        }

        @Override
        public int getValue() {
            return class_155.method_16673().getProtocolVersion();
        }

        @Override
        public String getName() {
            return class_155.method_16673().getName();
        }

        @Override
        public int getDataVersion() {
            return class_155.method_16673().getWorldVersion();
        }

        @Override
        public boolean isMajorRelease() {
            return true;
        }

        @Override
        public IProtocol getMajorRelease() {
            return this;
        }

        @Override
        public String getMajorReleaseName() {
            if (this.majorReleaseName == null) {
                Matcher matcher = Pattern.compile("([^.]*(\\.[^.]*)?).*").matcher(this.getName());
                boolean matches = matcher.matches();
                assert (matches);
                this.majorReleaseName = matcher.group(1);
            }
            return this.majorReleaseName;
        }

        @Override
        public List<IProtocol> getMinorReleases() {
            return Collections.singletonList(this);
        }

        @Override
        public boolean isMulticonnectBeta() {
            return false;
        }
    }
}

