/*
 * Decompiled with CFR 0.152.
 */
package eu.midnightdust.midnightcontrols.client.ring;

import com.electronwill.nightconfig.core.Config;
import eu.midnightdust.midnightcontrols.client.ring.RingAction;
import java.util.List;
import java.util.Optional;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_4587;
import org.jetbrains.annotations.NotNull;

public class RingPage
extends class_332 {
    public static final RingPage DEFAULT = new RingPage("Default");
    public final String name;
    private RingAction[] actions = new RingAction[8];

    public RingPage(@NotNull String name) {
        this.name = name;
        for (int i = 0; i < 8; ++i) {
            this.actions[i] = null;
        }
    }

    public void render(@NotNull class_4587 matrices, @NotNull class_327 textRenderer, int width, int height, int mouseX, int mouseY, float tickDelta) {
        RingAction ringAction;
        int i;
        int centerX = width / 2;
        int centerY = height / 2;
        int offset = 80;
        int y = centerY - offset;
        int x = centerX - offset;
        for (i = 0; i < 3; ++i) {
            ringAction = this.actions[i];
            if (ringAction != null) {
                ringAction.render(matrices, textRenderer, x, y, RingPage.isHovered(x, y, mouseX, mouseY));
            }
            x += 55;
        }
        y += 55;
        x = centerX - offset;
        for (i = 3; i < 5; ++i) {
            ringAction = this.actions[i];
            if (ringAction != null) {
                ringAction.render(matrices, textRenderer, x, y, RingPage.isHovered(x, y, mouseX, mouseY));
            }
            x += 110;
        }
        y += 55;
        x = centerX - offset;
        for (i = 5; i < 8; ++i) {
            ringAction = this.actions[i];
            if (ringAction != null) {
                ringAction.render(matrices, textRenderer, x, y, RingPage.isHovered(x, y, mouseX, mouseY));
            }
            x += 55;
        }
    }

    private static boolean isHovered(int x, int y, int mouseX, int mouseY) {
        return mouseX >= x && mouseY >= y && mouseX <= x + 50 && mouseY <= y + 50;
    }

    @NotNull
    public static Optional<RingPage> parseRingPage(@NotNull Config config) {
        String name = (String)config.get("name");
        if (name == null) {
            return Optional.empty();
        }
        RingPage page = new RingPage(name);
        List actionConfigs = (List)config.get("actions");
        return Optional.of(page);
    }
}

