/*
 * Decompiled with CFR 0.152.
 */
package eu.midnightdust.midnightcontrols.client.ring;

import eu.midnightdust.midnightcontrols.client.MidnightControlsClient;
import eu.midnightdust.midnightcontrols.client.ring.RingAction;
import eu.midnightdust.midnightcontrols.client.ring.RingPage;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public final class MidnightRing {
    public static final int ELEMENT_SIZE = 50;
    private final Map<String, RingAction.Factory> actionFactories = new Object2ObjectOpenHashMap();
    private final List<RingPage> pages = new ArrayList<RingPage>(Collections.singletonList(RingPage.DEFAULT));
    private final MidnightControlsClient mod;
    private int currentPage = 0;

    public MidnightRing(@NotNull MidnightControlsClient mod) {
        this.mod = mod;
    }

    public void registerAction(@NotNull String name, @NotNull RingAction.Factory factory) {
        if (this.actionFactories.containsKey(name)) {
            this.mod.warn("Tried to register twice a ring action: \"" + name + "\".");
            return;
        }
        this.actionFactories.put(name, factory);
    }

    public void load() {
    }

    @NotNull
    public RingPage getCurrentPage() {
        if (this.currentPage >= this.pages.size()) {
            this.currentPage = this.pages.size() - 1;
        } else if (this.currentPage < 0) {
            this.currentPage = 0;
        }
        return this.pages.get(this.currentPage);
    }
}

