/*
 * Decompiled with CFR 0.152.
 */
package eu.midnightdust.midnightcontrols.client.gui;

import dev.lambdaurora.spruceui.hud.Hud;
import eu.midnightdust.midnightcontrols.ControlsMode;
import eu.midnightdust.midnightcontrols.client.HudSide;
import eu.midnightdust.midnightcontrols.client.MidnightControlsClient;
import eu.midnightdust.midnightcontrols.client.MidnightControlsConfig;
import eu.midnightdust.midnightcontrols.client.compat.MidnightControlsCompat;
import eu.midnightdust.midnightcontrols.client.controller.ButtonBinding;
import eu.midnightdust.midnightcontrols.client.gui.MidnightControlsRenderer;
import java.util.Objects;
import net.minecraft.class_1041;
import net.minecraft.class_1074;
import net.minecraft.class_1747;
import net.minecraft.class_1799;
import net.minecraft.class_239;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3965;
import net.minecraft.class_4587;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MidnightControlsHud
extends Hud {
    private final MidnightControlsClient mod;
    private class_310 client;
    private int attackWidth = 0;
    private int attackButtonWidth = 0;
    private int dropItemWidth = 0;
    private int dropItemButtonWidth = 0;
    private int inventoryWidth = 0;
    private int inventoryButtonWidth = 0;
    private int swapHandsWidth = 0;
    private int swapHandsButtonWidth = 0;
    private int useWidth = 0;
    private int useButtonWidth = 0;
    private class_3965 placeHitResult;
    private String attackAction = "";
    private String placeAction = "";
    private int ticksDisplayedCrosshair = 0;

    public MidnightControlsHud(@NotNull MidnightControlsClient mod) {
        super(new class_2960("midnightcontrols", "hud/button_indicator"));
        this.mod = mod;
    }

    public void init(@NotNull class_310 client, int screenWidth, int screenHeight) {
        super.init(client, screenWidth, screenHeight);
        this.client = client;
        this.inventoryWidth = this.width(ButtonBinding.INVENTORY);
        this.inventoryButtonWidth = MidnightControlsRenderer.getBindingIconWidth(ButtonBinding.INVENTORY);
        this.swapHandsWidth = this.width(ButtonBinding.SWAP_HANDS);
        this.swapHandsButtonWidth = MidnightControlsRenderer.getBindingIconWidth(ButtonBinding.SWAP_HANDS);
        this.dropItemWidth = this.width(ButtonBinding.DROP_ITEM);
        this.dropItemButtonWidth = MidnightControlsRenderer.getBindingIconWidth(ButtonBinding.DROP_ITEM);
        this.attackButtonWidth = MidnightControlsRenderer.getBindingIconWidth(ButtonBinding.ATTACK);
        this.useButtonWidth = MidnightControlsRenderer.getBindingIconWidth(ButtonBinding.USE);
    }

    public void render(class_4587 matrices, float tickDelta) {
        if (MidnightControlsConfig.controlsMode == ControlsMode.CONTROLLER && this.client.field_1755 == null) {
            int y = this.bottom(2);
            this.renderFirstIcons(matrices, MidnightControlsConfig.hudSide == HudSide.LEFT ? 2 : this.client.method_22683().method_4486() - 2, y);
            this.renderSecondIcons(matrices, MidnightControlsConfig.hudSide == HudSide.RIGHT ? 2 : this.client.method_22683().method_4486() - 2, y);
            this.renderFirstSection(matrices, MidnightControlsConfig.hudSide == HudSide.LEFT ? 2 : this.client.method_22683().method_4486() - 2, y);
            this.renderSecondSection(matrices, MidnightControlsConfig.hudSide == HudSide.RIGHT ? 2 : this.client.method_22683().method_4486() - 2, y);
        }
        if (this.mod.reacharound.isLastReacharoundVertical()) {
            class_1041 window = this.client.method_22683();
            String text = "[  ]";
            float scale = Math.min(5.0f, (float)this.ticksDisplayedCrosshair + tickDelta) / 5.0f;
            scale *= scale;
            int opacity = (int)(255.0f * scale) << 24;
            this.client.field_1772.method_1729(matrices, text, (float)window.method_4486() / 2.0f - (float)this.client.field_1772.method_1727(text) / 2.0f, (float)window.method_4502() / 2.0f - 4.0f, 0xCCCCCC | opacity);
        }
    }

    public void renderFirstIcons(class_4587 matrices, int x, int y) {
        int offset = 2 + this.inventoryWidth + this.inventoryButtonWidth + 4;
        int currentX = MidnightControlsConfig.hudSide == HudSide.LEFT ? x : x - this.inventoryButtonWidth;
        this.drawButton(matrices, currentX, y, ButtonBinding.INVENTORY, true);
        this.drawButton(matrices, currentX += MidnightControlsConfig.hudSide == HudSide.LEFT ? offset : -offset, y, ButtonBinding.SWAP_HANDS, true);
        offset = 2 + this.swapHandsWidth + this.dropItemButtonWidth + 4;
        if (((Boolean)this.client.field_1690.method_42443().method_41753()).booleanValue() && MidnightControlsConfig.hudSide == HudSide.RIGHT) {
            currentX += -offset;
        } else {
            currentX = MidnightControlsConfig.hudSide == HudSide.LEFT ? x : x - this.dropItemButtonWidth;
            y -= 24;
        }
        this.drawButton(matrices, currentX, y, ButtonBinding.DROP_ITEM, !this.client.field_1724.method_6047().method_7960());
    }

    public void renderSecondIcons(class_4587 matrices, int x, int y) {
        int currentX = x;
        if (!this.placeAction.isEmpty()) {
            if (MidnightControlsConfig.hudSide == HudSide.LEFT) {
                currentX -= this.useButtonWidth;
            }
            this.drawButton(matrices, currentX, y, ButtonBinding.USE, true);
            int offset = 2 + this.useWidth + 4;
            if (((Boolean)this.client.field_1690.method_42443().method_41753()).booleanValue() && MidnightControlsConfig.hudSide == HudSide.LEFT) {
                currentX -= offset;
            } else {
                currentX = x;
                y -= 24;
            }
        }
        if (MidnightControlsConfig.hudSide == HudSide.LEFT) {
            currentX -= this.attackButtonWidth;
        }
        this.drawButton(matrices, currentX, y, ButtonBinding.ATTACK, this.attackWidth != 0);
    }

    public void renderFirstSection(class_4587 matrices, int x, int y) {
        int currentX = MidnightControlsConfig.hudSide == HudSide.LEFT ? x + this.inventoryButtonWidth + 2 : x - this.inventoryButtonWidth - 2 - this.inventoryWidth;
        this.drawTip(matrices, currentX, y, ButtonBinding.INVENTORY, true);
        this.drawTip(matrices, currentX += MidnightControlsConfig.hudSide == HudSide.LEFT ? this.inventoryWidth + 4 + this.swapHandsButtonWidth + 2 : -this.swapHandsWidth - 2 - this.swapHandsButtonWidth - 4, y, ButtonBinding.SWAP_HANDS, true);
        if (((Boolean)this.client.field_1690.method_42443().method_41753()).booleanValue() && MidnightControlsConfig.hudSide == HudSide.RIGHT) {
            currentX += -this.dropItemWidth - 2 - this.dropItemButtonWidth - 4;
        } else {
            y -= 24;
            currentX = MidnightControlsConfig.hudSide == HudSide.LEFT ? x + this.dropItemButtonWidth + 2 : x - this.dropItemButtonWidth - 2 - this.dropItemWidth;
        }
        this.drawTip(matrices, currentX, y, ButtonBinding.DROP_ITEM, !this.client.field_1724.method_6047().method_7960());
    }

    public void renderSecondSection(class_4587 matrices, int x, int y) {
        int currentX = x;
        if (!this.placeAction.isEmpty()) {
            this.drawTip(matrices, currentX += MidnightControlsConfig.hudSide == HudSide.RIGHT ? this.useButtonWidth + 2 : -this.useButtonWidth - 2 - this.useWidth, y, this.placeAction, true);
            if (((Boolean)this.client.field_1690.method_42443().method_41753()).booleanValue() && MidnightControlsConfig.hudSide == HudSide.LEFT) {
                currentX -= 4;
            } else {
                currentX = x;
                y -= 24;
            }
        }
        this.drawTip(matrices, currentX += MidnightControlsConfig.hudSide == HudSide.RIGHT ? this.attackButtonWidth + 2 : -this.attackButtonWidth - 2 - this.attackWidth, y, this.attackAction, this.attackWidth != 0);
    }

    public void tick() {
        super.tick();
        if (MidnightControlsConfig.controlsMode == ControlsMode.CONTROLLER) {
            String customAttackAction;
            if (this.client.field_1765 == null) {
                return;
            }
            if (this.client.field_1765.method_17783() == class_239.class_240.field_1333) {
                this.placeHitResult = this.mod.reacharound.getLastReacharoundResult();
                this.attackAction = "";
                this.attackWidth = 0;
            } else {
                this.placeHitResult = this.client.field_1765.method_17783() == class_239.class_240.field_1332 ? (class_3965)this.client.field_1765 : null;
                this.attackAction = this.client.field_1765.method_17783() == class_239.class_240.field_1332 ? "midnightcontrols.action.hit" : ButtonBinding.ATTACK.getTranslationKey();
                this.attackWidth = this.width(this.attackAction);
            }
            if (this.mod.reacharound.isLastReacharoundVertical()) {
                if (this.ticksDisplayedCrosshair < 5) {
                    ++this.ticksDisplayedCrosshair;
                }
            } else {
                this.ticksDisplayedCrosshair = 0;
            }
            if ((customAttackAction = MidnightControlsCompat.getAttackActionAt(this.client, this.placeHitResult)) != null) {
                this.attackAction = customAttackAction;
                this.attackWidth = this.width(customAttackAction);
            }
            class_1799 stack = null;
            if (this.client.field_1724 != null && ((stack = this.client.field_1724.method_6047()) == null || stack.method_7960())) {
                stack = this.client.field_1724.method_6079();
            }
            String placeAction = stack == null || stack.method_7960() ? "" : (this.placeHitResult != null && stack.method_7909() instanceof class_1747 ? "midnightcontrols.action.place" : ButtonBinding.USE.getTranslationKey());
            String customUseAction = MidnightControlsCompat.getUseActionAt(this.client, this.placeHitResult);
            if (customUseAction != null) {
                placeAction = customUseAction;
            }
            this.placeAction = placeAction;
            this.useWidth = this.placeAction.isEmpty() ? 0 : this.width(this.placeAction);
        }
    }

    public boolean hasTicks() {
        return true;
    }

    private int bottom(int y) {
        return this.client.method_22683().method_4502() - y - 20;
    }

    private int width(@NotNull ButtonBinding binding) {
        return this.width(binding.getTranslationKey());
    }

    private int width(@Nullable String text) {
        if (text == null || text.isEmpty()) {
            return 0;
        }
        return this.client.field_1772.method_1727(class_1074.method_4662((String)text, (Object[])new Object[0]));
    }

    private void drawButton(class_4587 matrices, int x, int y, @NotNull ButtonBinding button, boolean display) {
        if (display) {
            MidnightControlsRenderer.drawButton(matrices, x, y, button, this.client);
        }
    }

    private void drawTip(class_4587 matrices, int x, int y, @NotNull ButtonBinding button, boolean display) {
        this.drawTip(matrices, x, y, button.getTranslationKey(), display);
    }

    private void drawTip(class_4587 matrices, int x, int y, @NotNull String action, boolean display) {
        if (!display) {
            return;
        }
        String translatedAction = class_1074.method_4662((String)action, (Object[])new Object[0]);
        Objects.requireNonNull(this.client.field_1772);
        int textY = 10 - 9 / 2 + 1;
        this.client.field_1772.method_1729(matrices, translatedAction, (float)x, (float)(y + textY), 0xE0E0E0);
    }
}

