/*
 * Decompiled with CFR 0.152.
 */
package eu.midnightdust.midnightcontrols.client.controller;

import eu.midnightdust.midnightcontrols.client.ButtonState;
import eu.midnightdust.midnightcontrols.client.MidnightControlsConfig;
import eu.midnightdust.midnightcontrols.client.controller.ButtonBinding;
import eu.midnightdust.midnightcontrols.client.controller.PressAction;
import net.minecraft.class_310;
import net.minecraft.class_746;
import org.jetbrains.annotations.NotNull;

public final class MovementHandler
implements PressAction {
    public static final MovementHandler HANDLER = new MovementHandler();
    private boolean shouldOverrideMovement = false;
    private boolean pressingForward = false;
    private boolean pressingBack = false;
    private boolean pressingLeft = false;
    private boolean pressingRight = false;
    private float movementForward = 0.0f;
    private float movementSideways = 0.0f;

    private MovementHandler() {
    }

    public void applyMovement(@NotNull class_746 player) {
        if (!this.shouldOverrideMovement) {
            return;
        }
        player.field_3913.field_3910 = this.pressingForward;
        player.field_3913.field_3909 = this.pressingBack;
        player.field_3913.field_3908 = this.pressingLeft;
        player.field_3913.field_3906 = this.pressingRight;
        player.field_3913.field_3905 = this.movementForward;
        player.field_3913.field_3907 = this.movementSideways;
        this.shouldOverrideMovement = false;
    }

    @Override
    public boolean press(@NotNull class_310 client, @NotNull ButtonBinding button, float value, @NotNull ButtonState action) {
        if (client.field_1755 != null || client.field_1724 == null) {
            this.shouldOverrideMovement = false;
            return false;
        }
        int direction = 0;
        if (button == ButtonBinding.FORWARD || button == ButtonBinding.LEFT) {
            direction = 1;
        } else if (button == ButtonBinding.BACK || button == ButtonBinding.RIGHT) {
            direction = -1;
        }
        if (action.isUnpressed()) {
            direction = 0;
        }
        this.shouldOverrideMovement = direction != 0;
        value = MidnightControlsConfig.analogMovement ? (float)Math.pow(value, 2.0) : 1.0f;
        if (button == ButtonBinding.FORWARD || button == ButtonBinding.BACK) {
            this.pressingForward = direction > 0;
            this.pressingBack = direction < 0;
            this.movementForward = (float)direction * value;
            if (client.field_1724.field_3913.field_3903) {
                this.movementForward = (float)((double)this.movementForward * 0.3);
            }
        } else {
            this.pressingLeft = direction > 0;
            this.pressingRight = direction < 0;
            this.movementSideways = (float)direction * value;
            if (client.field_1724.field_3913.field_3903) {
                this.movementSideways = (float)((double)this.movementSideways * 0.3);
            }
        }
        return this.shouldOverrideMovement;
    }
}

