/*
 * Decompiled with CFR 0.152.
 */
package eu.midnightdust.midnightcontrols.client.controller;

import eu.midnightdust.midnightcontrols.client.ButtonState;
import eu.midnightdust.midnightcontrols.client.MidnightControlsClient;
import eu.midnightdust.midnightcontrols.client.MidnightInput;
import eu.midnightdust.midnightcontrols.client.compat.MidnightControlsCompat;
import eu.midnightdust.midnightcontrols.client.controller.ButtonBinding;
import eu.midnightdust.midnightcontrols.client.controller.InputManager;
import eu.midnightdust.midnightcontrols.client.controller.PressAction;
import eu.midnightdust.midnightcontrols.client.mixin.AdvancementsScreenAccessor;
import eu.midnightdust.midnightcontrols.client.mixin.CreativeInventoryScreenAccessor;
import eu.midnightdust.midnightcontrols.client.mixin.RecipeBookWidgetAccessor;
import eu.midnightdust.midnightcontrols.client.util.HandledScreenAccessor;
import java.io.File;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.fabricmc.fabric.impl.item.group.CreativeGuiExtensions;
import net.minecraft.class_1713;
import net.minecraft.class_1735;
import net.minecraft.class_1761;
import net.minecraft.class_276;
import net.minecraft.class_310;
import net.minecraft.class_318;
import net.minecraft.class_437;
import net.minecraft.class_454;
import net.minecraft.class_457;
import net.minecraft.class_465;
import net.minecraft.class_481;
import net.minecraft.class_490;
import net.minecraft.class_512;
import org.aperlambda.lambdacommon.utils.Pair;
import org.jetbrains.annotations.NotNull;

public class InputHandlers {
    private InputHandlers() {
    }

    public static PressAction handleHotbar(boolean next) {
        return (client, button, value, action) -> {
            if (action == ButtonState.RELEASE) {
                return false;
            }
            if (client.field_1755 == null && client.field_1724 != null) {
                client.field_1724.method_31548().field_7545 = next ? (client.field_1724.method_31548().field_7545 == 8 ? 0 : client.field_1724.method_31548().field_7545 + 1) : (client.field_1724.method_31548().field_7545 == 0 ? 8 : client.field_1724.method_31548().field_7545 - 1);
                return true;
            }
            class_437 patt2696$temp = client.field_1755;
            if (patt2696$temp instanceof CreativeInventoryScreenAccessor) {
                CreativeInventoryScreenAccessor inventory = (CreativeInventoryScreenAccessor)patt2696$temp;
                int currentTab = inventory.getSelectedTab();
                int nextTab = currentTab + (next ? 1 : -1);
                if (nextTab < 0) {
                    nextTab = class_1761.field_7921.length - 1;
                } else if (nextTab >= class_1761.field_7921.length) {
                    nextTab = 0;
                }
                inventory.midnightcontrols$setSelectedTab(class_1761.field_7921[nextTab]);
                return true;
            }
            class_437 patt3218$temp = client.field_1755;
            if (patt3218$temp instanceof class_490) {
                class_490 inventoryScreen = (class_490)patt3218$temp;
                RecipeBookWidgetAccessor recipeBook = (RecipeBookWidgetAccessor)inventoryScreen.method_2659();
                List<class_512> tabs = recipeBook.getTabButtons();
                class_512 currentTab = recipeBook.getCurrentTab();
                if (currentTab == null) {
                    return false;
                }
                int nextTab = tabs.indexOf(currentTab) + (next ? 1 : -1);
                if (nextTab < 0) {
                    nextTab = tabs.size() - 1;
                } else if (nextTab >= tabs.size()) {
                    nextTab = 0;
                }
                currentTab.method_1964(false);
                currentTab = tabs.get(nextTab);
                recipeBook.setCurrentTab(currentTab);
                currentTab.method_1964(true);
                recipeBook.midnightcontrols$refreshResults(true);
                return true;
            }
            class_437 patt4093$temp = client.field_1755;
            if (patt4093$temp instanceof AdvancementsScreenAccessor) {
                AdvancementsScreenAccessor screen = (AdvancementsScreenAccessor)patt4093$temp;
                List tabs = screen.getTabs().values().stream().distinct().collect(Collectors.toList());
                class_454 tab = screen.getSelectedTab();
                if (tab == null) {
                    return false;
                }
                for (int i = 0; i < tabs.size(); ++i) {
                    if (!((class_454)tabs.get(i)).equals(tab)) continue;
                    int nextTab = i + (next ? 1 : -1);
                    if (nextTab < 0) {
                        nextTab = tabs.size() - 1;
                    } else if (nextTab >= tabs.size()) {
                        nextTab = 0;
                    }
                    screen.getAdvancementManager().method_2864(((class_454)tabs.get(nextTab)).method_2307(), true);
                    break;
                }
                return true;
            }
            return false;
        };
    }

    public static PressAction handlePage(boolean next) {
        return (client, button, value, action) -> {
            if (client.field_1755 instanceof class_481) {
                HandledScreenAccessor screen = (HandledScreenAccessor)client.field_1755;
                try {
                    if (next) {
                        ((CreativeGuiExtensions)screen).fabric_nextPage();
                    } else {
                        ((CreativeGuiExtensions)screen).fabric_previousPage();
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            return false;
        };
    }

    public static PressAction handleActions() {
        return (client, button, value, action) -> {
            int slotId;
            class_437 patt5743$temp = client.field_1755;
            if (!(patt5743$temp instanceof class_465)) {
                return false;
            }
            class_465 screen = (class_465)patt5743$temp;
            if (client.field_1761 == null || client.field_1724 == null) {
                return false;
            }
            if (MidnightControlsClient.get().input.inventoryInteractionCooldown > 0) {
                return true;
            }
            double x = client.field_1729.method_1603() * (double)client.method_22683().method_4486() / (double)client.method_22683().method_4480();
            double y = client.field_1729.method_1604() * (double)client.method_22683().method_4502() / (double)client.method_22683().method_4507();
            HandledScreenAccessor accessor = (HandledScreenAccessor)screen;
            class_1735 slot = ((HandledScreenAccessor)screen).midnightcontrols$getSlotAt(x, y);
            if (slot == null) {
                if (client.field_1724.field_7512.method_34255().method_7960()) {
                    return false;
                }
                slotId = accessor.midnightcontrols$isClickOutsideBounds(x, y, accessor.getX(), accessor.getY(), 0) ? -999 : -1;
            } else {
                slotId = slot.field_7874;
            }
            class_1713 actionType = class_1713.field_7790;
            int clickData = 0;
            MidnightControlsClient.get().input.inventoryInteractionCooldown = 5;
            switch (button.getName()) {
                case "take_all": {
                    if (accessor instanceof class_481 && ((CreativeInventoryScreenAccessor)((Object)accessor)).midnightcontrols$isCreativeInventorySlot(slot)) {
                        actionType = class_1713.field_7796;
                    }
                    if (slot == null || !MidnightControlsCompat.streamCompatHandlers().anyMatch(handler -> handler.isCreativeSlot(screen, slot))) break;
                    actionType = class_1713.field_7796;
                    break;
                }
                case "take": {
                    clickData = 1;
                    break;
                }
                case "quick_move": {
                    actionType = class_1713.field_7794;
                    break;
                }
                default: {
                    return false;
                }
            }
            accessor.midnightcontrols$onMouseClick(slot, slotId, clickData, actionType);
            return true;
        };
    }

    public static boolean handlePauseGame(@NotNull class_310 client, @NotNull ButtonBinding binding, float value, @NotNull ButtonState action) {
        if (action == ButtonState.PRESS) {
            if (client.field_1755 == null) {
                client.method_20539(false);
            } else if (client.field_1755 instanceof class_465 && client.field_1724 != null) {
                client.field_1724.method_7346();
            } else {
                client.field_1755.method_25419();
            }
        }
        return true;
    }

    public static boolean handleScreenshot(@NotNull class_310 client, @NotNull ButtonBinding binding, float value, @NotNull ButtonState action) {
        if (action == ButtonState.RELEASE) {
            class_318.method_1659((File)client.field_1697, (class_276)client.method_1522(), text -> client.execute(() -> client.field_1705.method_1743().method_1812(text)));
        }
        return true;
    }

    public static boolean handleToggleSneak(@NotNull class_310 client, @NotNull ButtonBinding button, float value, @NotNull ButtonState action) {
        button.asKeyBinding().ifPresent(binding -> {
            boolean sneakToggled = (Boolean)client.field_1690.method_42449().method_41753();
            if (client.field_1724.method_31549().field_7479 && sneakToggled) {
                client.field_1690.method_42449().method_41748((Object)false);
            }
            binding.method_23481(button.pressed);
            if (client.field_1724.method_31549().field_7479 && sneakToggled) {
                client.field_1690.method_42449().method_41748((Object)true);
            }
        });
        return true;
    }

    public static PressAction handleInventorySlotPad(int direction) {
        return (client, binding, value, action) -> {
            class_465 inventory;
            block5: {
                block4: {
                    class_437 patt10086$temp = client.field_1755;
                    if (!(patt10086$temp instanceof class_465)) break block4;
                    inventory = (class_465)patt10086$temp;
                    if (action != ButtonState.RELEASE) break block5;
                }
                return false;
            }
            HandledScreenAccessor accessor = (HandledScreenAccessor)inventory;
            int guiLeft = accessor.getX();
            int guiTop = accessor.getY();
            double mouseX = client.field_1729.method_1603() * (double)client.method_22683().method_4486() / (double)client.method_22683().method_4480();
            double mouseY = client.field_1729.method_1604() * (double)client.method_22683().method_4502() / (double)client.method_22683().method_4507();
            class_1735 mouseSlot = accessor.midnightcontrols$getSlotAt(mouseX, mouseY);
            Optional<class_1735> closestSlot = inventory.method_17577().field_7761.parallelStream().filter(Predicate.isEqual(mouseSlot).negate()).map(slot -> {
                int posX = guiLeft + slot.field_7873 + 8;
                int posY = guiTop + slot.field_7872 + 8;
                int otherPosX = (int)mouseX;
                int otherPosY = (int)mouseY;
                if (mouseSlot != null) {
                    otherPosX = guiLeft + mouseSlot.field_7873 + 8;
                    otherPosY = guiTop + mouseSlot.field_7872 + 8;
                }
                double distance = Math.sqrt(Math.pow(posX - otherPosX, 2.0) + Math.pow(posY - otherPosY, 2.0));
                return Pair.of((Object)slot, (Object)distance);
            }).filter(entry -> {
                class_1735 slot = (class_1735)entry.key;
                int posX = guiLeft + slot.field_7873 + 8;
                int posY = guiTop + slot.field_7872 + 8;
                int otherPosX = (int)mouseX;
                int otherPosY = (int)mouseY;
                if (mouseSlot != null) {
                    otherPosX = guiLeft + mouseSlot.field_7873 + 8;
                    otherPosY = guiTop + mouseSlot.field_7872 + 8;
                }
                if (direction == 0) {
                    return posY < otherPosY;
                }
                if (direction == 1) {
                    return posY > otherPosY;
                }
                if (direction == 2) {
                    return posX > otherPosX;
                }
                if (direction == 3) {
                    return posX < otherPosX;
                }
                return false;
            }).min(Comparator.comparingDouble(p -> (Double)p.value)).map(p -> (class_1735)p.key);
            if (closestSlot.isPresent()) {
                class_1735 slot2 = closestSlot.get();
                int x = guiLeft + slot2.field_7873 + 8;
                int y = guiTop + slot2.field_7872 + 8;
                InputManager.queueMousePosition((double)x * (double)client.method_22683().method_4480() / (double)client.method_22683().method_4486(), (double)y * (double)client.method_22683().method_4507() / (double)client.method_22683().method_4502());
                return true;
            }
            return false;
        };
    }

    public static boolean always(@NotNull class_310 client, @NotNull ButtonBinding binding) {
        return true;
    }

    public static boolean inGame(@NotNull class_310 client, @NotNull ButtonBinding binding) {
        return client.field_1755 == null;
    }

    public static boolean inNonInteractiveScreens(@NotNull class_310 client, @NotNull ButtonBinding binding) {
        if (client.field_1755 == null) {
            return false;
        }
        return !MidnightInput.isScreenInteractive(client.field_1755);
    }

    public static boolean inInventory(@NotNull class_310 client, @NotNull ButtonBinding binding) {
        return client.field_1755 instanceof class_465;
    }

    public static boolean inAdvancements(@NotNull class_310 client, @NotNull ButtonBinding binding) {
        return client.field_1755 instanceof class_457;
    }
}

