/*
 * Decompiled with CFR 0.152.
 */
package eu.midnightdust.midnightcontrols.client;

import com.google.common.collect.ImmutableSet;
import dev.lambdaurora.spruceui.navigation.NavigationDirection;
import dev.lambdaurora.spruceui.screen.SpruceScreen;
import dev.lambdaurora.spruceui.widget.AbstractSprucePressableButtonWidget;
import dev.lambdaurora.spruceui.widget.SpruceElement;
import dev.lambdaurora.spruceui.widget.SpruceLabelWidget;
import dev.lambdaurora.spruceui.widget.SpruceWidget;
import dev.lambdaurora.spruceui.widget.container.SpruceParentWidget;
import eu.midnightdust.midnightcontrols.client.ButtonState;
import eu.midnightdust.midnightcontrols.client.MidnightControlsClient;
import eu.midnightdust.midnightcontrols.client.MidnightControlsConfig;
import eu.midnightdust.midnightcontrols.client.compat.MidnightControlsCompat;
import eu.midnightdust.midnightcontrols.client.controller.ButtonBinding;
import eu.midnightdust.midnightcontrols.client.controller.Controller;
import eu.midnightdust.midnightcontrols.client.controller.InputManager;
import eu.midnightdust.midnightcontrols.client.gui.TouchscreenOverlay;
import eu.midnightdust.midnightcontrols.client.gui.widget.ControllerControlsWidget;
import eu.midnightdust.midnightcontrols.client.mixin.AdvancementsScreenAccessor;
import eu.midnightdust.midnightcontrols.client.mixin.CreativeInventoryScreenAccessor;
import eu.midnightdust.midnightcontrols.client.mixin.EntryListWidgetAccessor;
import eu.midnightdust.midnightcontrols.client.util.HandledScreenAccessor;
import eu.midnightdust.midnightcontrols.client.util.MouseAccessor;
import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import net.minecraft.class_1297;
import net.minecraft.class_1735;
import net.minecraft.class_310;
import net.minecraft.class_350;
import net.minecraft.class_3532;
import net.minecraft.class_357;
import net.minecraft.class_364;
import net.minecraft.class_4069;
import net.minecraft.class_4264;
import net.minecraft.class_4267;
import net.minecraft.class_4280;
import net.minecraft.class_437;
import net.minecraft.class_442;
import net.minecraft.class_454;
import net.minecraft.class_457;
import net.minecraft.class_465;
import net.minecraft.class_481;
import net.minecraft.class_500;
import net.minecraft.class_528;
import net.minecraft.class_746;
import org.aperlambda.lambdacommon.utils.Pair;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.lwjgl.glfw.GLFWGamepadState;

public class MidnightInput {
    private static final Map<Integer, Integer> BUTTON_COOLDOWNS = new HashMap<Integer, Integer>();
    public int actionGuiCooldown = 0;
    public boolean ignoreNextARelease = false;
    private double targetYaw = 0.0;
    private double targetPitch = 0.0;
    private float prevXAxis = 0.0f;
    private float prevYAxis = 0.0f;
    private int targetMouseX = 0;
    private int targetMouseY = 0;
    private float mouseSpeedX = 0.0f;
    private float mouseSpeedY = 0.0f;
    public int inventoryInteractionCooldown = 0;
    private ControllerControlsWidget controlsInput = null;

    public void tick(@NotNull class_310 client) {
        this.targetYaw = 0.0;
        this.targetPitch = 0.0;
        if (MidnightControlsClient.BINDING_LOOK_UP.method_1434()) {
            this.handleLook(client, 3, 0.8f, 2);
        } else if (MidnightControlsClient.BINDING_LOOK_DOWN.method_1434()) {
            this.handleLook(client, 3, 0.8f, 1);
        }
        if (MidnightControlsClient.BINDING_LOOK_LEFT.method_1434()) {
            this.handleLook(client, 2, 0.8f, 2);
        } else if (MidnightControlsClient.BINDING_LOOK_RIGHT.method_1434()) {
            this.handleLook(client, 2, 0.8f, 1);
        }
        InputManager.INPUT_MANAGER.tick(client);
    }

    public void tickController(@NotNull class_310 client) {
        BUTTON_COOLDOWNS.entrySet().stream().filter(entry -> (Integer)entry.getValue() > 0).forEach(entry -> BUTTON_COOLDOWNS.put((Integer)entry.getKey(), (Integer)entry.getValue() - 1));
        if (this.actionGuiCooldown > 0) {
            --this.actionGuiCooldown;
        }
        InputManager.updateStates();
        Controller controller = MidnightControlsConfig.getController();
        if (controller.isConnected()) {
            GLFWGamepadState state = controller.getState();
            this.fetchButtonInput(client, state, false);
            this.fetchAxeInput(client, state, false);
        }
        MidnightControlsConfig.getSecondController().filter(Controller::isConnected).ifPresent(joycon -> {
            GLFWGamepadState state = joycon.getState();
            this.fetchButtonInput(client, state, true);
            this.fetchAxeInput(client, state, true);
        });
        boolean allowInput = true;
        if (this.controlsInput != null && this.controlsInput.focusedBinding != null) {
            allowInput = false;
        }
        if (allowInput) {
            InputManager.updateBindings(client);
        }
        if (this.controlsInput != null && InputManager.STATES.int2ObjectEntrySet().parallelStream().map(Map.Entry::getValue).allMatch(ButtonState::isUnpressed) && this.controlsInput.focusedBinding != null && !this.controlsInput.waiting) {
            int[] buttons = new int[this.controlsInput.currentButtons.size()];
            for (int i = 0; i < this.controlsInput.currentButtons.size(); ++i) {
                buttons[i] = this.controlsInput.currentButtons.get(i);
            }
            this.controlsInput.finishBindingEdit(buttons);
            this.controlsInput = null;
        }
        if (this.inventoryInteractionCooldown > 0) {
            --this.inventoryInteractionCooldown;
        }
    }

    public void onPreRenderScreen(@NotNull class_310 client, @NotNull class_437 screen) {
        if (!MidnightInput.isScreenInteractive(screen)) {
            InputManager.INPUT_MANAGER.updateMousePosition(client);
        }
    }

    public void onRender(float tickDelta, @NotNull class_310 client) {
        if (client.field_1755 != null && !(client.field_1755 instanceof TouchscreenOverlay)) {
            return;
        }
        class_746 player = client.field_1724;
        if (player == null) {
            return;
        }
        if (this.targetYaw != 0.0 || this.targetPitch != 0.0) {
            float rotationYaw = (float)((double)player.field_5982 + this.targetYaw / 0.1 * (double)tickDelta);
            float rotationPitch = (float)((double)player.field_6004 + this.targetPitch / 0.1 * (double)tickDelta);
            client.field_1724.method_36456(rotationYaw);
            client.field_1724.method_36457(class_3532.method_15363((float)rotationPitch, (float)-90.0f, (float)90.0f));
            if (client.field_1724.method_3144()) {
                client.field_1724.method_5854().method_5644((class_1297)client.field_1724);
            }
            client.method_1577().method_4908(this.targetPitch, this.targetYaw);
        }
    }

    public void onScreenOpen(@NotNull class_310 client, int windowWidth, int windowHeight) {
        if (client.field_1755 == null) {
            this.mouseSpeedY = 0.0f;
            this.mouseSpeedX = 0.0f;
            InputManager.INPUT_MANAGER.resetMousePosition(windowWidth, windowHeight);
        } else if (MidnightInput.isScreenInteractive(client.field_1755) && MidnightControlsConfig.virtualMouse) {
            ((MouseAccessor)client.field_1729).midnightcontrols$onCursorPos(client.method_22683().method_4490(), 0.0, 0.0);
            InputManager.INPUT_MANAGER.resetMouseTarget(client);
        }
        this.inventoryInteractionCooldown = 5;
    }

    public void beginControlsInput(ControllerControlsWidget widget) {
        this.controlsInput = widget;
        if (widget != null) {
            this.controlsInput.currentButtons.clear();
            this.controlsInput.waiting = true;
        }
    }

    private void fetchButtonInput(@NotNull class_310 client, @NotNull GLFWGamepadState gamepadState, boolean leftJoycon) {
        ByteBuffer buffer = gamepadState.buttons();
        for (int i = 0; i < buffer.limit(); ++i) {
            int btn = leftJoycon ? ButtonBinding.controller2Button(i) : i;
            boolean btnState = buffer.get() == 1;
            ButtonState state = ButtonState.NONE;
            ButtonState previousState = (ButtonState)((Object)InputManager.STATES.getOrDefault(btn, (Object)ButtonState.NONE));
            if (btnState != previousState.isPressed()) {
                state = btnState ? ButtonState.PRESS : ButtonState.RELEASE;
                this.handleButton(client, btn, btnState ? 0 : 1, btnState);
                if (btnState) {
                    BUTTON_COOLDOWNS.put(btn, 5);
                }
            } else if (btnState) {
                state = ButtonState.REPEAT;
                if (BUTTON_COOLDOWNS.getOrDefault(btn, 0) == 0) {
                    BUTTON_COOLDOWNS.put(btn, 5);
                    this.handleButton(client, btn, 2, true);
                }
            }
            InputManager.STATES.put(btn, (Object)state);
        }
    }

    private void fetchAxeInput(@NotNull class_310 client, @NotNull GLFWGamepadState gamepadState, boolean leftJoycon) {
        FloatBuffer buffer = gamepadState.axes();
        for (int i = 0; i < buffer.limit(); ++i) {
            int axis = leftJoycon ? ButtonBinding.controller2Button(i) : i;
            float value = buffer.get();
            float absValue = Math.abs(value);
            if (i == 1) {
                value *= -1.0f;
            }
            int state = (double)value > MidnightControlsConfig.rightDeadZone ? 1 : ((double)value < -MidnightControlsConfig.rightDeadZone ? 2 : 0);
            this.handleAxe(client, axis, value, absValue, state);
        }
    }

    private void handleButton(@NotNull class_310 client, int button, int action, boolean state) {
        if (this.controlsInput != null && this.controlsInput.focusedBinding != null) {
            if (action == 0 && !this.controlsInput.currentButtons.contains(button)) {
                this.controlsInput.currentButtons.add(button);
                int[] buttons = new int[this.controlsInput.currentButtons.size()];
                for (int i = 0; i < this.controlsInput.currentButtons.size(); ++i) {
                    buttons[i] = this.controlsInput.currentButtons.get(i);
                }
                this.controlsInput.focusedBinding.setButton(buttons);
                this.controlsInput.waiting = false;
            }
            return;
        }
        if (!(action != 0 && action != 2 || client.field_1755 == null || !MidnightInput.isScreenInteractive(client.field_1755) || button != 11 && button != 13 && button != 14 && button != 12)) {
            if (this.actionGuiCooldown == 0) {
                if (button == 11) {
                    this.changeFocus(client.field_1755, NavigationDirection.UP);
                } else if (button == 13) {
                    this.changeFocus(client.field_1755, NavigationDirection.DOWN);
                } else {
                    this.handleLeftRight(client.field_1755, button != 14);
                }
            }
            return;
        }
        if (action == 1) {
            class_364 focused;
            if (button == 0 && client.field_1755 != null && this.actionGuiCooldown == 0 && (focused = client.field_1755.method_25399()) != null && MidnightInput.isScreenInteractive(client.field_1755) && this.handleAButton(client.field_1755, focused)) {
                this.actionGuiCooldown = 5;
                return;
            }
            if (this.handleInventory(client, button)) {
                this.ignoreNextARelease = true;
                return;
            }
            if (button == 1 && client.field_1755 != null && client.field_1755.getClass() != class_442.class) {
                if (!MidnightControlsCompat.handleMenuBack(client, client.field_1755) && !this.tryGoBack(client.field_1755)) {
                    client.field_1755.method_25419();
                }
                return;
            }
        }
        if (button == 0 && client.field_1755 != null && !MidnightInput.isScreenInteractive(client.field_1755) && this.actionGuiCooldown == 0) {
            class_481 creativeScreen;
            class_437 class_4372 = client.field_1755;
            if (class_4372 instanceof class_481 && ((HandledScreenAccessor)(creativeScreen = (class_481)class_4372)).midnightcontrols$getSlotAt(client.field_1729.method_1603() * (double)client.method_22683().method_4486() / (double)client.method_22683().method_4480(), client.field_1729.method_1604() * (double)client.method_22683().method_4502() / (double)client.method_22683().method_4507()) != null) {
                return;
            }
            if (!this.ignoreNextARelease) {
                double mouseX = client.field_1729.method_1603() * (double)client.method_22683().method_4486() / (double)client.method_22683().method_4480();
                double mouseY = client.field_1729.method_1604() * (double)client.method_22683().method_4502() / (double)client.method_22683().method_4507();
                if (action == 0) {
                    class_437.method_25412(() -> client.field_1755.method_25402(mouseX, mouseY, 0), (String)"mouseClicked event handler", (String)client.field_1755.getClass().getCanonicalName());
                } else if (action == 1) {
                    class_437.method_25412(() -> client.field_1755.method_25406(mouseX, mouseY, 0), (String)"mouseReleased event handler", (String)client.field_1755.getClass().getCanonicalName());
                }
                this.actionGuiCooldown = 5;
            } else {
                this.ignoreNextARelease = false;
            }
        }
    }

    private boolean handleInventory(@NotNull class_310 client, int button) {
        return false;
    }

    public boolean tryGoBack(@NotNull class_437 screen) {
        ImmutableSet set = ImmutableSet.of((Object)"gui.back", (Object)"gui.done", (Object)"gui.cancel", (Object)"gui.toTitle", (Object)"gui.toMenu");
        return screen.method_25396().stream().filter(element -> element instanceof class_4264).map(element -> (class_4264)element).filter(element -> element.method_25369() != null && element.method_25369().method_10851() != null).anyMatch(element -> {
            if (set.stream().anyMatch(key -> element.method_25369().method_10851().toString().equals(key))) {
                element.method_25306();
                return true;
            }
            return false;
        });
    }

    private double getDeadZoneValue(int axis) {
        return axis == 0 || axis == 1 ? MidnightControlsConfig.leftDeadZone : MidnightControlsConfig.rightDeadZone;
    }

    private void handleAxe(@NotNull class_310 client, int axis, float value, float absValue, int state) {
        double deadZone;
        int asButtonState;
        int n = value > 0.5f ? 1 : (asButtonState = value < -0.5f ? 2 : 0);
        if ((axis == 4 || axis == 5 || axis == ButtonBinding.controller2Button(4) || axis == ButtonBinding.controller2Button(5)) && asButtonState == 2) {
            asButtonState = 0;
        }
        boolean currentPlusState = asButtonState == 1;
        boolean currentMinusState = asButtonState == 2;
        ButtonState previousPlusState = (ButtonState)((Object)InputManager.STATES.getOrDefault(ButtonBinding.axisAsButton(axis, true), (Object)ButtonState.NONE));
        ButtonState previousMinusState = (ButtonState)((Object)InputManager.STATES.getOrDefault(ButtonBinding.axisAsButton(axis, false), (Object)ButtonState.NONE));
        if (currentPlusState != previousPlusState.isPressed()) {
            InputManager.STATES.put(ButtonBinding.axisAsButton(axis, true), (Object)(currentPlusState ? ButtonState.PRESS : ButtonState.RELEASE));
            if (currentPlusState) {
                BUTTON_COOLDOWNS.put(ButtonBinding.axisAsButton(axis, true), 5);
            }
        } else if (currentPlusState) {
            InputManager.STATES.put(ButtonBinding.axisAsButton(axis, true), (Object)ButtonState.REPEAT);
            if (BUTTON_COOLDOWNS.getOrDefault(ButtonBinding.axisAsButton(axis, true), 0) == 0) {
                BUTTON_COOLDOWNS.put(ButtonBinding.axisAsButton(axis, true), 5);
            }
        }
        if (currentMinusState != previousMinusState.isPressed()) {
            InputManager.STATES.put(ButtonBinding.axisAsButton(axis, false), (Object)(currentMinusState ? ButtonState.PRESS : ButtonState.RELEASE));
            if (currentMinusState) {
                BUTTON_COOLDOWNS.put(ButtonBinding.axisAsButton(axis, false), 5);
            }
        } else if (currentMinusState) {
            InputManager.STATES.put(ButtonBinding.axisAsButton(axis, false), (Object)ButtonState.REPEAT);
            if (BUTTON_COOLDOWNS.getOrDefault(ButtonBinding.axisAsButton(axis, false), 0) == 0) {
                BUTTON_COOLDOWNS.put(ButtonBinding.axisAsButton(axis, false), 5);
            }
        }
        float axisValue = (double)absValue < (deadZone = this.getDeadZoneValue(axis)) ? 0.0f : (float)((double)absValue - deadZone);
        axisValue = (float)((double)axisValue / (1.0 - deadZone));
        axisValue = (float)Math.min((double)axisValue / MidnightControlsConfig.getAxisMaxValue(axis), 1.0);
        if (currentPlusState) {
            InputManager.BUTTON_VALUES.put(ButtonBinding.axisAsButton(axis, true), axisValue);
        } else {
            InputManager.BUTTON_VALUES.put(ButtonBinding.axisAsButton(axis, true), 0.0f);
        }
        if (currentMinusState) {
            InputManager.BUTTON_VALUES.put(ButtonBinding.axisAsButton(axis, false), axisValue);
        } else {
            InputManager.BUTTON_VALUES.put(ButtonBinding.axisAsButton(axis, false), 0.0f);
        }
        double deadZone2 = this.getDeadZoneValue(axis);
        if (this.controlsInput != null && this.controlsInput.focusedBinding != null) {
            if (asButtonState != 0 && !this.controlsInput.currentButtons.contains(ButtonBinding.axisAsButton(axis, asButtonState == 1))) {
                this.controlsInput.currentButtons.add(ButtonBinding.axisAsButton(axis, asButtonState == 1));
                int[] buttons = new int[this.controlsInput.currentButtons.size()];
                for (int i = 0; i < this.controlsInput.currentButtons.size(); ++i) {
                    buttons[i] = this.controlsInput.currentButtons.get(i);
                }
                this.controlsInput.focusedBinding.setButton(buttons);
                this.controlsInput.waiting = false;
            }
            return;
        }
        class_437 buttons = client.field_1755;
        if (buttons instanceof class_481) {
            class_481 creativeInventoryScreen = (class_481)buttons;
            if (axis == 3) {
                accessor = (CreativeInventoryScreenAccessor)creativeInventoryScreen;
                if (accessor.midnightcontrols$hasScrollbar() && (double)absValue >= deadZone2) {
                    creativeInventoryScreen.method_25401(0.0, 0.0, (double)(-value));
                }
                return;
            }
        } else {
            accessor = client.field_1755;
            if (accessor instanceof class_457) {
                class_457 advancementsScreen = (class_457)accessor;
                if (axis == 2 || axis == 3) {
                    accessor = (AdvancementsScreenAccessor)advancementsScreen;
                    if ((double)absValue >= deadZone2) {
                        class_454 tab = accessor.getSelectedTab();
                        tab.method_2313(axis == 2 ? (double)(-value) * 5.0 : 0.0, axis == 3 ? (double)(-value) * 5.0 : 0.0);
                    }
                    return;
                }
            } else if (client.field_1755 != null && axis == 3 && (double)absValue >= deadZone2) {
                client.field_1755.method_25396().stream().filter(element -> element instanceof class_350).map(element -> (class_350)element).filter(element -> element.method_37018().method_37028()).anyMatch(element -> {
                    element.method_25401(0.0, 0.0, (double)(-value));
                    return true;
                });
                return;
            }
        }
        absValue = (float)((double)absValue - deadZone2);
        absValue = (float)((double)absValue / (1.0 - deadZone2));
        absValue = (float)class_3532.method_15350((double)((double)absValue / MidnightControlsConfig.getAxisMaxValue(axis)), (double)0.0, (double)1.0);
        if (client.field_1755 == null) {
            this.handleLook(client, axis, absValue, state);
        } else {
            boolean allowMouseControl = true;
            if (this.actionGuiCooldown == 0 && MidnightControlsConfig.isMovementAxis(axis) && MidnightInput.isScreenInteractive(client.field_1755)) {
                if (MidnightControlsConfig.isForwardButton(axis, false, asButtonState)) {
                    allowMouseControl = this.changeFocus(client.field_1755, NavigationDirection.UP);
                } else if (MidnightControlsConfig.isBackButton(axis, false, asButtonState)) {
                    allowMouseControl = this.changeFocus(client.field_1755, NavigationDirection.DOWN);
                } else if (MidnightControlsConfig.isLeftButton(axis, false, asButtonState)) {
                    allowMouseControl = this.handleLeftRight(client.field_1755, false);
                } else if (MidnightControlsConfig.isRightButton(axis, false, asButtonState)) {
                    allowMouseControl = this.handleLeftRight(client.field_1755, true);
                }
            }
            float movementX = 0.0f;
            float movementY = 0.0f;
            if (MidnightControlsConfig.isBackButton(axis, false, value > 0.0f ? 1 : 2)) {
                movementY = absValue;
            } else if (MidnightControlsConfig.isForwardButton(axis, false, value > 0.0f ? 1 : 2)) {
                movementY = -absValue;
            } else if (MidnightControlsConfig.isLeftButton(axis, false, value > 0.0f ? 1 : 2)) {
                movementX = -absValue;
            } else if (MidnightControlsConfig.isRightButton(axis, false, value > 0.0f ? 1 : 2)) {
                movementX = absValue;
            }
            if (client.field_1755 != null && allowMouseControl) {
                boolean moving;
                boolean bl = moving = movementY != 0.0f || movementX != 0.0f;
                if (moving) {
                    if ((double)Math.abs(this.prevXAxis) < deadZone2 && (double)Math.abs(this.prevYAxis) < deadZone2) {
                        InputManager.INPUT_MANAGER.resetMouseTarget(client);
                    }
                    this.mouseSpeedX = movementX;
                    this.mouseSpeedY = movementY;
                } else {
                    this.mouseSpeedX = 0.0f;
                    this.mouseSpeedY = 0.0f;
                }
                if (Math.abs(this.mouseSpeedX) >= 0.05f || Math.abs(this.mouseSpeedY) >= 0.05f) {
                    InputManager.queueMoveMousePosition((double)this.mouseSpeedX * MidnightControlsConfig.mouseSpeed, (double)this.mouseSpeedY * MidnightControlsConfig.mouseSpeed);
                }
                this.moveMouseToClosestSlot(client, client.field_1755);
            }
            this.prevXAxis = movementX;
            this.prevYAxis = movementY;
        }
    }

    private boolean handleAButton(@NotNull class_437 screen, @NotNull class_364 focused) {
        class_4069 widget;
        class_364 childFocused;
        if (focused instanceof class_4264) {
            class_4264 widget2 = (class_4264)focused;
            widget2.method_25354(class_310.method_1551().method_1483());
            widget2.method_25306();
            return true;
        }
        if (focused instanceof AbstractSprucePressableButtonWidget) {
            AbstractSprucePressableButtonWidget widget3 = (AbstractSprucePressableButtonWidget)focused;
            widget3.playDownSound();
            widget3.onPress();
            return true;
        }
        if (focused instanceof SpruceLabelWidget) {
            SpruceLabelWidget labelWidget = (SpruceLabelWidget)focused;
            labelWidget.onPress();
            return true;
        }
        if (focused instanceof class_528) {
            class_528 list = (class_528)focused;
            list.method_20159().ifPresent(class_528.class_4272::method_20164);
            return true;
        }
        if (focused instanceof class_4267) {
            class_4267 list = (class_4267)focused;
            class_4267.class_504 entry = (class_4267.class_504)list.method_25334();
            if (entry instanceof class_4267.class_4269 || entry instanceof class_4267.class_4270) {
                ((class_500)screen).method_2531(entry);
                ((class_500)screen).method_2536();
            }
        } else if (focused instanceof SpruceParentWidget) {
            SpruceWidget childFocused2 = ((SpruceParentWidget)focused).getFocused();
            if (childFocused2 != null) {
                return this.handleAButton(screen, (class_364)childFocused2);
            }
        } else if (focused instanceof class_4069 && (childFocused = (widget = (class_4069)focused).method_25399()) != null) {
            return this.handleAButton(screen, childFocused);
        }
        return false;
    }

    private boolean handleLeftRight(@NotNull class_437 screen, boolean right) {
        if (screen instanceof SpruceScreen) {
            SpruceScreen spruceScreen = (SpruceScreen)screen;
            spruceScreen.onNavigation(right ? NavigationDirection.RIGHT : NavigationDirection.LEFT, false);
            this.actionGuiCooldown = 5;
            return false;
        }
        class_364 focused = screen.method_25399();
        if (focused != null && this.handleRightLeftElement(focused, right)) {
            return this.changeFocus(screen, right ? NavigationDirection.RIGHT : NavigationDirection.LEFT);
        }
        return true;
    }

    private boolean handleRightLeftElement(@NotNull class_364 element, boolean right) {
        if (element instanceof SpruceElement) {
            SpruceElement spruceElement = (SpruceElement)element;
            if (spruceElement.requiresCursor()) {
                return true;
            }
            return !spruceElement.onNavigation(right ? NavigationDirection.RIGHT : NavigationDirection.LEFT, false);
        }
        if (element instanceof class_357) {
            class_357 slider = (class_357)element;
            slider.method_25404(right ? 262 : 263, 0, 0);
            this.actionGuiCooldown = 2;
            return false;
        }
        if (element instanceof class_4280) {
            ((EntryListWidgetAccessor)element).midnightcontrols$moveSelection(right ? class_350.class_5403.field_25661 : class_350.class_5403.field_25662);
            return false;
        }
        if (element instanceof class_4069) {
            class_4069 entryList = (class_4069)element;
            class_364 focused = entryList.method_25399();
            if (focused == null) {
                return true;
            }
            return this.handleRightLeftElement(focused, right);
        }
        return true;
    }

    public void handleLook(@NotNull class_310 client, int axis, float value, int state) {
        if (client.field_1724 != null) {
            double powValue = Math.pow(value, 2.0);
            if (axis == 3) {
                if (state == 2) {
                    this.targetPitch = -MidnightControlsConfig.getRightYAxisSign() * (MidnightControlsConfig.rotationSpeed * powValue) * 0.11;
                } else if (state == 1) {
                    this.targetPitch = MidnightControlsConfig.getRightYAxisSign() * (MidnightControlsConfig.rotationSpeed * powValue) * 0.11;
                }
            }
            if (axis == 2) {
                if (state == 2) {
                    this.targetYaw = -MidnightControlsConfig.getRightXAxisSign() * (MidnightControlsConfig.rotationSpeed * powValue) * 0.11;
                } else if (state == 1) {
                    this.targetYaw = MidnightControlsConfig.getRightXAxisSign() * (MidnightControlsConfig.rotationSpeed * powValue) * 0.11;
                }
            }
        }
    }

    private boolean changeFocus(@NotNull class_437 screen, NavigationDirection direction) {
        if (screen instanceof SpruceScreen) {
            SpruceScreen spruceScreen = (SpruceScreen)screen;
            if (spruceScreen.onNavigation(direction, false)) {
                this.actionGuiCooldown = 5;
            }
            return false;
        }
        if (!screen.method_25407(direction.isLookingForward())) {
            if (screen.method_25407(direction.isLookingForward())) {
                this.actionGuiCooldown = 5;
                return false;
            }
            return true;
        }
        this.actionGuiCooldown = 5;
        return false;
    }

    public static boolean isScreenInteractive(@NotNull class_437 screen) {
        return !(screen instanceof class_465) && !MidnightControlsConfig.mouseScreens.stream().anyMatch(a -> screen.getClass().toString().contains((CharSequence)a)) && (!(screen instanceof SpruceScreen) || !((SpruceScreen)screen).requiresCursor()) && !MidnightControlsCompat.requireMouseOnScreen(screen);
    }

    private void moveMouseToClosestSlot(@NotNull class_310 client, @Nullable class_437 screen) {
        if (screen instanceof class_465) {
            class_465 inventoryScreen = (class_465)screen;
            HandledScreenAccessor accessor = (HandledScreenAccessor)inventoryScreen;
            int guiLeft = accessor.getX();
            int guiTop = accessor.getY();
            int mouseX = (int)((double)this.targetMouseX * (double)client.method_22683().method_4486() / (double)client.method_22683().method_4480());
            int mouseY = (int)((double)this.targetMouseY * (double)client.method_22683().method_4502() / (double)client.method_22683().method_4507());
            Optional<Pair> closestSlot = inventoryScreen.method_17577().field_7761.parallelStream().map(slot -> {
                int x = guiLeft + slot.field_7873 + 8;
                int y = guiTop + slot.field_7872 + 8;
                double distance = Math.sqrt(Math.pow(x - mouseX, 2.0) + Math.pow(y - mouseY, 2.0));
                return Pair.of((Object)slot, (Object)distance);
            }).filter(entry -> (Double)entry.value <= 14.0).min(Comparator.comparingDouble(p -> (Double)p.value));
            if (closestSlot.isPresent()) {
                class_1735 slot2 = (class_1735)closestSlot.get().key;
                if (slot2.method_7681() || !client.field_1724.method_31548().method_7391().method_7960()) {
                    int slotCenterXScaled = guiLeft + slot2.field_7873 + 8;
                    int slotCenterYScaled = guiTop + slot2.field_7872 + 8;
                    int slotCenterX = (int)((double)slotCenterXScaled / ((double)client.method_22683().method_4486() / (double)client.method_22683().method_4480()));
                    int slotCenterY = (int)((double)slotCenterYScaled / ((double)client.method_22683().method_4502() / (double)client.method_22683().method_4507()));
                    double deltaX = slotCenterX - this.targetMouseX;
                    double deltaY = slotCenterY - this.targetMouseY;
                    if (mouseX != slotCenterXScaled || mouseY != slotCenterYScaled) {
                        this.targetMouseX = (int)((double)this.targetMouseX + deltaX * 0.75);
                        this.targetMouseY = (int)((double)this.targetMouseY + deltaY * 0.75);
                    } else {
                        this.mouseSpeedX *= 0.3f;
                        this.mouseSpeedY *= 0.3f;
                    }
                    this.mouseSpeedX *= 0.75f;
                    this.mouseSpeedY *= 0.75f;
                } else {
                    this.mouseSpeedX *= 0.1f;
                    this.mouseSpeedY *= 0.1f;
                }
            } else {
                this.mouseSpeedX *= 0.3f;
                this.mouseSpeedY *= 0.3f;
            }
        } else {
            this.mouseSpeedX = 0.0f;
            this.mouseSpeedY = 0.0f;
        }
    }
}

