/*
 * Decompiled with CFR 0.152.
 */
package eu.midnightdust.midnightcontrols.client;

import eu.midnightdust.lib.config.MidnightConfig;
import eu.midnightdust.midnightcontrols.ControlsMode;
import eu.midnightdust.midnightcontrols.MidnightControlsFeature;
import eu.midnightdust.midnightcontrols.client.ControllerType;
import eu.midnightdust.midnightcontrols.client.HudSide;
import eu.midnightdust.midnightcontrols.client.MidnightControlsClient;
import eu.midnightdust.midnightcontrols.client.VirtualMouseSkin;
import eu.midnightdust.midnightcontrols.client.controller.ButtonBinding;
import eu.midnightdust.midnightcontrols.client.controller.Controller;
import eu.midnightdust.midnightcontrols.client.controller.InputManager;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MidnightControlsConfig
extends MidnightConfig {
    @MidnightConfig.Entry
    public static ControlsMode controlsMode = ControlsMode.DEFAULT;
    @MidnightConfig.Entry
    public static boolean autoSwitchMode = true;
    @MidnightConfig.Entry
    public static boolean debug = false;
    @MidnightConfig.Entry
    public static boolean hudEnable = true;
    @MidnightConfig.Entry
    public static HudSide hudSide = HudSide.LEFT;
    @MidnightConfig.Entry
    public static boolean analogMovement = true;
    @MidnightConfig.Entry
    public static boolean fastBlockPlacing = false;
    @MidnightConfig.Entry
    public static boolean flyDrifting = true;
    @MidnightConfig.Entry
    public static boolean verticalFlyDrifting = true;
    @MidnightConfig.Entry
    public static boolean horizontalReacharound = false;
    @MidnightConfig.Entry
    public static boolean verticalReacharound = false;
    @MidnightConfig.Entry
    public static boolean shouldRenderReacharoundOutline = true;
    @MidnightConfig.Entry
    public static int[] reacharoundOutlineColor = new int[]{255, 255, 255, 102};
    @MidnightConfig.Entry
    public static ControllerType controllerType = ControllerType.DEFAULT;
    @MidnightConfig.Entry
    public static double rightDeadZone = 0.25;
    @MidnightConfig.Entry
    public static double leftDeadZone = 0.25;
    @MidnightConfig.Entry
    public static boolean invertRightYAxis = false;
    @MidnightConfig.Entry
    public static boolean invertRightXAxis = false;
    @MidnightConfig.Entry
    public static double DEFAULT_MAX_VALUE = 1.0;
    @MidnightConfig.Entry
    public static double rotationSpeed = 40.0;
    @MidnightConfig.Entry
    public static double mouseSpeed = 25.0;
    @MidnightConfig.Entry
    public static boolean unfocusedInput = false;
    @MidnightConfig.Entry
    public static boolean virtualMouse = false;
    @MidnightConfig.Entry
    public static VirtualMouseSkin virtualMouseSkin = VirtualMouseSkin.DEFAULT_LIGHT;
    @MidnightConfig.Entry
    public static Object controllerID = 0;
    @MidnightConfig.Entry
    public static Object secondControllerID = -1;
    @MidnightConfig.Entry
    public static List<String> mouseScreens = List.of("me.jellysquid.mods.sodium.client.gui", "net.coderbot.iris.gui", "net.minecraft.client.gui.screen.advancement", "net.minecraft.client.gui.screen.pack.PackScreen", "net.minecraft.class_5375", "net.minecraft.class_457", "net.minecraft.class_408", "me.flashyreese.mods.reeses_sodium_options.client.gui");
    @MidnightConfig.Entry
    public static Map<String, String> BINDINGS = Map.of();
    private static final Pattern BUTTON_BINDING_PATTERN = Pattern.compile("(-?\\d+)\\+?");
    @MidnightConfig.Entry
    public static double[] maxAnalogValues = new double[]{DEFAULT_MAX_VALUE, DEFAULT_MAX_VALUE, DEFAULT_MAX_VALUE, DEFAULT_MAX_VALUE};

    public static void load() {
        MidnightControlsConfig.init((String)"midnightcontrols", MidnightControlsConfig.class);
        MidnightControlsClient.get().log("Configuration loaded.");
        InputManager.loadButtonBindings();
    }

    public static void save() {
        MidnightControlsConfig.write((String)"midnightcontrols");
        MidnightControlsClient.get().log("Configuration saved.");
        MidnightControlsFeature.refreshEnabled();
    }

    public static Controller getController() {
        Object raw = controllerID;
        if (raw instanceof Number) {
            return Controller.byId(((Number)raw).intValue());
        }
        if (raw instanceof String) {
            return Controller.byGuid((String)raw).orElse(Controller.byId(0));
        }
        return Controller.byId(0);
    }

    public static void setController(Controller controller) {
        controllerID = controller.id();
        MidnightControlsConfig.write((String)"midnightcontrols");
    }

    public static Optional<Controller> getSecondController() {
        Object raw = secondControllerID;
        if (raw instanceof Number) {
            if (((Number)raw).intValue() == -1) {
                return Optional.empty();
            }
            return Optional.of(Controller.byId(((Number)raw).intValue()));
        }
        if (raw instanceof String) {
            return Optional.of(Controller.byGuid((String)raw).orElse(Controller.byId(0)));
        }
        return Optional.empty();
    }

    public static void setSecondController(@Nullable Controller controller) {
        secondControllerID = controller == null ? -1 : controller.id();
    }

    public static double getRightXAxisSign() {
        return invertRightXAxis ? -1.0 : 1.0;
    }

    public static double getRightYAxisSign() {
        return invertRightYAxis ? -1.0 : 1.0;
    }

    public static double getAxisMaxValue(int axis) {
        if (axis >= maxAnalogValues.length) {
            return DEFAULT_MAX_VALUE;
        }
        return maxAnalogValues[axis];
    }

    public static void setAxisMaxValue(int axis, double value) {
        if (axis < maxAnalogValues.length) {
            MidnightControlsConfig.maxAnalogValues[axis] = value;
        }
    }

    public static void loadButtonBinding(@NotNull ButtonBinding button) {
        button.setButton(button.getDefaultButton());
        String code = BINDINGS.getOrDefault("controller.controls." + button.getName(), button.getButtonCode());
        Matcher matcher = BUTTON_BINDING_PATTERN.matcher(code);
        try {
            int[] buttons = new int[1];
            int count = 0;
            while (matcher.find()) {
                String current;
                if (++count > buttons.length) {
                    buttons = Arrays.copyOf(buttons, count);
                }
                if (!MidnightControlsConfig.checkValidity(button, code, current = matcher.group(1))) {
                    return;
                }
                buttons[count - 1] = Integer.parseInt(current);
            }
            if (count == 0) {
                MidnightControlsClient.get().warn("Malformed config value \"" + code + "\" for binding \"" + button.getName() + "\".");
                MidnightControlsConfig.setButtonBinding(button, new int[]{-1});
            }
            button.setButton(buttons);
        }
        catch (Exception e) {
            MidnightControlsClient.get().warn("Malformed config value \"" + code + "\" for binding \"" + button.getName() + "\".");
            BINDINGS.put("controller.controls." + button.getName(), button.getButtonCode());
        }
    }

    private static boolean checkValidity(@NotNull ButtonBinding binding, @NotNull String input, String group) {
        if (group == null) {
            MidnightControlsClient.get().warn("Malformed config value \"" + input + "\" for binding \"" + binding.getName() + "\".");
            BINDINGS.put("controller.controls." + binding.getName(), binding.getButtonCode());
            return false;
        }
        return true;
    }

    public static void setButtonBinding(@NotNull ButtonBinding binding, int[] button) {
        binding.setButton(button);
        BINDINGS.put("controller.controls." + binding.getName(), binding.getButtonCode());
    }

    public static boolean isBackButton(int btn, boolean isBtn, int state) {
        if (!isBtn && state == 0) {
            return false;
        }
        return ButtonBinding.axisAsButton(1, false) == ButtonBinding.axisAsButton(btn, state == 1);
    }

    public static boolean isForwardButton(int btn, boolean isBtn, int state) {
        if (!isBtn && state == 0) {
            return false;
        }
        return ButtonBinding.axisAsButton(1, true) == ButtonBinding.axisAsButton(btn, state == 1);
    }

    public static boolean isLeftButton(int btn, boolean isBtn, int state) {
        if (!isBtn && state == 0) {
            return false;
        }
        return ButtonBinding.axisAsButton(0, false) == ButtonBinding.axisAsButton(btn, state == 1);
    }

    public static boolean isRightButton(int btn, boolean isBtn, int state) {
        if (!isBtn && state == 0) {
            return false;
        }
        return ButtonBinding.axisAsButton(0, true) == ButtonBinding.axisAsButton(btn, state == 1);
    }

    public static boolean isMovementAxis(int axis) {
        return axis == 1 || axis == 0;
    }
}

