/*
 * Decompiled with CFR 0.152.
 */
package eu.midnightdust.midnightcontrols.client;

import dev.lambdaurora.spruceui.event.OpenScreenCallback;
import dev.lambdaurora.spruceui.hud.Hud;
import dev.lambdaurora.spruceui.hud.HudManager;
import eu.midnightdust.midnightcontrols.ControlsMode;
import eu.midnightdust.midnightcontrols.MidnightControls;
import eu.midnightdust.midnightcontrols.MidnightControlsFeature;
import eu.midnightdust.midnightcontrols.client.MidnightControlsConfig;
import eu.midnightdust.midnightcontrols.client.MidnightInput;
import eu.midnightdust.midnightcontrols.client.MidnightReacharound;
import eu.midnightdust.midnightcontrols.client.compat.MidnightControlsCompat;
import eu.midnightdust.midnightcontrols.client.controller.ButtonBinding;
import eu.midnightdust.midnightcontrols.client.controller.Controller;
import eu.midnightdust.midnightcontrols.client.controller.InputManager;
import eu.midnightdust.midnightcontrols.client.gui.MidnightControlsHud;
import eu.midnightdust.midnightcontrols.client.ring.KeyBindingRingAction;
import eu.midnightdust.midnightcontrols.client.ring.MidnightRing;
import java.io.File;
import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientTickEvents;
import net.fabricmc.fabric.api.client.keybinding.v1.KeyBindingHelper;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayConnectionEvents;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.fabricmc.fabric.api.resource.ResourceManagerHelper;
import net.fabricmc.fabric.api.resource.ResourcePackActivationType;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.ModContainer;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_304;
import net.minecraft.class_310;
import net.minecraft.class_3675;
import net.minecraft.class_368;
import net.minecraft.class_370;
import net.minecraft.class_634;
import org.jetbrains.annotations.NotNull;
import org.lwjgl.glfw.GLFW;

public class MidnightControlsClient
extends MidnightControls
implements ClientModInitializer {
    private static MidnightControlsClient INSTANCE;
    public static final class_304 BINDING_LOOK_UP;
    public static final class_304 BINDING_LOOK_RIGHT;
    public static final class_304 BINDING_LOOK_DOWN;
    public static final class_304 BINDING_LOOK_LEFT;
    public static final class_2960 CONTROLLER_BUTTONS;
    public static final class_2960 CONTROLLER_EXPANDED;
    public static final class_2960 CONTROLLER_AXIS;
    public static final class_2960 CURSOR_TEXTURE;
    public static final File MAPPINGS_FILE;
    public final MidnightInput input = new MidnightInput();
    public final MidnightRing ring = new MidnightRing(this);
    public final MidnightReacharound reacharound = new MidnightReacharound();
    private MidnightControlsHud hud;
    private ControlsMode previousControlsMode;

    public void onInitializeClient() {
        INSTANCE = this;
        KeyBindingHelper.registerKeyBinding((class_304)BINDING_LOOK_UP);
        KeyBindingHelper.registerKeyBinding((class_304)BINDING_LOOK_RIGHT);
        KeyBindingHelper.registerKeyBinding((class_304)BINDING_LOOK_DOWN);
        KeyBindingHelper.registerKeyBinding((class_304)BINDING_LOOK_LEFT);
        this.ring.registerAction("keybinding", KeyBindingRingAction.FACTORY);
        ClientPlayNetworking.registerGlobalReceiver((class_2960)CONTROLS_MODE_CHANNEL, (client, handler, buf, responseSender) -> responseSender.sendPacket(CONTROLS_MODE_CHANNEL, this.makeControlsModeBuffer(MidnightControlsConfig.controlsMode)));
        ClientPlayNetworking.registerGlobalReceiver((class_2960)FEATURE_CHANNEL, (client, handler, buf, responseSender) -> {
            int features = buf.method_10816();
            for (int i = 0; i < features; ++i) {
                String name = buf.method_10800(64);
                boolean allowed = buf.readBoolean();
                MidnightControlsFeature.fromName(name).ifPresent(feature -> client.execute(() -> feature.setAllowed(allowed)));
            }
        });
        ClientPlayConnectionEvents.JOIN.register((handler, sender, client) -> {
            sender.sendPacket(HELLO_CHANNEL, this.makeHello(MidnightControlsConfig.controlsMode));
            sender.sendPacket(CONTROLS_MODE_CHANNEL, this.makeControlsModeBuffer(MidnightControlsConfig.controlsMode));
        });
        ClientPlayConnectionEvents.DISCONNECT.register(this::onLeave);
        ClientTickEvents.START_CLIENT_TICK.register(this.reacharound::tick);
        ClientTickEvents.END_CLIENT_TICK.register(this::onTick);
        OpenScreenCallback.EVENT.register((client, screen) -> this.input.onScreenOpen(client, client.method_22683().method_4480(), client.method_22683().method_4507()));
        this.hud = new MidnightControlsHud(this);
        HudManager.register((Hud)this.hud);
        FabricLoader.getInstance().getModContainer("midnightcontrols").ifPresent(modContainer -> ResourceManagerHelper.registerBuiltinResourcePack((class_2960)new class_2960("midnightcontrols", "bedrock"), (ModContainer)modContainer, (ResourcePackActivationType)ResourcePackActivationType.NORMAL));
    }

    public void onMcInit(@NotNull class_310 client) {
        ButtonBinding.init(client.field_1690);
        MidnightControlsConfig.load();
        this.hud.setVisible(MidnightControlsConfig.hudEnable);
        Controller.updateMappings();
        GLFW.glfwSetJoystickCallback((jid, event) -> {
            if (event == 262145) {
                Controller controller = Controller.byId(jid);
                client.method_1566().method_1999((class_368)new class_370(class_370.class_371.field_2218, (class_2561)class_2561.method_43469((String)"midnightcontrols.controller.connected", (Object[])new Object[]{jid}), (class_2561)class_2561.method_43470((String)controller.getName())));
            } else if (event == 262146) {
                client.method_1566().method_1999((class_368)new class_370(class_370.class_371.field_2218, (class_2561)class_2561.method_43469((String)"midnightcontrols.controller.disconnected", (Object[])new Object[]{jid}), null));
            }
            this.switchControlsMode();
        });
        MidnightControlsCompat.init(this);
    }

    public void onTick(@NotNull class_310 client) {
        this.input.tick(client);
        if (MidnightControlsConfig.controlsMode == ControlsMode.CONTROLLER && (client.method_1569() || MidnightControlsConfig.unfocusedInput)) {
            this.input.tickController(client);
        }
    }

    public void onRender(class_310 client) {
        this.input.onRender(client.method_1488(), client);
    }

    public void onLeave(class_634 handler, class_310 client) {
        MidnightControlsFeature.resetAllAllowed();
    }

    public void switchControlsMode() {
        if (MidnightControlsConfig.autoSwitchMode) {
            if (MidnightControlsConfig.getController().isGamepad()) {
                this.previousControlsMode = MidnightControlsConfig.controlsMode;
                MidnightControlsConfig.controlsMode = ControlsMode.CONTROLLER;
            } else {
                if (this.previousControlsMode == null) {
                    this.previousControlsMode = ControlsMode.DEFAULT;
                }
                MidnightControlsConfig.controlsMode = this.previousControlsMode;
            }
        }
    }

    public void setHudEnabled(boolean enabled) {
        MidnightControlsConfig.hudEnable = enabled;
        this.hud.setVisible(enabled);
    }

    public static MidnightControlsClient get() {
        return INSTANCE;
    }

    static {
        BINDING_LOOK_UP = InputManager.makeKeyBinding(new class_2960("midnightcontrols", "look_up"), class_3675.class_307.field_1668, 328, "key.categories.movement");
        BINDING_LOOK_RIGHT = InputManager.makeKeyBinding(new class_2960("midnightcontrols", "look_right"), class_3675.class_307.field_1668, 326, "key.categories.movement");
        BINDING_LOOK_DOWN = InputManager.makeKeyBinding(new class_2960("midnightcontrols", "look_down"), class_3675.class_307.field_1668, 322, "key.categories.movement");
        BINDING_LOOK_LEFT = InputManager.makeKeyBinding(new class_2960("midnightcontrols", "look_left"), class_3675.class_307.field_1668, 324, "key.categories.movement");
        CONTROLLER_BUTTONS = new class_2960("midnightcontrols", "textures/gui/controller_buttons.png");
        CONTROLLER_EXPANDED = new class_2960("midnightcontrols", "textures/gui/controller_expanded.png");
        CONTROLLER_AXIS = new class_2960("midnightcontrols", "textures/gui/controller_axis.png");
        CURSOR_TEXTURE = new class_2960("midnightcontrols", "textures/gui/cursor.png");
        MAPPINGS_FILE = new File("config/gamecontrollercustommappings.txt");
    }
}

