/*
 * Decompiled with CFR 0.152.
 */
package eu.midnightdust.midnightcontrols;

import dev.lambdaurora.spruceui.util.Nameable;
import eu.midnightdust.midnightcontrols.client.MidnightControlsConfig;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

public class MidnightControlsFeature
implements Nameable {
    private static final List<MidnightControlsFeature> FEATURES = new ArrayList<MidnightControlsFeature>();
    public static final MidnightControlsFeature FAST_BLOCK_PLACING = new MidnightControlsFeature("fast_block_placing", true, MidnightControlsConfig.fastBlockPlacing);
    public static final MidnightControlsFeature HORIZONTAL_REACHAROUND = new MidnightControlsFeature("horizontal_reacharound", true, MidnightControlsConfig.horizontalReacharound);
    public static final MidnightControlsFeature VERTICAL_REACHAROUND = new MidnightControlsFeature("vertical_reacharound", true, MidnightControlsConfig.verticalReacharound);
    private final String key;
    private final boolean defaultAllowed;
    private boolean allowed;
    private final boolean defaultEnabled;
    private boolean enabled;

    public MidnightControlsFeature(@NotNull String key, boolean allowed, boolean enabled) {
        Objects.requireNonNull(key, "Feature key cannot be null.");
        this.key = key;
        this.defaultAllowed = allowed;
        this.setAllowed(this.defaultAllowed);
        this.defaultEnabled = enabled;
        this.setEnabled(this.defaultEnabled);
    }

    public MidnightControlsFeature(@NotNull String key) {
        this(key, false, false);
    }

    public void allow() {
        this.setAllowed(true);
    }

    public boolean isAllowed() {
        return this.allowed;
    }

    public void setAllowed(boolean allowed) {
        this.allowed = allowed;
    }

    public void resetAllowed() {
        this.setAllowed(this.defaultAllowed);
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public static void refreshEnabled() {
        VERTICAL_REACHAROUND.setEnabled(MidnightControlsConfig.verticalReacharound);
        FAST_BLOCK_PLACING.setEnabled(MidnightControlsConfig.fastBlockPlacing);
        HORIZONTAL_REACHAROUND.setEnabled(MidnightControlsConfig.horizontalReacharound);
    }

    public boolean isAvailable() {
        return this.isAllowed() && this.isEnabled();
    }

    public void reset() {
        this.resetAllowed();
        this.setEnabled(this.defaultEnabled);
    }

    @NotNull
    public String getName() {
        return this.key;
    }

    @NotNull
    public static Optional<MidnightControlsFeature> fromName(@NotNull String key) {
        Objects.requireNonNull(key, "Cannot find features with a null name.");
        return FEATURES.parallelStream().filter(feature -> feature.getName().equals(key)).findFirst();
    }

    public static void resetAll() {
        FEATURES.parallelStream().forEach(MidnightControlsFeature::reset);
    }

    public static void resetAllAllowed() {
        FEATURES.parallelStream().forEach(MidnightControlsFeature::resetAllowed);
    }

    static {
        FEATURES.add(FAST_BLOCK_PLACING);
        FEATURES.add(HORIZONTAL_REACHAROUND);
        FEATURES.add(VERTICAL_REACHAROUND);
    }
}

