/*
 * Decompiled with CFR 0.152.
 */
package dev.quantumfusion.hyphen.util;

import dev.quantumfusion.hyphen.scan.annotations.IgnoreInterfaces;
import dev.quantumfusion.hyphen.scan.annotations.IgnoreSuperclass;
import dev.quantumfusion.hyphen.util.ArrayUtil;
import dev.quantumfusion.hyphen.util.ScanUtil;
import java.lang.reflect.AnnotatedType;
import java.lang.reflect.Field;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;

public class ClassCache {
    private static final Map<Class<?>, List<FieldInfo>> FIELD_CACHE = new IdentityHashMap();
    private static final Map<Class<?>, AnnotatedType[]> INTERFACE_CACHE = new IdentityHashMap();
    private static final Map<Class<?>, AnnotatedType[]> INHERITED_CACHE = new IdentityHashMap();
    private static final Map<Class<?>, AnnotatedType> SUPER_CACHE = new IdentityHashMap();

    public static AnnotatedType[] getInherited(Class<?> clazz) {
        return ClassCache.cache(INHERITED_CACHE, clazz, c -> {
            if (c.isArray()) {
                return ArrayUtil.map(ClassCache.getInherited(clazz.componentType()), AnnotatedType[]::new, annotatedType -> ScanUtil.wrap((Type)((Object)ScanUtil.getClassFrom(annotatedType).arrayType())));
            }
            AnnotatedType[] classInterface = ClassCache.getInterfaces(clazz);
            AnnotatedType classSuper = ClassCache.getSuperClass(clazz);
            if (classSuper != null) {
                return ScanUtil.append(classInterface, classSuper);
            }
            return classInterface;
        });
    }

    public static AnnotatedType getSuperClass(Class<?> clazz) {
        return ClassCache.cache(SUPER_CACHE, clazz, c -> {
            if (clazz.getDeclaredAnnotation(IgnoreSuperclass.class) == null && c.getSuperclass() != null) {
                return c.getAnnotatedSuperclass();
            }
            return null;
        });
    }

    public static AnnotatedType[] getInterfaces(Class<?> clazz) {
        return ClassCache.cache(INTERFACE_CACHE, clazz, c -> {
            if (clazz.getDeclaredAnnotation(IgnoreInterfaces.class) == null) {
                return clazz.getAnnotatedInterfaces();
            }
            return new AnnotatedType[0];
        });
    }

    public static List<FieldInfo> getFields(Class<?> clazz) {
        return ClassCache.cache(FIELD_CACHE, clazz, c -> {
            ArrayList<FieldInfo> out = new ArrayList<FieldInfo>();
            for (Field field : clazz.getDeclaredFields()) {
                if ((field.getModifiers() & 8) != 0) continue;
                out.add(new FieldInfo(field, field.getAnnotatedType()));
            }
            return out;
        });
    }

    private static <K, O> O cache(Map<K, O> cache, K key, Function<K, O> creator) {
        if (cache.containsKey(key)) {
            return cache.get(key);
        }
        O apply = creator.apply(key);
        cache.put(key, apply);
        return apply;
    }

    public record FieldInfo(Field field, AnnotatedType type) {
        @Override
        public String toString() {
            return this.field.getName() + " : " + this.type;
        }
    }
}

