/*
 * Decompiled with CFR 0.152.
 */
package dev.quantumfusion.hyphen.scan.type;

import dev.quantumfusion.hyphen.SerializerHandler;
import dev.quantumfusion.hyphen.scan.Clazzifier;
import dev.quantumfusion.hyphen.scan.Direction;
import dev.quantumfusion.hyphen.scan.FieldEntry;
import dev.quantumfusion.hyphen.scan.type.UnknownClazz;
import dev.quantumfusion.hyphen.thr.HyphenException;
import dev.quantumfusion.hyphen.util.ClassCache;
import dev.quantumfusion.hyphen.util.ScanUtil;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedType;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.StringJoiner;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Clazz {
    @NotNull
    public final Class<?> aClass;
    protected final SerializerHandler<?, ?> handler;
    protected final Map<Class<? extends Annotation>, Object> annotations;

    protected Clazz(SerializerHandler<?, ?> handler, @NotNull Class<?> aClass, Map<Class<? extends Annotation>, Object> annotations) {
        this.aClass = aClass;
        this.handler = handler;
        this.annotations = annotations;
    }

    public Clazz(SerializerHandler<?, ?> handler, @NotNull Class<?> aClass) {
        this.aClass = aClass;
        this.handler = handler;
        HashMap<Class<? extends Annotation>, Object> map = new HashMap<Class<? extends Annotation>, Object>();
        ScanUtil.addAnnotations(aClass, map);
        this.annotations = map;
    }

    public static Clazz create(SerializerHandler<?, ?> handler, AnnotatedType type, @Nullable Clazz ctx) {
        return new Clazz(handler, (Class)type.getType(), ScanUtil.acquireAnnotations(handler, type, ctx));
    }

    public Object getAnnotationValue(Class<? extends Annotation> aClass) {
        return this.annotations.get(aClass);
    }

    public boolean containsAnnotation(Class<? extends Annotation> aClass) {
        return this.annotations.containsKey(aClass);
    }

    public Class<?> getDefinedClass() {
        return this.aClass;
    }

    public Class<?> getBytecodeClass() {
        return this.aClass;
    }

    public Clazz define(String typeName) {
        return UnknownClazz.UNKNOWN;
    }

    public Clazz asSub(Class<?> sub) {
        AnnotatedType[] path = ScanUtil.findPath(ScanUtil.wrap(sub), test -> ScanUtil.getClassFrom(test) == this.aClass, clazz -> ClassCache.getInherited(ScanUtil.getClassFrom(clazz)));
        if (path == null) {
            throw new RuntimeException(sub.getSimpleName() + " does not inherit " + this.aClass.getSimpleName());
        }
        Clazz ctx = this;
        for (int i = path.length - 1; i >= 0; --i) {
            ctx = Clazzifier.create(this.handler, path[i], ctx, Direction.SUB);
        }
        return ctx;
    }

    public List<FieldEntry> getFields() {
        ArrayList<FieldEntry> fieldEntries = new ArrayList<FieldEntry>();
        AnnotatedType aSuper = ClassCache.getSuperClass(this.aClass);
        if (aSuper != null) {
            fieldEntries.addAll(Clazzifier.create(this.handler, aSuper, this, Direction.SUPER).getFields());
        }
        for (ClassCache.FieldInfo field : ClassCache.getFields(this.aClass)) {
            try {
                fieldEntries.add(new FieldEntry(field.field(), Clazzifier.create(this.handler, new ScanUtil.FieldAnnotatedType(field.field(), field.type()), this, Direction.NORMAL)));
            }
            catch (Throwable throwable) {
                throw HyphenException.thr("field", "\u239b", field, throwable);
            }
        }
        return fieldEntries;
    }

    public int defined() {
        return 1;
    }

    public String toString() {
        StringJoiner annotationJoiner = new StringJoiner("_", "<", ">");
        this.annotations.forEach((aClass1, value) -> annotationJoiner.add("@" + aClass1.getSimpleName() + value));
        return this.aClass.getSimpleName() + "_" + annotationJoiner;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Clazz clazz = (Clazz)o;
        return this.aClass.equals(clazz.aClass) && Objects.equals(this.annotations, clazz.annotations);
    }

    public int hashCode() {
        return Objects.hash(this.aClass, this.annotations);
    }
}

