/*
 * Decompiled with CFR 0.152.
 */
package dev.quantumfusion.hyphen.io;

import dev.quantumfusion.hyphen.HyphenSerializer;
import dev.quantumfusion.hyphen.io.IOInterface;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.nio.Buffer;
import org.jetbrains.annotations.Nullable;
import sun.misc.Unsafe;

public final class UnsafeIO
implements IOInterface {
    private static final Unsafe UNSAFE = UnsafeIO.getUnsafeInstance();
    private static final int BOOLEAN_OFFSET = Unsafe.ARRAY_BOOLEAN_BASE_OFFSET;
    private static final int BYTE_OFFSET = Unsafe.ARRAY_BYTE_BASE_OFFSET;
    private static final int CHAR_OFFSET = Unsafe.ARRAY_CHAR_BASE_OFFSET;
    private static final int SHORT_OFFSET = Unsafe.ARRAY_SHORT_BASE_OFFSET;
    private static final int INT__OFFSET = Unsafe.ARRAY_INT_BASE_OFFSET;
    private static final int LONG_OFFSET = Unsafe.ARRAY_LONG_BASE_OFFSET;
    private static final int FLOAT_OFFSET = Unsafe.ARRAY_FLOAT_BASE_OFFSET;
    private static final int DOUBLE_OFFSET = Unsafe.ARRAY_DOUBLE_BASE_OFFSET;
    private static final long STRING_FIELD_OFFSET;
    private static final long STRING_ENCODING_OFFSET;
    private static final long BUFFER_ADDRESS_OFFSET;
    private static final int COPY_MEMORY_THRESHOLD = 10;
    @Nullable
    private final Buffer bb;
    private final long address;
    private long currentAddress;

    private UnsafeIO(long address, @Nullable Buffer bb) {
        this.address = address;
        this.currentAddress = address;
        this.bb = bb;
    }

    private static Unsafe getUnsafeInstance() {
        Class<Unsafe> clazz = Unsafe.class;
        for (Field field : clazz.getDeclaredFields()) {
            int modifiers;
            if (!field.getType().equals(clazz) || !Modifier.isStatic(modifiers = field.getModifiers()) || !Modifier.isFinal(modifiers)) continue;
            try {
                field.setAccessible(true);
                return (Unsafe)field.get(null);
            }
            catch (Exception exception) {
                break;
            }
        }
        throw new IllegalStateException("Unsafe is unavailable.");
    }

    public static final UnsafeIO create(int size) {
        return new UnsafeIO(UNSAFE.allocateMemory(size), null);
    }

    public static final UnsafeIO wrap(Buffer directByteBuffer) {
        if (!directByteBuffer.isDirect()) {
            throw new IllegalArgumentException("Bytebuffer is not direct");
        }
        return new UnsafeIO(UNSAFE.getLong(directByteBuffer, BUFFER_ADDRESS_OFFSET), directByteBuffer);
    }

    public static final <O> UnsafeIO create(HyphenSerializer<UnsafeIO, O> serializer, O data) {
        return UnsafeIO.create(serializer.measure(data));
    }

    @Override
    public final void rewind() {
        this.currentAddress = this.address;
    }

    @Override
    public final int pos() {
        return (int)((long)((int)this.currentAddress) - this.address);
    }

    @Override
    public final void close() {
        if (this.bb != null) {
            this.bb.clear();
        } else {
            UNSAFE.freeMemory(this.address);
        }
    }

    public long address() {
        return this.address;
    }

    @Override
    public final boolean getBoolean() {
        return UNSAFE.getBoolean(null, this.currentAddress++);
    }

    @Override
    public final byte getByte() {
        return UNSAFE.getByte(null, this.currentAddress++);
    }

    @Override
    public final char getChar() {
        char c = UNSAFE.getChar(null, this.currentAddress);
        this.currentAddress += 2L;
        return c;
    }

    @Override
    public final short getShort() {
        short s = UNSAFE.getShort(null, this.currentAddress);
        this.currentAddress += 2L;
        return s;
    }

    @Override
    public final int getInt() {
        int i = UNSAFE.getInt(null, this.currentAddress);
        this.currentAddress += 4L;
        return i;
    }

    @Override
    public final long getLong() {
        long l = UNSAFE.getLong(null, this.currentAddress);
        this.currentAddress += 8L;
        return l;
    }

    @Override
    public final float getFloat() {
        float f = UNSAFE.getFloat(null, this.currentAddress);
        this.currentAddress += 4L;
        return f;
    }

    @Override
    public final double getDouble() {
        double f = UNSAFE.getDouble(null, this.currentAddress);
        this.currentAddress += 8L;
        return f;
    }

    @Override
    public final String getString() {
        try {
            int infoBytes = UNSAFE.getInt(null, this.currentAddress);
            if (infoBytes == 0) {
                this.currentAddress += 4L;
                return "";
            }
            String string = (String)UNSAFE.allocateInstance(String.class);
            byte[] byteArray = new byte[Math.abs(infoBytes)];
            int arrayLength = byteArray.length;
            UNSAFE.copyMemory(null, this.currentAddress + 4L, byteArray, BYTE_OFFSET, arrayLength);
            UNSAFE.putObject(string, STRING_FIELD_OFFSET, byteArray);
            UNSAFE.putByte(string, STRING_ENCODING_OFFSET, (byte)(infoBytes < 0 ? 1 : 0));
            this.currentAddress += (long)(arrayLength + 4);
            return string;
        }
        catch (InstantiationException e) {
            throw new RuntimeException("String creation failed: ", e);
        }
    }

    @Override
    public final void putBoolean(boolean value) {
        UNSAFE.putBoolean(null, this.currentAddress++, value);
    }

    @Override
    public final void putByte(byte value) {
        UNSAFE.putByte(null, this.currentAddress++, value);
    }

    @Override
    public final void putChar(char value) {
        UNSAFE.putChar(null, this.currentAddress, value);
        this.currentAddress += 2L;
    }

    @Override
    public final void putShort(short value) {
        UNSAFE.putShort(null, this.currentAddress, value);
        this.currentAddress += 2L;
    }

    @Override
    public final void putInt(int value) {
        UNSAFE.putInt(null, this.currentAddress, value);
        this.currentAddress += 4L;
    }

    @Override
    public final void putLong(long value) {
        UNSAFE.putLong(null, this.currentAddress, value);
        this.currentAddress += 8L;
    }

    @Override
    public final void putFloat(float value) {
        UNSAFE.putFloat(null, this.currentAddress, value);
        this.currentAddress += 4L;
    }

    @Override
    public final void putDouble(double value) {
        UNSAFE.putDouble(null, this.currentAddress, value);
        this.currentAddress += 8L;
    }

    @Override
    public final void putString(String value) {
        byte[] bytes = (byte[])UNSAFE.getObject(value, STRING_FIELD_OFFSET);
        int length = bytes.length;
        UNSAFE.putInt(null, this.currentAddress, UNSAFE.getByte(value, STRING_ENCODING_OFFSET) == 0 ? length : -length);
        UNSAFE.copyMemory(bytes, BYTE_OFFSET, null, this.currentAddress + 4L, length);
        this.currentAddress += (long)(length + 4);
    }

    @Override
    public final boolean[] getBooleanArray(int length) {
        boolean[] array = new boolean[length];
        if (length > 10) {
            UNSAFE.copyMemory(null, this.currentAddress, array, BOOLEAN_OFFSET, length);
            this.currentAddress += (long)length;
        } else {
            for (int i = 0; i < length; ++i) {
                array[i] = this.getBoolean();
            }
        }
        return array;
    }

    @Override
    public final byte[] getByteArray(int length) {
        byte[] array = new byte[length];
        if (length > 10) {
            UNSAFE.copyMemory(null, this.currentAddress, array, BYTE_OFFSET, length);
            this.currentAddress += (long)length;
        } else {
            for (int i = 0; i < length; ++i) {
                array[i] = this.getByte();
            }
        }
        return array;
    }

    @Override
    public final char[] getCharArray(int length) {
        char[] array = new char[length];
        if (length > 10) {
            int bytes = length * 2;
            UNSAFE.copyMemory(null, this.currentAddress, array, CHAR_OFFSET, bytes);
            this.currentAddress += (long)bytes;
        } else {
            for (int i = 0; i < length; ++i) {
                array[i] = this.getChar();
            }
        }
        return array;
    }

    @Override
    public final short[] getShortArray(int length) {
        short[] array = new short[length];
        if (length > 10) {
            int bytes = length * 2;
            UNSAFE.copyMemory(null, this.currentAddress, array, SHORT_OFFSET, bytes);
            this.currentAddress += (long)bytes;
        } else {
            for (int i = 0; i < length; ++i) {
                array[i] = this.getShort();
            }
        }
        return array;
    }

    @Override
    public final int[] getIntArray(int length) {
        int[] array = new int[length];
        if (length > 10) {
            int bytes = length * 4;
            UNSAFE.copyMemory(null, this.currentAddress, array, INT__OFFSET, bytes);
            this.currentAddress += (long)bytes;
        } else {
            for (int i = 0; i < length; ++i) {
                array[i] = this.getInt();
            }
        }
        return array;
    }

    @Override
    public final long[] getLongArray(int length) {
        long[] array = new long[length];
        if (length > 10) {
            int bytes = length * 8;
            UNSAFE.copyMemory(null, this.currentAddress, array, LONG_OFFSET, bytes);
            this.currentAddress += (long)bytes;
        } else {
            for (int i = 0; i < length; ++i) {
                array[i] = this.getLong();
            }
        }
        return array;
    }

    @Override
    public final float[] getFloatArray(int length) {
        float[] array = new float[length];
        if (length > 10) {
            int bytes = length * 4;
            UNSAFE.copyMemory(null, this.currentAddress, array, FLOAT_OFFSET, bytes);
            this.currentAddress += (long)bytes;
        } else {
            for (int i = 0; i < length; ++i) {
                array[i] = this.getFloat();
            }
        }
        return array;
    }

    @Override
    public final double[] getDoubleArray(int length) {
        double[] array = new double[length];
        if (length > 10) {
            int bytes = length * 8;
            UNSAFE.copyMemory(null, this.currentAddress, array, DOUBLE_OFFSET, bytes);
            this.currentAddress += (long)bytes;
        } else {
            for (int i = 0; i < length; ++i) {
                array[i] = this.getDouble();
            }
        }
        return array;
    }

    @Override
    public final String[] getStringArray(int length) {
        String[] array = new String[length];
        for (int i = 0; i < length; ++i) {
            array[i] = this.getString();
        }
        return array;
    }

    @Override
    public final void putBooleanArray(boolean[] value, int length) {
        if (length > 10) {
            UNSAFE.copyMemory(value, BOOLEAN_OFFSET, null, this.currentAddress, length);
            this.currentAddress += (long)length;
        } else {
            for (boolean v : value) {
                this.putBoolean(v);
            }
        }
    }

    @Override
    public final void putByteArray(byte[] value, int length) {
        if (length > 10) {
            UNSAFE.copyMemory(value, BYTE_OFFSET, null, this.currentAddress, length);
            this.currentAddress += (long)length;
        } else {
            for (byte v : value) {
                this.putByte(v);
            }
        }
    }

    @Override
    public final void putCharArray(char[] value, int length) {
        if (length > 10) {
            int bytes = length * 2;
            UNSAFE.copyMemory(value, CHAR_OFFSET, null, this.currentAddress, bytes);
            this.currentAddress += (long)bytes;
        } else {
            for (char v : value) {
                this.putChar(v);
            }
        }
    }

    @Override
    public final void putShortArray(short[] value, int length) {
        if (length > 10) {
            int bytes = length * 2;
            UNSAFE.copyMemory(value, SHORT_OFFSET, null, this.currentAddress, bytes);
            this.currentAddress += (long)bytes;
        } else {
            for (short v : value) {
                this.putShort(v);
            }
        }
    }

    @Override
    public final void putIntArray(int[] value, int length) {
        if (length > 10) {
            int bytes = length * 4;
            UNSAFE.copyMemory(value, INT__OFFSET, null, this.currentAddress, bytes);
            this.currentAddress += (long)bytes;
        } else {
            for (int v : value) {
                this.putInt(v);
            }
        }
    }

    @Override
    public final void putLongArray(long[] value, int length) {
        if (length > 10) {
            int bytes = length * 8;
            UNSAFE.copyMemory(value, LONG_OFFSET, null, this.currentAddress, bytes);
            this.currentAddress += (long)bytes;
        } else {
            for (long v : value) {
                this.putLong(v);
            }
        }
    }

    @Override
    public final void putFloatArray(float[] value, int length) {
        if (length > 10) {
            int bytes = length * 4;
            UNSAFE.copyMemory(value, FLOAT_OFFSET, null, this.currentAddress, bytes);
            this.currentAddress += (long)bytes;
        } else {
            for (float v : value) {
                this.putFloat(v);
            }
        }
    }

    @Override
    public final void putDoubleArray(double[] value, int length) {
        if (length > 10) {
            int bytes = length * 8;
            UNSAFE.copyMemory(value, DOUBLE_OFFSET, null, this.currentAddress, bytes);
            this.currentAddress += (long)bytes;
        } else {
            for (double v : value) {
                this.putDouble(v);
            }
        }
    }

    @Override
    public final void putStringArray(String[] value, int length) {
        for (int i = 0; i < length; ++i) {
            this.putString(value[i]);
        }
    }

    public static final int getStringBytes(String string) {
        return ((byte[])UNSAFE.getObject(string, STRING_FIELD_OFFSET)).length + 4;
    }

    static {
        try {
            STRING_FIELD_OFFSET = UNSAFE.objectFieldOffset(String.class.getDeclaredField("value"));
            STRING_ENCODING_OFFSET = UNSAFE.objectFieldOffset(String.class.getDeclaredField("coder"));
            BUFFER_ADDRESS_OFFSET = UNSAFE.objectFieldOffset(Buffer.class.getDeclaredField("address"));
        }
        catch (NoSuchFieldException e) {
            throw new RuntimeException();
        }
    }
}

