/*
 * Decompiled with CFR 0.152.
 */
package dev.quantumfusion.hyphen.codegen.def;

import dev.quantumfusion.hyphen.Options;
import dev.quantumfusion.hyphen.SerializerHandler;
import dev.quantumfusion.hyphen.codegen.MethodHandler;
import dev.quantumfusion.hyphen.codegen.PackedBooleans;
import dev.quantumfusion.hyphen.codegen.Variable;
import dev.quantumfusion.hyphen.codegen.def.MethodDef;
import dev.quantumfusion.hyphen.codegen.def.SerializerDef;
import dev.quantumfusion.hyphen.codegen.statement.If;
import dev.quantumfusion.hyphen.codegen.statement.IfElse;
import dev.quantumfusion.hyphen.scan.FieldEntry;
import dev.quantumfusion.hyphen.scan.type.Clazz;
import dev.quantumfusion.hyphen.thr.HyphenException;
import dev.quantumfusion.hyphen.util.GenUtil;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;

public final class ClassDef
extends MethodDef {
    private final Map<FieldEntry, SerializerDef> fields = new LinkedHashMap<FieldEntry, SerializerDef>();
    private Class<?>[] constructorParameters;
    private Class<?> aClass;
    private boolean record;

    public ClassDef(SerializerHandler<?, ?> handler, Clazz clazz) {
        super(handler, clazz);
    }

    @Override
    public void scan(SerializerHandler<?, ?> handler, Clazz clazz) {
        block10: {
            this.aClass = clazz.getDefinedClass();
            this.record = this.aClass.isRecord();
            try {
                for (FieldEntry fieldEntry : clazz.getFields()) {
                    if (!this.shouldFieldSerialize(fieldEntry)) continue;
                    try {
                        this.fields.put(fieldEntry, handler.acquireDef(fieldEntry.clazz()));
                    }
                    catch (Throwable throwable) {
                        throw HyphenException.thr("field", "\u239b", fieldEntry, throwable);
                    }
                }
                if (!handler.options.get((Object)Options.DISABLE_PUT).booleanValue()) {
                    ArrayList constructorParameters = new ArrayList();
                    for (FieldEntry field : new Clazz(handler, clazz.getDefinedClass()).getFields()) {
                        if (!this.shouldFieldSerialize(field)) continue;
                        constructorParameters.add(field.clazz().getDefinedClass());
                    }
                    this.constructorParameters = (Class[])constructorParameters.toArray(Class[]::new);
                    try {
                        if (!Modifier.isPublic(this.aClass.getConstructor(this.constructorParameters).getModifiers())) {
                            throw new HyphenException("Could not access constructor", "Check if the constructor is public.");
                        }
                        break block10;
                    }
                    catch (NoSuchMethodException noSuchMethodException) {
                        throw new HyphenException(noSuchMethodException.getMessage(), "Check if the constructor holds all of the fields.");
                    }
                }
                this.constructorParameters = null;
            }
            catch (Throwable throwable) {
                throw HyphenException.thr("class", "\u239f", clazz, throwable);
            }
        }
    }

    private boolean shouldFieldSerialize(FieldEntry field) {
        return !Modifier.isTransient(field.field().getModifiers());
    }

    @Override
    protected void writeMethodGet(MethodHandler mh) {
        PackedBooleans packedBooleans = new PackedBooleans();
        for (Map.Entry<FieldEntry, SerializerDef> entry : this.fields.entrySet()) {
            if (!entry.getKey().isNullable() && !this.shouldCompactBoolean(entry.getKey())) continue;
            packedBooleans.countBoolean();
        }
        packedBooleans.writeGet(mh);
        mh.typeOp(187, this.aClass);
        mh.op(89);
        for (Map.Entry<FieldEntry, SerializerDef> entry : this.fields.entrySet()) {
            FieldEntry fieldEntry = entry.getKey();
            if (fieldEntry.isNullable()) {
                packedBooleans.getBoolean(mh);
                mh.op(3);
                IfElse anIf = new IfElse(mh, 160);
                try {
                    entry.getValue().writeGet(mh);
                    anIf.elseStart();
                    mh.op(1);
                    continue;
                }
                finally {
                    anIf.close();
                    continue;
                }
            }
            if (this.shouldCompactBoolean(fieldEntry)) {
                packedBooleans.getBoolean(mh);
                continue;
            }
            entry.getValue().writeGet(mh);
        }
        mh.callInst(183, this.aClass, "<init>", Void.TYPE, this.constructorParameters);
    }

    @Override
    protected void writeMethodPut(MethodHandler mh, Runnable valueLoad) {
        FieldEntry fieldEntry;
        PackedBooleans info = new PackedBooleans();
        for (Map.Entry<FieldEntry, SerializerDef> entry : this.fields.entrySet()) {
            fieldEntry = entry.getKey();
            if (fieldEntry.isNullable()) {
                info.initBoolean(mh);
                this.loadField(mh, fieldEntry, valueLoad);
                mh.op(89);
                mh.varOp(54, mh.addVar(fieldEntry.getFieldName() + "_cache", fieldEntry.getFieldType()));
                IfElse anIf = new IfElse(mh, 198);
                try {
                    info.falseBoolean(mh);
                    anIf.elseStart();
                    info.trueBoolean(mh);
                    continue;
                }
                finally {
                    anIf.close();
                    continue;
                }
            }
            if (!this.shouldCompactBoolean(fieldEntry)) continue;
            info.initBoolean(mh);
            this.loadField(mh, fieldEntry, valueLoad);
            info.consumeBoolean(mh);
        }
        info.writePut(mh);
        for (Map.Entry<FieldEntry, SerializerDef> entry : this.fields.entrySet()) {
            fieldEntry = entry.getKey();
            if (this.shouldCompactBoolean(fieldEntry)) continue;
            if (fieldEntry.isNullable()) {
                Variable cache = mh.getVar(fieldEntry.getFieldName() + "_cache");
                mh.varOp(21, cache);
                If i = new If(mh, 198);
                try {
                    entry.getValue().writePut(mh, () -> mh.varOp(21, cache));
                    continue;
                }
                finally {
                    i.close();
                    continue;
                }
            }
            entry.getValue().writePut(mh, () -> this.loadField(mh, fieldEntry, valueLoad));
        }
    }

    private boolean shouldCompactBoolean(FieldEntry fieldEntry) {
        return (Boolean)this.options.get((Object)Options.COMPACT_BOOLEANS) != false && fieldEntry.getFieldType() == Boolean.TYPE;
    }

    @Override
    public int getStaticSize() {
        if (this.fields.isEmpty()) {
            return 0;
        }
        int size = 0;
        int booleans = 0;
        for (Map.Entry<FieldEntry, SerializerDef> entry : this.fields.entrySet()) {
            if (entry.getKey().isNullable() || this.shouldCompactBoolean(entry.getKey())) {
                ++booleans;
                continue;
            }
            size += entry.getValue().getStaticSize();
        }
        return size + (booleans + 7 >> 3);
    }

    @Override
    public boolean hasDynamicSize() {
        return true;
    }

    @Override
    protected void writeMethodMeasure(MethodHandler mh, Runnable valueLoad) {
        if (this.fields.isEmpty()) {
            mh.op(3);
        } else {
            int i = 0;
            for (Map.Entry<FieldEntry, SerializerDef> entry : this.fields.entrySet()) {
                if (this.shouldCompactBoolean(entry.getKey())) continue;
                FieldEntry fieldEntry = entry.getKey();
                SerializerDef fieldDef = entry.getValue();
                int staticSize = fieldDef.getStaticSize();
                boolean isDynamicSize = fieldDef.hasDynamicSize();
                if (fieldEntry.isNullable()) {
                    if (isDynamicSize) {
                        this.loadField(mh, fieldEntry, valueLoad);
                        Variable cache = mh.addVar(fieldEntry.getFieldName() + "_cache", fieldEntry.getFieldType());
                        mh.op(89);
                        mh.varOp(54, cache);
                        IfElse anIf = new IfElse(mh, 198);
                        try {
                            fieldDef.writeMeasure(mh, () -> mh.varOp(21, cache));
                            if (staticSize != 0) {
                                mh.visitLdcInsn(staticSize);
                                mh.op(96);
                            }
                            this.ifNullMeasureWrite(mh, i++, anIf);
                            continue;
                        }
                        finally {
                            anIf.close();
                            continue;
                        }
                    }
                    if (staticSize == 0) continue;
                    this.loadField(mh, fieldEntry, valueLoad);
                    IfElse anIf = new IfElse(mh, 198);
                    try {
                        mh.visitLdcInsn(staticSize);
                        this.ifNullMeasureWrite(mh, i++, anIf);
                        continue;
                    }
                    finally {
                        anIf.close();
                        continue;
                    }
                }
                if (!isDynamicSize) continue;
                fieldDef.writeMeasure(mh, () -> this.loadField(mh, fieldEntry, valueLoad));
                if (i++ <= 0) continue;
                mh.op(96);
            }
            if (i == 0) {
                mh.op(3);
            }
        }
    }

    private void ifNullMeasureWrite(MethodHandler mh, int i, IfElse anIf) {
        if (i > 0) {
            mh.op(96);
            anIf.elseStart();
        } else {
            anIf.elseStart();
            mh.op(3);
        }
    }

    private void loadField(MethodHandler mh, FieldEntry fieldEntry, Runnable dataLoad) {
        dataLoad.run();
        Clazz clazz = fieldEntry.clazz();
        Field field = fieldEntry.field();
        Class<?> definedClass = clazz.getDefinedClass();
        Class<?> bytecodeClass = clazz.getBytecodeClass();
        String fieldName = field.getName();
        if (this.record) {
            mh.callInst(182, this.aClass, fieldName, bytecodeClass, new Class[0]);
        } else if (Modifier.isPublic(field.getModifiers())) {
            mh.visitFieldInsn(180, this.aClass, fieldName, field.getType());
        } else {
            try {
                definedClass.getDeclaredMethod("get" + GenUtil.upperCase(fieldName), new Class[0]);
                mh.callInst(182, this.aClass, fieldName, bytecodeClass, new Class[0]);
            }
            catch (NoSuchMethodException ignored) {
                throw new HyphenException("Could not find a way to access \"" + fieldName + "\"", "Try making the field public or add a getter");
            }
        }
        GenUtil.shouldCastGeneric(mh, definedClass, bytecodeClass);
    }
}

