/*
 * Decompiled with CFR 0.152.
 */
package net.coderbot.iris.shaderpack.discovery;

import java.io.IOException;
import java.net.URI;
import java.nio.file.CopyOption;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Collection;
import java.util.stream.Collectors;
import net.coderbot.iris.Iris;

public class ShaderpackDirectoryManager {
    private final Path root;

    public ShaderpackDirectoryManager(Path path) {
        this.root = path;
    }

    public void copyPackIntoDirectory(String string, Path path2) throws IOException {
        Path path3 = Iris.getShaderpacksDirectory().resolve(string);
        Files.copy(path2, path3, new CopyOption[0]);
        if (Files.isDirectory(path2, new LinkOption[0])) {
            Path path4;
            for (Path path5 : Files.walk(path2, new FileVisitOption[0]).filter(path -> Files.isDirectory(path, new LinkOption[0])).collect(Collectors.toList())) {
                path4 = path2.relativize(path5);
                if (Files.exists(path4, new LinkOption[0])) continue;
                Files.createDirectory(path3.resolve(path4), new FileAttribute[0]);
            }
            for (Path path5 : Files.walk(path2, new FileVisitOption[0]).filter(path -> !Files.isDirectory(path, new LinkOption[0])).collect(Collectors.toSet())) {
                path4 = path2.relativize(path5);
                Files.copy(path5, path3.resolve(path4), new CopyOption[0]);
            }
        }
    }

    public Collection<String> enumerate() throws IOException {
        return Files.list(this.root).filter(Iris::isValidShaderpack).map(path -> path.getFileName().toString()).collect(Collectors.toList());
    }

    public URI getDirectoryUri() {
        return this.root.toUri();
    }
}

