/*
 * Decompiled with CFR 0.152.
 */
package net.coderbot.iris.shaderpack;

import com.google.common.collect.ImmutableList;
import net.coderbot.iris.shaderpack.DirectiveHolder;
import net.coderbot.iris.shaderpack.OptionalBoolean;
import net.coderbot.iris.shaderpack.ShaderProperties;

public class PackShadowDirectives {
    public static final int MAX_SHADOW_COLOR_BUFFERS = 2;
    private int resolution;
    private Float fov;
    private float distance;
    private float distanceRenderMul;
    private float entityShadowDistanceMul;
    private boolean explicitRenderDistance;
    private float intervalSize;
    private final boolean shouldRenderTerrain;
    private final boolean shouldRenderTranslucent;
    private final boolean shouldRenderEntities;
    private final boolean shouldRenderPlayer;
    private final boolean shouldRenderBlockEntities;
    private final OptionalBoolean cullingState;
    private final ImmutableList<DepthSamplingSettings> depthSamplingSettings;
    private final ImmutableList<SamplingSettings> colorSamplingSettings;

    public PackShadowDirectives(ShaderProperties shaderProperties) {
        this.resolution = 1024;
        this.fov = null;
        this.distance = 160.0f;
        this.distanceRenderMul = -1.0f;
        this.entityShadowDistanceMul = 1.0f;
        this.explicitRenderDistance = false;
        this.intervalSize = 2.0f;
        this.shouldRenderTerrain = shaderProperties.getShadowTerrain().orElse(true);
        this.shouldRenderTranslucent = shaderProperties.getShadowTranslucent().orElse(true);
        this.shouldRenderEntities = shaderProperties.getShadowEntities().orElse(true);
        this.shouldRenderPlayer = shaderProperties.getShadowPlayer().orElse(false);
        this.shouldRenderBlockEntities = shaderProperties.getShadowBlockEntities().orElse(true);
        this.cullingState = shaderProperties.getShadowCulling();
        this.depthSamplingSettings = ImmutableList.of((Object)new DepthSamplingSettings(), (Object)new DepthSamplingSettings());
        ImmutableList.Builder builder = ImmutableList.builder();
        for (int i = 0; i < 2; ++i) {
            builder.add((Object)new SamplingSettings());
        }
        this.colorSamplingSettings = builder.build();
    }

    public PackShadowDirectives(PackShadowDirectives packShadowDirectives) {
        this.resolution = packShadowDirectives.resolution;
        this.fov = packShadowDirectives.fov;
        this.distance = packShadowDirectives.distance;
        this.distanceRenderMul = packShadowDirectives.distanceRenderMul;
        this.entityShadowDistanceMul = packShadowDirectives.entityShadowDistanceMul;
        this.explicitRenderDistance = packShadowDirectives.explicitRenderDistance;
        this.intervalSize = packShadowDirectives.intervalSize;
        this.shouldRenderTerrain = packShadowDirectives.shouldRenderTerrain;
        this.shouldRenderTranslucent = packShadowDirectives.shouldRenderTranslucent;
        this.shouldRenderEntities = packShadowDirectives.shouldRenderEntities;
        this.shouldRenderPlayer = packShadowDirectives.shouldRenderPlayer;
        this.shouldRenderBlockEntities = packShadowDirectives.shouldRenderBlockEntities;
        this.cullingState = packShadowDirectives.cullingState;
        this.depthSamplingSettings = packShadowDirectives.depthSamplingSettings;
        this.colorSamplingSettings = packShadowDirectives.colorSamplingSettings;
    }

    public int getResolution() {
        return this.resolution;
    }

    public Float getFov() {
        return this.fov;
    }

    public float getDistance() {
        return this.distance;
    }

    public float getDistanceRenderMul() {
        return this.distanceRenderMul;
    }

    public float getEntityShadowDistanceMul() {
        return this.entityShadowDistanceMul;
    }

    public boolean isDistanceRenderMulExplicit() {
        return this.explicitRenderDistance;
    }

    public float getIntervalSize() {
        return this.intervalSize;
    }

    public boolean shouldRenderTerrain() {
        return this.shouldRenderTerrain;
    }

    public boolean shouldRenderTranslucent() {
        return this.shouldRenderTranslucent;
    }

    public boolean shouldRenderEntities() {
        return this.shouldRenderEntities;
    }

    public boolean shouldRenderPlayer() {
        return this.shouldRenderPlayer;
    }

    public boolean shouldRenderBlockEntities() {
        return this.shouldRenderBlockEntities;
    }

    public OptionalBoolean getCullingState() {
        return this.cullingState;
    }

    public ImmutableList<DepthSamplingSettings> getDepthSamplingSettings() {
        return this.depthSamplingSettings;
    }

    public ImmutableList<SamplingSettings> getColorSamplingSettings() {
        return this.colorSamplingSettings;
    }

    public void acceptDirectives(DirectiveHolder directiveHolder) {
        directiveHolder.acceptCommentIntDirective("SHADOWRES", n -> {
            this.resolution = n;
        });
        directiveHolder.acceptConstIntDirective("shadowMapResolution", n -> {
            this.resolution = n;
        });
        directiveHolder.acceptCommentFloatDirective("SHADOWFOV", f -> {
            this.fov = Float.valueOf(f);
        });
        directiveHolder.acceptConstFloatDirective("shadowMapFov", f -> {
            this.fov = Float.valueOf(f);
        });
        directiveHolder.acceptCommentFloatDirective("SHADOWHPL", f -> {
            this.distance = f;
        });
        directiveHolder.acceptConstFloatDirective("shadowDistance", f -> {
            this.distance = f;
        });
        directiveHolder.acceptConstFloatDirective("entityShadowDistanceMul", f -> {
            this.entityShadowDistanceMul = f;
        });
        directiveHolder.acceptConstFloatDirective("shadowDistanceRenderMul", f -> {
            this.distanceRenderMul = f;
            this.explicitRenderDistance = true;
        });
        directiveHolder.acceptConstFloatDirective("shadowIntervalSize", f -> {
            this.intervalSize = f;
        });
        PackShadowDirectives.acceptHardwareFilteringSettings(directiveHolder, this.depthSamplingSettings);
        PackShadowDirectives.acceptDepthMipmapSettings(directiveHolder, this.depthSamplingSettings);
        PackShadowDirectives.acceptColorMipmapSettings(directiveHolder, this.colorSamplingSettings);
        PackShadowDirectives.acceptDepthFilteringSettings(directiveHolder, this.depthSamplingSettings);
        PackShadowDirectives.acceptColorFilteringSettings(directiveHolder, this.colorSamplingSettings);
    }

    private static void acceptHardwareFilteringSettings(DirectiveHolder directiveHolder, ImmutableList<DepthSamplingSettings> immutableList) {
        directiveHolder.acceptConstBooleanDirective("shadowHardwareFiltering", bl -> {
            for (DepthSamplingSettings depthSamplingSettings : immutableList) {
                depthSamplingSettings.setHardwareFiltering(bl);
            }
        });
        for (int i = 0; i < immutableList.size(); ++i) {
            String string = "shadowHardwareFiltering" + i;
            directiveHolder.acceptConstBooleanDirective(string, ((DepthSamplingSettings)immutableList.get(i))::setHardwareFiltering);
        }
    }

    private static void acceptDepthMipmapSettings(DirectiveHolder directiveHolder, ImmutableList<DepthSamplingSettings> immutableList) {
        directiveHolder.acceptConstBooleanDirective("generateShadowMipmap", bl -> {
            for (SamplingSettings samplingSettings : immutableList) {
                samplingSettings.setMipmap(bl);
            }
        });
        if (immutableList.size() >= 1) {
            directiveHolder.acceptConstBooleanDirective("shadowtexMipmap", ((DepthSamplingSettings)immutableList.get(0))::setMipmap);
        }
        for (int i = 0; i < immutableList.size(); ++i) {
            String string = "shadowtex" + i + "Mipmap";
            directiveHolder.acceptConstBooleanDirective(string, ((DepthSamplingSettings)immutableList.get(i))::setMipmap);
        }
    }

    private static void acceptColorMipmapSettings(DirectiveHolder directiveHolder, ImmutableList<SamplingSettings> immutableList) {
        directiveHolder.acceptConstBooleanDirective("generateShadowColorMipmap", bl -> {
            for (SamplingSettings samplingSettings : immutableList) {
                samplingSettings.setMipmap(bl);
            }
        });
        for (int i = 0; i < immutableList.size(); ++i) {
            String string = "shadowcolor" + i + "Mipmap";
            directiveHolder.acceptConstBooleanDirective(string, ((SamplingSettings)immutableList.get(i))::setMipmap);
            string = "shadowColor" + i + "Mipmap";
            directiveHolder.acceptConstBooleanDirective(string, ((SamplingSettings)immutableList.get(i))::setMipmap);
        }
    }

    private static void acceptDepthFilteringSettings(DirectiveHolder directiveHolder, ImmutableList<DepthSamplingSettings> immutableList) {
        if (immutableList.size() >= 1) {
            directiveHolder.acceptConstBooleanDirective("shadowtexNearest", ((DepthSamplingSettings)immutableList.get(0))::setNearest);
        }
        for (int i = 0; i < immutableList.size(); ++i) {
            String string = "shadowtex" + i + "Nearest";
            directiveHolder.acceptConstBooleanDirective(string, ((DepthSamplingSettings)immutableList.get(i))::setNearest);
            string = "shadow" + i + "MinMagNearest";
            directiveHolder.acceptConstBooleanDirective(string, ((DepthSamplingSettings)immutableList.get(i))::setNearest);
        }
    }

    private static void acceptColorFilteringSettings(DirectiveHolder directiveHolder, ImmutableList<SamplingSettings> immutableList) {
        for (int i = 0; i < immutableList.size(); ++i) {
            String string = "shadowcolor" + i + "Nearest";
            directiveHolder.acceptConstBooleanDirective(string, ((SamplingSettings)immutableList.get(i))::setNearest);
            string = "shadowColor" + i + "Nearest";
            directiveHolder.acceptConstBooleanDirective(string, ((SamplingSettings)immutableList.get(i))::setNearest);
            string = "shadowColor" + i + "MinMagNearest";
            directiveHolder.acceptConstBooleanDirective(string, ((SamplingSettings)immutableList.get(i))::setNearest);
        }
    }

    public String toString() {
        return "PackShadowDirectives{resolution=" + this.resolution + ", fov=" + this.fov + ", distance=" + this.distance + ", distanceRenderMul=" + this.distanceRenderMul + ", entityDistanceRenderMul=" + this.entityShadowDistanceMul + ", intervalSize=" + this.intervalSize + ", depthSamplingSettings=" + this.depthSamplingSettings + ", colorSamplingSettings=" + this.colorSamplingSettings + "}";
    }

    public static class DepthSamplingSettings
    extends SamplingSettings {
        private boolean hardwareFiltering = false;

        private void setHardwareFiltering(boolean bl) {
            this.hardwareFiltering = bl;
        }

        public boolean getHardwareFiltering() {
            return this.hardwareFiltering;
        }

        @Override
        public String toString() {
            return "DepthSamplingSettings{mipmap=" + this.getMipmap() + ", nearest=" + this.getNearest() + ", hardwareFiltering=" + this.hardwareFiltering + "}";
        }
    }

    public static class SamplingSettings {
        private boolean mipmap = false;
        private boolean nearest = false;

        protected void setMipmap(boolean bl) {
            this.mipmap = bl;
        }

        protected void setNearest(boolean bl) {
            this.nearest = bl;
        }

        public boolean getMipmap() {
            return this.mipmap;
        }

        public boolean getNearest() {
            return this.nearest;
        }

        public String toString() {
            return "SamplingSettings{mipmap=" + this.mipmap + ", nearest=" + this.nearest + "}";
        }
    }
}

