/*
 * Decompiled with CFR 0.152.
 */
package net.coderbot.iris.pipeline.newshader;

import com.mojang.blaze3d.platform.GlStateManager;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.function.Consumer;
import java.util.function.IntSupplier;
import net.coderbot.iris.Iris;
import net.coderbot.iris.gl.blending.AlphaTest;
import net.coderbot.iris.gl.blending.BlendModeOverride;
import net.coderbot.iris.gl.framebuffer.GlFramebuffer;
import net.coderbot.iris.gl.image.ImageHolder;
import net.coderbot.iris.gl.program.ProgramImages;
import net.coderbot.iris.gl.program.ProgramUniforms;
import net.coderbot.iris.gl.sampler.SamplerHolder;
import net.coderbot.iris.gl.texture.InternalTextureFormat;
import net.coderbot.iris.gl.uniform.DynamicUniformHolder;
import net.coderbot.iris.pipeline.newshader.IrisProgramTypes;
import net.coderbot.iris.pipeline.newshader.NewWorldRenderingPipeline;
import net.coderbot.iris.pipeline.newshader.ShaderAttributeInputs;
import net.coderbot.iris.pipeline.newshader.ShaderInstanceInterface;
import net.coderbot.iris.uniforms.CapturedRenderingState;
import net.minecraft.class_281;
import net.minecraft.class_284;
import net.minecraft.class_293;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3679;
import net.minecraft.class_5912;
import net.minecraft.class_5913;
import net.minecraft.class_5944;
import org.jetbrains.annotations.Nullable;

public class ExtendedShader
extends class_5944
implements SamplerHolder,
ImageHolder,
ShaderInstanceInterface {
    private final boolean intensitySwizzle;
    private final ProgramImages.Builder imageBuilder;
    NewWorldRenderingPipeline parent;
    ProgramUniforms uniforms;
    GlFramebuffer writingToBeforeTranslucent;
    GlFramebuffer writingToAfterTranslucent;
    GlFramebuffer baseline;
    BlendModeOverride blendModeOverride;
    HashMap<String, IntSupplier> dynamicSamplers;
    float alphaTest;
    private ProgramImages currentImages;
    private class_281 geometry;
    private boolean isFullbright;
    private final ShaderAttributeInputs inputs;

    public ExtendedShader(class_5912 class_59122, String string, class_293 class_2932, GlFramebuffer glFramebuffer, GlFramebuffer glFramebuffer2, GlFramebuffer glFramebuffer3, BlendModeOverride blendModeOverride, AlphaTest alphaTest, Consumer<DynamicUniformHolder> consumer, boolean bl, NewWorldRenderingPipeline newWorldRenderingPipeline, ShaderAttributeInputs shaderAttributeInputs) throws IOException {
        super(class_59122, string, class_2932);
        int n = this.method_1270();
        ProgramUniforms.Builder builder = ProgramUniforms.builder(string, n);
        consumer.accept(builder);
        this.uniforms = builder.buildUniforms();
        this.writingToBeforeTranslucent = glFramebuffer;
        this.writingToAfterTranslucent = glFramebuffer2;
        this.baseline = glFramebuffer3;
        this.blendModeOverride = blendModeOverride;
        this.dynamicSamplers = new HashMap();
        this.alphaTest = alphaTest.getReference();
        this.parent = newWorldRenderingPipeline;
        this.imageBuilder = ProgramImages.builder(n);
        this.currentImages = null;
        this.isFullbright = bl;
        this.inputs = shaderAttributeInputs;
        this.intensitySwizzle = this.method_35787().contains("intensity");
    }

    public boolean isIntensitySwizzle() {
        return this.intensitySwizzle;
    }

    public void method_34585() {
        ProgramUniforms.clearActiveUniforms();
        super.method_34585();
        if (this.blendModeOverride != null) {
            BlendModeOverride.restore();
        }
        class_310.method_1551().method_1522().method_1235(false);
    }

    public void method_34586() {
        this.dynamicSamplers.forEach((string, intSupplier) -> this.addIrisSampler((String)string, intSupplier.getAsInt()));
        CapturedRenderingState.INSTANCE.setCurrentAlphaTest(this.alphaTest);
        if (!this.inputs.hasTex()) {
            this.method_34583("Sampler0", this.parent.getWhitePixel().method_4624());
        }
        if (!this.inputs.hasLight()) {
            this.method_34583("Sampler2", this.parent.getWhitePixel().method_4624());
        }
        super.method_34586();
        this.uniforms.update();
        if (this.currentImages == null) {
            this.currentImages = this.imageBuilder.build();
        }
        this.currentImages.update();
        if (this.blendModeOverride != null) {
            this.blendModeOverride.apply();
        }
        if (this.parent.isBeforeTranslucent) {
            this.writingToBeforeTranslucent.bind();
        } else {
            this.writingToAfterTranslucent.bind();
        }
    }

    public void addIrisSampler(String string, int n) {
        super.method_34583(string, (Object)n);
    }

    public void addIrisSampler(String string, IntSupplier intSupplier) {
        this.dynamicSamplers.put(string, intSupplier);
    }

    public void method_34583(String string, Object object) {
        if (string.equals("Sampler0")) {
            string = "gtexture";
            super.method_34583("texture", object);
            super.method_34583("tex", object);
        } else if (string.equals("Sampler1")) {
            string = "iris_overlay";
        } else if (string.equals("Sampler2")) {
            string = "lightmap";
        } else {
            if (string.startsWith("Sampler")) {
                return;
            }
            Iris.logger.warn("Iris: didn't recognize the sampler name " + string + " in addSampler, please use addIrisSampler for custom Iris-specific samplers instead.");
            return;
        }
        super.method_34583(string, object);
    }

    @Nullable
    public class_284 method_34582(String string) {
        return super.method_34582("iris_" + string);
    }

    @Override
    public void addExternalSampler(int n, String ... stringArray) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    @Override
    public boolean hasSampler(String string) {
        return GlStateManager._glGetUniformLocation((int)this.method_1270(), (CharSequence)string) != -1;
    }

    @Override
    public boolean addDefaultSampler(IntSupplier intSupplier, String ... stringArray) {
        throw new UnsupportedOperationException("addDefaultSampler is not yet implemented");
    }

    @Override
    public boolean addDynamicSampler(IntSupplier intSupplier, String ... stringArray) {
        boolean bl = false;
        for (String string : stringArray) {
            if (this.hasSampler(string)) {
                bl = true;
            }
            this.addIrisSampler(string, intSupplier);
        }
        return bl;
    }

    @Override
    public boolean hasImage(String string) {
        return this.imageBuilder.hasImage(string);
    }

    @Override
    public void addTextureImage(IntSupplier intSupplier, InternalTextureFormat internalTextureFormat, String string) {
        this.imageBuilder.addTextureImage(intSupplier, internalTextureFormat, string);
        this.currentImages = null;
    }

    public void method_34418() {
        super.method_34418();
        if (this.geometry != null) {
            this.geometry.method_1281((class_3679)this);
        }
    }

    @Override
    public void iris$createGeometryShader(class_5912 class_59122, String string) throws IOException {
        class_59122.method_14486(new class_2960("minecraft", string + "_geometry.gsh")).ifPresent(class_32982 -> {
            try {
                this.geometry = class_281.method_1283((class_281.class_282)IrisProgramTypes.GEOMETRY, (String)string, (InputStream)class_32982.method_14482(), (String)class_32982.method_14480(), (class_5913)new class_5913(){

                    @Nullable
                    public String method_34233(boolean bl, String string) {
                        return null;
                    }
                });
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        });
    }

    public class_281 getGeometry() {
        return this.geometry;
    }
}

