/*
 * Decompiled with CFR 0.152.
 */
package net.coderbot.iris.compat.sodium.impl.vertex_format.terrain_xhfp;

import me.jellysquid.mods.sodium.client.model.vertex.buffer.VertexBufferView;
import me.jellysquid.mods.sodium.client.model.vertex.buffer.VertexBufferWriterUnsafe;
import me.jellysquid.mods.sodium.client.model.vertex.type.BufferVertexType;
import me.jellysquid.mods.sodium.client.render.chunk.format.ModelVertexSink;
import net.coderbot.iris.block_rendering.MaterialIdHolder;
import net.coderbot.iris.compat.sodium.impl.block_id.MaterialIdAwareVertexWriter;
import net.coderbot.iris.compat.sodium.impl.vertex_format.IrisModelVertexFormats;
import net.coderbot.iris.compat.sodium.impl.vertex_format.terrain_xhfp.QuadViewTerrain;
import net.coderbot.iris.compat.sodium.impl.vertex_format.terrain_xhfp.XHFPModelVertexType;
import net.coderbot.iris.vendored.joml.Vector3f;
import net.coderbot.iris.vertices.NormalHelper;
import org.lwjgl.system.MemoryUtil;

public class XHFPModelVertexBufferWriterUnsafe
extends VertexBufferWriterUnsafe
implements ModelVertexSink,
MaterialIdAwareVertexWriter {
    private final QuadViewTerrain.QuadViewTerrainUnsafe quad = new QuadViewTerrain.QuadViewTerrainUnsafe();
    private final Vector3f normal = new Vector3f();
    private MaterialIdHolder idHolder;
    private int vertexCount;
    private float uSum;
    private float vSum;

    public XHFPModelVertexBufferWriterUnsafe(VertexBufferView vertexBufferView) {
        super(vertexBufferView, (BufferVertexType)IrisModelVertexFormats.MODEL_VERTEX_XHFP);
    }

    @Override
    public void copyQuadAndFlipNormal() {
        this.ensureCapacity(4);
        MemoryUtil.memCopy((long)(this.writePointer - 160L), (long)this.writePointer, (long)160L);
        int n = MemoryUtil.memGetInt((long)(this.writePointer + 32L));
        int n2 = NormalHelper.invertPackedNormal(n);
        MemoryUtil.memPutInt((long)(this.writePointer + 32L), (int)n2);
        MemoryUtil.memPutInt((long)(this.writePointer + 32L + 40L), (int)n2);
        MemoryUtil.memPutInt((long)(this.writePointer + 32L + 80L), (int)n2);
        MemoryUtil.memPutInt((long)(this.writePointer + 32L + 120L), (int)n2);
        for (int i = 0; i < 4; ++i) {
            this.advance();
        }
        this.flush();
    }

    public void writeVertex(float f, float f2, float f3, int n, float f4, float f5, int n2, int n3) {
        this.uSum += f4;
        this.vSum += f5;
        short s = this.idHolder.id;
        short s2 = this.idHolder.renderType;
        this.writeQuadInternal(f, f2, f3, n, f4, f5, n2, s, s2, n3);
    }

    private void writeQuadInternal(float f, float f2, float f3, int n, float f4, float f5, int n2, short s, short s2, int n3) {
        long l = this.writePointer;
        ++this.vertexCount;
        MemoryUtil.memPutShort((long)(l + 0L), (short)XHFPModelVertexType.encodePosition(f));
        MemoryUtil.memPutShort((long)(l + 2L), (short)XHFPModelVertexType.encodePosition(f2));
        MemoryUtil.memPutShort((long)(l + 4L), (short)XHFPModelVertexType.encodePosition(f3));
        MemoryUtil.memPutShort((long)(l + 6L), (short)((short)n3));
        MemoryUtil.memPutInt((long)(l + 8L), (int)n);
        MemoryUtil.memPutShort((long)(l + 12L), (short)XHFPModelVertexType.encodeBlockTexture(f4));
        MemoryUtil.memPutShort((long)(l + 14L), (short)XHFPModelVertexType.encodeBlockTexture(f5));
        MemoryUtil.memPutInt((long)(l + 16L), (int)XHFPModelVertexType.encodeLightMapTexCoord(n2));
        MemoryUtil.memPutShort((long)(l + 36L), (short)s);
        MemoryUtil.memPutShort((long)(l + 38L), (short)s2);
        if (this.vertexCount == 4) {
            this.vertexCount = 0;
            this.uSum *= 0.25f;
            this.vSum *= 0.25f;
            MemoryUtil.memPutFloat((long)(l + 20L), (float)this.uSum);
            MemoryUtil.memPutFloat((long)(l + 20L - 40L), (float)this.uSum);
            MemoryUtil.memPutFloat((long)(l + 20L - 80L), (float)this.uSum);
            MemoryUtil.memPutFloat((long)(l + 20L - 120L), (float)this.uSum);
            MemoryUtil.memPutFloat((long)(l + 24L), (float)this.vSum);
            MemoryUtil.memPutFloat((long)(l + 24L - 40L), (float)this.vSum);
            MemoryUtil.memPutFloat((long)(l + 24L - 80L), (float)this.vSum);
            MemoryUtil.memPutFloat((long)(l + 24L - 120L), (float)this.vSum);
            this.uSum = 0.0f;
            this.vSum = 0.0f;
            this.quad.setup(l, 40);
            NormalHelper.computeFaceNormal(this.normal, this.quad);
            int n4 = NormalHelper.packNormal(this.normal, 0.0f);
            MemoryUtil.memPutInt((long)(l + 32L), (int)n4);
            MemoryUtil.memPutInt((long)(l + 32L - 40L), (int)n4);
            MemoryUtil.memPutInt((long)(l + 32L - 80L), (int)n4);
            MemoryUtil.memPutInt((long)(l + 32L - 120L), (int)n4);
            int n5 = NormalHelper.computeTangent(this.normal.x, this.normal.y, this.normal.z, this.quad);
            MemoryUtil.memPutInt((long)(l + 28L), (int)n5);
            MemoryUtil.memPutInt((long)(l + 28L - 40L), (int)n5);
            MemoryUtil.memPutInt((long)(l + 28L - 80L), (int)n5);
            MemoryUtil.memPutInt((long)(l + 28L - 120L), (int)n5);
        }
        this.advance();
    }

    @Override
    public void iris$setIdHolder(MaterialIdHolder materialIdHolder) {
        this.idHolder = materialIdHolder;
    }
}

