/*
 * Decompiled with CFR 0.152.
 */
package org.threadly.util.debug;

import java.util.Iterator;
import java.util.function.Function;
import org.threadly.concurrent.collections.ConcurrentArrayList;
import org.threadly.util.debug.Profiler;

public class ControlledThreadProfiler
extends Profiler {
    private static final short TRACKED_THREAD_BUFFER = 10;
    protected final ControlledThreadProfileStorage controledThreadStore;

    public ControlledThreadProfiler() {
        this(100, null);
    }

    public ControlledThreadProfiler(int pollIntervalInMs) {
        this(pollIntervalInMs, null);
    }

    public ControlledThreadProfiler(int pollIntervalInMs, Function<? super Profiler, String> startFutureResultSupplier) {
        super(new ControlledThreadProfileStorage(pollIntervalInMs), startFutureResultSupplier);
        this.controledThreadStore = (ControlledThreadProfileStorage)this.pStore;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addProfiledThread(Thread t) {
        if (t == null) {
            return;
        }
        Object object = this.controledThreadStore.profiledThreads.getModificationLock();
        synchronized (object) {
            SelectedThreadSample threadSample = new SelectedThreadSample(t);
            if (!this.controledThreadStore.profiledThreads.contains(threadSample)) {
                this.controledThreadStore.profiledThreads.add(threadSample);
            }
        }
    }

    public boolean removeProfiledThread(Thread t) {
        return this.controledThreadStore.profiledThreads.remove(new SelectedThreadSample(t));
    }

    public int getProfiledThreadCount() {
        return this.controledThreadStore.profiledThreads.size();
    }

    protected static class SelectedThreadSample
    implements Profiler.ThreadSample {
        private final Thread t;

        protected SelectedThreadSample(Thread t) {
            this.t = t;
        }

        @Override
        public Thread getThread() {
            return this.t;
        }

        @Override
        public StackTraceElement[] getStackTrace() {
            return this.t.getStackTrace();
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (o instanceof Profiler.ThreadSample) {
                return ((Profiler.ThreadSample)o).getThread() == this.t;
            }
            return false;
        }

        public int hashCode() {
            return this.t.hashCode();
        }
    }

    protected static class ControlledThreadProfileStorage
    extends Profiler.ProfileStorage {
        protected final ConcurrentArrayList<SelectedThreadSample> profiledThreads = new ConcurrentArrayList(0, 10);

        public ControlledThreadProfileStorage(int pollIntervalInMs) {
            super(pollIntervalInMs);
        }

        @Override
        protected Iterator<? extends Profiler.ThreadSample> getProfileThreadsIterator() {
            return this.profiledThreads.iterator();
        }
    }
}

