/*
 * Decompiled with CFR 0.152.
 */
package org.threadly.util;

import java.util.Optional;
import java.util.concurrent.ThreadLocalRandom;
import java.util.function.Predicate;

public class StringUtils {
    protected static final String RAND_CHARS = "0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ";

    public static boolean allCharsMatch(Predicate<Character> p, CharSequence s) {
        for (int i = 0; i < s.length(); ++i) {
            if (p.test(Character.valueOf(s.charAt(i)))) continue;
            return false;
        }
        return true;
    }

    public static boolean anyCharsMatch(Predicate<Character> p, CharSequence s) {
        for (int i = 0; i < s.length(); ++i) {
            if (!p.test(Character.valueOf(s.charAt(i)))) continue;
            return true;
        }
        return false;
    }

    public static String nullToEmpty(String input) {
        if (input != null) {
            return input;
        }
        return "";
    }

    public static String emptyToNull(String input) {
        if (input == null || input.isEmpty()) {
            return null;
        }
        return input;
    }

    public static boolean isNullOrEmpty(String input) {
        return input == null || input.isEmpty();
    }

    public static Optional<String> nonEmptyOptional(String input) {
        if (StringUtils.isNullOrEmpty(input)) {
            return Optional.empty();
        }
        return Optional.of(input);
    }

    public static String padStart(String sourceStr, int minLength, char padChar) {
        if ((sourceStr = StringUtils.nullToEmpty(sourceStr)).length() >= minLength) {
            return sourceStr;
        }
        StringBuilder sb = new StringBuilder(minLength);
        int padCount = minLength - sourceStr.length();
        while (sb.length() < padCount) {
            sb.append(padChar);
        }
        sb.append(sourceStr);
        return sb.toString();
    }

    public static String padEnd(String sourceStr, int minLength, char padChar) {
        if ((sourceStr = StringUtils.nullToEmpty(sourceStr)).length() >= minLength) {
            return sourceStr;
        }
        StringBuilder sb = new StringBuilder(minLength);
        sb.append(sourceStr);
        while (sb.length() < minLength) {
            sb.append(padChar);
        }
        return sb.toString();
    }

    public static String makeRandomString(int length) {
        StringBuilder sb = new StringBuilder(length);
        for (int i = 0; i < length; ++i) {
            char randChar = RAND_CHARS.charAt(ThreadLocalRandom.current().nextInt(RAND_CHARS.length()));
            sb.append(randChar);
        }
        return sb.toString();
    }
}

