/*
 * Decompiled with CFR 0.152.
 */
package org.threadly.util;

import java.util.concurrent.atomic.AtomicInteger;
import org.threadly.util.ExceptionUtils;
import org.threadly.util.Service;

public abstract class AbstractService
implements Service {
    private AtomicInteger state = new AtomicInteger(0);

    @Override
    public void start() throws IllegalStateException {
        if (!this.startIfNotStarted()) {
            throw new IllegalStateException();
        }
    }

    @Override
    public boolean startIfNotStarted() {
        if (this.state.getPlain() == 0 && this.state.compareAndSet(0, 1)) {
            this.startupService();
            return true;
        }
        return false;
    }

    protected abstract void startupService();

    @Override
    public void stop() {
        if (!this.stopIfRunning()) {
            throw new IllegalStateException();
        }
    }

    @Override
    public boolean stopIfRunning() {
        if (this.state.getPlain() == 1 && this.state.compareAndSet(1, 2)) {
            this.shutdownService();
            return true;
        }
        return false;
    }

    protected abstract void shutdownService();

    @Override
    public boolean isRunning() {
        return this.state.get() == 1;
    }

    @Override
    public boolean hasStopped() {
        return this.state.get() == 2;
    }

    protected void finalize() throws Throwable {
        if (this.isRunning()) {
            ExceptionUtils.handleException(new IllegalStateException(this.getClass() + " was not stopped before GC"));
        }
    }
}

