/*
 * Decompiled with CFR 0.152.
 */
package org.threadly.concurrent.wrapper.limiter;

import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import org.threadly.concurrent.AbstractSubmitterExecutor;
import org.threadly.concurrent.DoNothingRunnable;
import org.threadly.concurrent.PrioritySchedulerService;
import org.threadly.concurrent.ReschedulingOperation;
import org.threadly.concurrent.SubmitterExecutor;
import org.threadly.concurrent.SubmitterScheduler;
import org.threadly.concurrent.TaskPriority;
import org.threadly.concurrent.future.ImmediateResultListenableFuture;
import org.threadly.concurrent.future.ListenableFuture;
import org.threadly.concurrent.wrapper.limiter.RateLimiterExecutor;
import org.threadly.concurrent.wrapper.limiter.RejectedExecutionHandler;
import org.threadly.concurrent.wrapper.priority.DefaultPriorityWrapper;
import org.threadly.concurrent.wrapper.traceability.ThreadRenamingSubmitterScheduler;
import org.threadly.util.ArgumentVerifier;
import org.threadly.util.Clock;
import org.threadly.util.StringUtils;

public class KeyedRateLimiterExecutor {
    protected static final short LIMITER_IDLE_TIMEOUT = 2000;
    protected static final short CONCURRENT_HASH_MAP_INITIAL_SIZE = 16;
    protected final SubmitterScheduler scheduler;
    protected final RejectedExecutionHandler rejectedExecutionHandler;
    protected final SubmitterScheduler limiterCheckerScheduler;
    protected final double permitsPerSecond;
    protected final long maxScheduleDelayMillis;
    protected final String subPoolName;
    protected final boolean addKeyToThreadName;
    protected final ConcurrentHashMap<Object, RateLimiterExecutor> currentLimiters;
    protected final LimiterChecker limiterChecker;

    public KeyedRateLimiterExecutor(SubmitterScheduler scheduler, double permitsPerSecond) {
        this(scheduler, permitsPerSecond, Long.MAX_VALUE, null, "", false);
    }

    public KeyedRateLimiterExecutor(SubmitterScheduler scheduler, double permitsPerSecond, String subPoolName, boolean addKeyToThreadName) {
        this(scheduler, permitsPerSecond, Long.MAX_VALUE, null, subPoolName, addKeyToThreadName);
    }

    public KeyedRateLimiterExecutor(SubmitterScheduler scheduler, double permitsPerSecond, long maxScheduleDelayMillis) {
        this(scheduler, permitsPerSecond, maxScheduleDelayMillis, null, "", false);
    }

    public KeyedRateLimiterExecutor(SubmitterScheduler scheduler, double permitsPerSecond, long maxScheduleDelayMillis, RejectedExecutionHandler rejectedExecutionHandler) {
        this(scheduler, permitsPerSecond, maxScheduleDelayMillis, rejectedExecutionHandler, "", false);
    }

    public KeyedRateLimiterExecutor(SubmitterScheduler scheduler, double permitsPerSecond, long maxScheduleDelayMillis, String subPoolName, boolean addKeyToThreadName) {
        this(scheduler, permitsPerSecond, maxScheduleDelayMillis, null, subPoolName, addKeyToThreadName);
    }

    public KeyedRateLimiterExecutor(SubmitterScheduler scheduler, double permitsPerSecond, long maxScheduleDelayMillis, RejectedExecutionHandler rejectedExecutionHandler, String subPoolName, boolean addKeyToThreadName) {
        ArgumentVerifier.assertNotNull(scheduler, "scheduler");
        ArgumentVerifier.assertGreaterThanZero(permitsPerSecond, "permitsPerSecond");
        ArgumentVerifier.assertGreaterThanZero(maxScheduleDelayMillis, "maxScheduleDelayMillis");
        this.scheduler = scheduler;
        this.rejectedExecutionHandler = rejectedExecutionHandler;
        this.limiterCheckerScheduler = scheduler instanceof PrioritySchedulerService ? DefaultPriorityWrapper.ensurePriority((PrioritySchedulerService)scheduler, TaskPriority.Low) : scheduler;
        this.permitsPerSecond = permitsPerSecond;
        this.maxScheduleDelayMillis = maxScheduleDelayMillis;
        this.subPoolName = StringUtils.nullToEmpty(subPoolName);
        this.addKeyToThreadName = addKeyToThreadName;
        this.currentLimiters = new ConcurrentHashMap(16);
        this.limiterChecker = new LimiterChecker(scheduler, 1000L);
    }

    public int getTrackedKeyCount() {
        return this.currentLimiters.size();
    }

    public int getMinimumDelay(Object taskKey) {
        RateLimiterExecutor rle = this.currentLimiters.get(taskKey);
        if (rle == null) {
            return 0;
        }
        return rle.getMinimumDelay();
    }

    public ListenableFuture<?> getFutureTillDelay(Object taskKey, long maximumDelay) {
        int currentMinimumDelay = this.getMinimumDelay(taskKey);
        if (currentMinimumDelay == 0) {
            return ImmediateResultListenableFuture.NULL_RESULT;
        }
        long futureDelay = maximumDelay > 0L && (long)currentMinimumDelay > maximumDelay ? maximumDelay : (long)currentMinimumDelay;
        return this.scheduler.submitScheduled(DoNothingRunnable.instance(), futureDelay);
    }

    public void execute(Object taskKey, Runnable task) {
        this.execute(1.0, taskKey, task);
    }

    public long execute(double permits, Object taskKey, Runnable task) {
        return this.limiterForKey(taskKey, l -> l.execute(permits, task));
    }

    public ListenableFuture<?> submit(Object taskKey, Runnable task) {
        return this.submit(1.0, taskKey, task, null);
    }

    public ListenableFuture<?> submit(double permits, Object taskKey, Runnable task) {
        return this.submit(permits, taskKey, task, null);
    }

    public <T> ListenableFuture<T> submit(Object taskKey, Runnable task, T result) {
        return this.submit(1.0, taskKey, task, result);
    }

    public <T> ListenableFuture<T> submit(double permits, Object taskKey, Runnable task, T result) {
        return this.limiterForKey(taskKey, l -> l.submit(permits, task, result));
    }

    public <T> ListenableFuture<T> submit(Object taskKey, Callable<T> task) {
        return this.submit(1.0, taskKey, task);
    }

    public <T> ListenableFuture<T> submit(double permits, Object taskKey, Callable<T> task) {
        return this.limiterForKey(taskKey, l -> l.submit(permits, task));
    }

    protected <T> T limiterForKey(Object taskKey, Function<RateLimiterExecutor, ? extends T> c) {
        ArgumentVerifier.assertNotNull(taskKey, "taskKey");
        Object[] capture = new Object[1];
        this.currentLimiters.compute(taskKey, (k, v) -> {
            if (v == null) {
                String keyedPoolName = this.subPoolName + (this.addKeyToThreadName ? taskKey.toString() : "");
                SubmitterScheduler threadNamedScheduler = StringUtils.isNullOrEmpty(keyedPoolName) ? this.scheduler : new ThreadRenamingSubmitterScheduler(this.scheduler, keyedPoolName, false);
                v = new RateLimiterExecutor(threadNamedScheduler, this.permitsPerSecond, this.maxScheduleDelayMillis, this.rejectedExecutionHandler);
                this.limiterChecker.signalToRun();
            }
            capture[0] = c.apply((RateLimiterExecutor)v);
            return v;
        });
        return (T)capture[0];
    }

    public SubmitterExecutor getSubmitterExecutorForKey(Object taskKey) {
        return this.getSubmitterExecutorForKey(1.0, taskKey);
    }

    public SubmitterExecutor getSubmitterExecutorForKey(double permits, Object taskKey) {
        ArgumentVerifier.assertNotNegative(permits, "permits");
        ArgumentVerifier.assertNotNull(taskKey, "taskKey");
        return new KeyedSubmitterExecutor(permits, taskKey);
    }

    protected class LimiterChecker
    extends ReschedulingOperation {
        protected LimiterChecker(SubmitterScheduler scheduler, long scheduleDelay) {
            super(scheduler, scheduleDelay);
        }

        @Override
        public void run() {
            Iterator<Map.Entry<Object, RateLimiterExecutor>> it = KeyedRateLimiterExecutor.this.currentLimiters.entrySet().iterator();
            long now = Clock.lastKnownForwardProgressingMillis();
            while (it.hasNext()) {
                Map.Entry<Object, RateLimiterExecutor> e = it.next();
                if (now - e.getValue().getLastScheduleTime() <= 2000L) continue;
                KeyedRateLimiterExecutor.this.currentLimiters.computeIfPresent(e.getKey(), (k, v) -> {
                    if (now - v.getLastScheduleTime() > 2000L) {
                        return null;
                    }
                    return v;
                });
            }
            if (!KeyedRateLimiterExecutor.this.currentLimiters.isEmpty()) {
                this.signalToRun();
            }
        }
    }

    protected class KeyedSubmitterExecutor
    extends AbstractSubmitterExecutor {
        protected final double permits;
        protected final Object taskKey;

        protected KeyedSubmitterExecutor(double permits, Object taskKey) {
            this.permits = permits;
            this.taskKey = taskKey;
        }

        @Override
        protected void doExecute(Runnable task) {
            KeyedRateLimiterExecutor.this.limiterForKey(this.taskKey, l -> l.execute(this.permits, task));
        }
    }
}

