/*
 * Decompiled with CFR 0.152.
 */
package org.threadly.concurrent.wrapper.limiter;

import java.util.concurrent.Callable;
import org.threadly.concurrent.AbstractSubmitterScheduler;
import org.threadly.concurrent.RunnableCallableAdapter;
import org.threadly.concurrent.SubmitterScheduler;
import org.threadly.concurrent.future.ListenableFuture;
import org.threadly.concurrent.future.ListenableFutureTask;
import org.threadly.concurrent.wrapper.limiter.AbstractKeyedLimiter;
import org.threadly.concurrent.wrapper.limiter.SubmitterSchedulerLimiter;
import org.threadly.util.ArgumentVerifier;

abstract class AbstractKeyedSchedulerLimiter<T extends SubmitterSchedulerLimiter>
extends AbstractKeyedLimiter<T> {
    protected final SubmitterScheduler scheduler;

    protected AbstractKeyedSchedulerLimiter(SubmitterScheduler scheduler, int maxConcurrency, String subPoolName, boolean addKeyToThreadName, boolean limitFutureListenersExecution) {
        super(scheduler, maxConcurrency, subPoolName, addKeyToThreadName, limitFutureListenersExecution);
        this.scheduler = scheduler;
    }

    public ListenableFuture<?> submitScheduled(Object taskKey, Runnable task, long delayInMs) {
        return this.submitScheduled(taskKey, task, null, delayInMs);
    }

    public <TT> ListenableFuture<TT> submitScheduled(Object taskKey, Runnable task, TT result, long delayInMs) {
        return this.submitScheduled(taskKey, RunnableCallableAdapter.adapt(task, result), delayInMs);
    }

    public <TT> ListenableFuture<TT> submitScheduled(Object taskKey, Callable<TT> task, long delayInMs) {
        ArgumentVerifier.assertNotNull(task, "task");
        ListenableFutureTask<TT> ft = new ListenableFutureTask<TT>(task);
        this.doSchedule(taskKey, ft, ft, delayInMs);
        return ft;
    }

    public void schedule(Object taskKey, Runnable task, long delayInMs) {
        ArgumentVerifier.assertNotNull(taskKey, "taskKey");
        this.doSchedule(taskKey, task, null, delayInMs);
    }

    protected void doSchedule(Object taskKey, Runnable task, ListenableFuture<?> lf, long delayInMs) {
        AbstractKeyedLimiter.LimiterContainer lc = this.getLimiterContainer(taskKey);
        ((SubmitterSchedulerLimiter)lc.limiter).doSchedule(lc.wrap(task), lf, delayInMs);
    }

    public void scheduleWithFixedDelay(Object taskKey, Runnable task, long initialDelay, long recurringDelay) {
        ArgumentVerifier.assertNotNull(taskKey, "taskKey");
        AbstractKeyedLimiter.LimiterContainer lc = this.getLimiterContainer(taskKey);
        ((SubmitterSchedulerLimiter)lc.limiter).scheduleWithFixedDelay(task, initialDelay, recurringDelay);
    }

    public void scheduleAtFixedRate(Object taskKey, Runnable task, long initialDelay, long period) {
        ArgumentVerifier.assertNotNull(taskKey, "taskKey");
        AbstractKeyedLimiter.LimiterContainer lc = this.getLimiterContainer(taskKey);
        ((SubmitterSchedulerLimiter)lc.limiter).scheduleAtFixedRate(task, initialDelay, period);
    }

    public SubmitterScheduler getSubmitterSchedulerForKey(Object taskKey) {
        ArgumentVerifier.assertNotNull(taskKey, "taskKey");
        return new KeyedSubmitterScheduler(taskKey);
    }

    protected class KeyedSubmitterScheduler
    extends AbstractSubmitterScheduler {
        protected final Object taskKey;

        protected KeyedSubmitterScheduler(Object taskKey) {
            this.taskKey = taskKey;
        }

        @Override
        public void scheduleWithFixedDelay(Runnable task, long initialDelay, long recurringDelay) {
            AbstractKeyedSchedulerLimiter.this.scheduleWithFixedDelay(this.taskKey, task, initialDelay, recurringDelay);
        }

        @Override
        public void scheduleAtFixedRate(Runnable task, long initialDelay, long period) {
            AbstractKeyedSchedulerLimiter.this.scheduleAtFixedRate(this.taskKey, task, initialDelay, period);
        }

        @Override
        protected void doSchedule(Runnable task, long delayInMs) {
            AbstractKeyedSchedulerLimiter.this.schedule(this.taskKey, task, delayInMs);
        }
    }
}

