/*
 * Decompiled with CFR 0.152.
 */
package org.threadly.concurrent.wrapper.interceptor;

import java.util.concurrent.Callable;
import java.util.function.BiFunction;
import org.threadly.concurrent.SubmitterScheduler;
import org.threadly.concurrent.future.ListenableFuture;
import org.threadly.concurrent.future.ListenableFutureTask;
import org.threadly.concurrent.wrapper.interceptor.ExecutorTaskInterceptor;
import org.threadly.util.ArgumentVerifier;

public class SubmitterSchedulerTaskInterceptor
extends ExecutorTaskInterceptor
implements SubmitterScheduler {
    protected final SubmitterScheduler parentScheduler;
    protected final BiFunction<Runnable, Boolean, Runnable> taskManipulator;

    protected SubmitterSchedulerTaskInterceptor(SubmitterScheduler parentScheduler) {
        this(parentScheduler, (Runnable r, Boolean s) -> {
            throw new RuntimeException("Must override wrapTask(Runnable, Boolean)");
        });
    }

    public SubmitterSchedulerTaskInterceptor(SubmitterScheduler parentScheduler, BiFunction<Runnable, Boolean, Runnable> taskManipulator) {
        super(parentScheduler);
        ArgumentVerifier.assertNotNull(taskManipulator, "taskManipulator");
        this.parentScheduler = parentScheduler;
        this.taskManipulator = taskManipulator;
    }

    @Override
    public final Runnable wrapTask(Runnable task) {
        return this.wrapTask(task, false);
    }

    public Runnable wrapTask(Runnable task, boolean recurring) {
        return this.taskManipulator.apply(task, recurring);
    }

    @Override
    public void schedule(Runnable task, long delayInMs) {
        this.parentScheduler.schedule(task == null ? null : this.wrapTask(task, false), delayInMs);
    }

    @Override
    public <T> ListenableFuture<T> submitScheduled(Runnable task, T result, long delayInMs) {
        return this.parentScheduler.submitScheduled(task == null ? null : this.wrapTask(task, false), result, delayInMs);
    }

    @Override
    public <T> ListenableFuture<T> submitScheduled(Callable<T> task, long delayInMs) {
        ArgumentVerifier.assertNotNull(task, "task");
        ListenableFutureTask<T> lft = new ListenableFutureTask<T>(task, this);
        this.parentScheduler.schedule(this.wrapTask(lft, false), delayInMs);
        return lft;
    }

    @Override
    public void scheduleWithFixedDelay(Runnable task, long initialDelay, long recurringDelay) {
        this.parentScheduler.scheduleWithFixedDelay(task == null ? null : this.wrapTask(task, true), initialDelay, recurringDelay);
    }

    @Override
    public void scheduleAtFixedRate(Runnable task, long initialDelay, long period) {
        this.parentScheduler.scheduleAtFixedRate(task == null ? null : this.wrapTask(task, true), initialDelay, period);
    }
}

