/*
 * Decompiled with CFR 0.152.
 */
package org.threadly.concurrent.wrapper.interceptor;

import java.util.concurrent.Callable;
import java.util.function.BiFunction;
import org.threadly.concurrent.PrioritySchedulerService;
import org.threadly.concurrent.TaskPriority;
import org.threadly.concurrent.future.ListenableFuture;
import org.threadly.concurrent.future.ListenableFutureTask;
import org.threadly.concurrent.wrapper.interceptor.SchedulerServiceTaskInterceptor;
import org.threadly.util.ArgumentVerifier;

public class PrioritySchedulerTaskInterceptor
extends SchedulerServiceTaskInterceptor
implements PrioritySchedulerService {
    protected final PrioritySchedulerService parentScheduler;

    protected PrioritySchedulerTaskInterceptor(PrioritySchedulerService parentScheduler) {
        this(parentScheduler, (Runnable r, Boolean s) -> {
            throw new RuntimeException("Must override wrapTask(Runnable, Boolean)");
        });
    }

    public PrioritySchedulerTaskInterceptor(PrioritySchedulerService parentScheduler, BiFunction<Runnable, Boolean, Runnable> taskManipulator) {
        super(parentScheduler, taskManipulator);
        this.parentScheduler = parentScheduler;
    }

    @Override
    public void execute(Runnable task, TaskPriority priority) {
        this.parentScheduler.execute(task == null ? null : this.wrapTask(task, false), priority);
    }

    @Override
    public <T> ListenableFuture<T> submit(Runnable task, T result, TaskPriority priority) {
        return this.parentScheduler.submit(task == null ? null : this.wrapTask(task, false), result, priority);
    }

    @Override
    public <T> ListenableFuture<T> submit(Callable<T> task, TaskPriority priority) {
        ArgumentVerifier.assertNotNull(task, "task");
        ListenableFutureTask<T> lft = new ListenableFutureTask<T>(task, this);
        this.parentScheduler.execute(this.wrapTask(lft, false), priority);
        return lft;
    }

    @Override
    public void schedule(Runnable task, long delayInMs, TaskPriority priority) {
        this.parentScheduler.schedule(task == null ? null : this.wrapTask(task, false), delayInMs, priority);
    }

    @Override
    public <T> ListenableFuture<T> submitScheduled(Runnable task, T result, long delayInMs, TaskPriority priority) {
        return this.parentScheduler.submitScheduled(task == null ? null : this.wrapTask(task, false), result, delayInMs, priority);
    }

    @Override
    public <T> ListenableFuture<T> submitScheduled(Callable<T> task, long delayInMs, TaskPriority priority) {
        ArgumentVerifier.assertNotNull(task, "task");
        ListenableFutureTask<T> lft = new ListenableFutureTask<T>(task, this);
        this.parentScheduler.schedule(this.wrapTask(lft, false), delayInMs, priority);
        return lft;
    }

    @Override
    public void scheduleWithFixedDelay(Runnable task, long initialDelay, long recurringDelay, TaskPriority priority) {
        this.parentScheduler.scheduleWithFixedDelay(task == null ? null : this.wrapTask(task, true), initialDelay, recurringDelay, priority);
    }

    @Override
    public void scheduleAtFixedRate(Runnable task, long initialDelay, long period, TaskPriority priority) {
        this.parentScheduler.scheduleAtFixedRate(task == null ? null : this.wrapTask(task, true), initialDelay, period, priority);
    }

    @Override
    public TaskPriority getDefaultPriority() {
        return this.parentScheduler.getDefaultPriority();
    }

    @Override
    public long getMaxWaitForLowPriority() {
        return this.parentScheduler.getMaxWaitForLowPriority();
    }

    @Override
    public int getQueuedTaskCount(TaskPriority priority) {
        return this.parentScheduler.getQueuedTaskCount(priority);
    }

    @Override
    public int getWaitingForExecutionTaskCount(TaskPriority priority) {
        return this.parentScheduler.getWaitingForExecutionTaskCount(priority);
    }
}

