/*
 * Decompiled with CFR 0.152.
 */
package org.threadly.concurrent.wrapper.compatibility;

import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.Delayed;
import java.util.concurrent.TimeUnit;
import org.threadly.concurrent.PriorityScheduler;
import org.threadly.concurrent.TaskPriority;
import org.threadly.concurrent.ThreadlyInternalAccessor;
import org.threadly.concurrent.future.ListenableFutureTask;
import org.threadly.concurrent.wrapper.compatibility.AbstractExecutorServiceWrapper;
import org.threadly.concurrent.wrapper.compatibility.ListenableScheduledFuture;
import org.threadly.concurrent.wrapper.priority.DefaultPriorityWrapper;

public class PrioritySchedulerServiceWrapper
extends AbstractExecutorServiceWrapper {
    protected final PriorityScheduler pScheduler;
    protected final TaskPriority taskPriority;

    public PrioritySchedulerServiceWrapper(PriorityScheduler scheduler) {
        this(scheduler, null);
    }

    public PrioritySchedulerServiceWrapper(PriorityScheduler scheduler, TaskPriority taskPriority) {
        super(DefaultPriorityWrapper.ensurePriority(scheduler, taskPriority));
        this.pScheduler = scheduler;
        this.taskPriority = taskPriority == null ? scheduler.getDefaultPriority() : taskPriority;
    }

    @Override
    public void shutdown() {
        this.pScheduler.shutdown();
    }

    @Override
    public List<Runnable> shutdownNow() {
        return this.pScheduler.shutdownNow();
    }

    @Override
    public boolean isTerminated() {
        return this.scheduler.isShutdown() && this.pScheduler.getCurrentPoolSize() == 0;
    }

    @Override
    public boolean awaitTermination(long timeout, TimeUnit unit) throws InterruptedException {
        return this.pScheduler.awaitTermination(unit.toMillis(timeout));
    }

    @Override
    protected ListenableScheduledFuture<?> schedule(Runnable task, long delayInMillis) {
        ListenableFutureTask<Object> taskFuture = new ListenableFutureTask<Object>(task, null, this.pScheduler);
        Delayed d = ThreadlyInternalAccessor.doScheduleAndGetDelayed(this.pScheduler, taskFuture, this.taskPriority, delayInMillis);
        return new AbstractExecutorServiceWrapper.ScheduledFutureDelegate<Object>(taskFuture, d);
    }

    @Override
    protected <V> ListenableScheduledFuture<V> schedule(Callable<V> callable, long delayInMillis) {
        ListenableFutureTask<V> taskFuture = new ListenableFutureTask<V>(callable, this.pScheduler);
        Delayed d = ThreadlyInternalAccessor.doScheduleAndGetDelayed(this.pScheduler, taskFuture, this.taskPriority, delayInMillis);
        return new AbstractExecutorServiceWrapper.ScheduledFutureDelegate<V>(taskFuture, d);
    }

    @Override
    protected ListenableScheduledFuture<?> scheduleWithFixedDelay(Runnable task, long initialDelay, long delayInMs) {
        task = new AbstractExecutorServiceWrapper.ThrowableHandlingRecurringRunnable(this.scheduler, task);
        AbstractExecutorServiceWrapper.CancelRemovingListenableFutureTask lft = new AbstractExecutorServiceWrapper.CancelRemovingListenableFutureTask(this.scheduler, true, task, this.pScheduler);
        Delayed d = ThreadlyInternalAccessor.doScheduleWithFixedDelayAndGetDelayed(this.pScheduler, lft, this.taskPriority, initialDelay, delayInMs);
        return new AbstractExecutorServiceWrapper.ScheduledFutureDelegate(lft, d);
    }

    @Override
    protected ListenableScheduledFuture<?> scheduleAtFixedRate(Runnable task, long initialDelay, long periodInMillis) {
        task = new AbstractExecutorServiceWrapper.ThrowableHandlingRecurringRunnable(this.pScheduler, task);
        AbstractExecutorServiceWrapper.CancelRemovingListenableFutureTask lft = new AbstractExecutorServiceWrapper.CancelRemovingListenableFutureTask(this.scheduler, true, task, this.pScheduler);
        Delayed d = ThreadlyInternalAccessor.doScheduleAtFixedRateAndGetDelayed(this.pScheduler, lft, this.taskPriority, initialDelay, periodInMillis);
        return new AbstractExecutorServiceWrapper.ScheduledFutureDelegate(lft, d);
    }
}

