/*
 * Decompiled with CFR 0.152.
 */
package org.threadly.concurrent.wrapper;

import java.util.concurrent.Callable;
import org.threadly.concurrent.RunnableCallableAdapter;
import org.threadly.concurrent.RunnableContainer;
import org.threadly.concurrent.SameThreadSubmitterExecutor;
import org.threadly.concurrent.SubmitterScheduler;
import org.threadly.concurrent.future.ListenableFuture;
import org.threadly.concurrent.future.ListenableFutureTask;
import org.threadly.concurrent.wrapper.KeyDistributedExecutor;
import org.threadly.util.ArgumentVerifier;

public class KeyDistributedScheduler
extends KeyDistributedExecutor {
    protected final SubmitterScheduler scheduler;

    public KeyDistributedScheduler(SubmitterScheduler scheduler) {
        this(scheduler, Integer.MAX_VALUE, false);
    }

    public KeyDistributedScheduler(SubmitterScheduler scheduler, boolean accurateQueueSize) {
        this(scheduler, Integer.MAX_VALUE, accurateQueueSize);
    }

    public KeyDistributedScheduler(SubmitterScheduler scheduler, int maxTasksPerCycle) {
        this(scheduler, maxTasksPerCycle, false);
    }

    public KeyDistributedScheduler(SubmitterScheduler scheduler, int maxTasksPerCycle, boolean accurateQueueSize) {
        super(scheduler, maxTasksPerCycle, accurateQueueSize);
        this.scheduler = scheduler;
    }

    public SubmitterScheduler getSchedulerForKey(Object threadKey) {
        ArgumentVerifier.assertNotNull(threadKey, "threadKey");
        return new KeyScheduler(threadKey);
    }

    public void schedule(Object threadKey, Runnable task, long delayInMs) {
        ArgumentVerifier.assertNotNull(threadKey, "threadKey");
        ArgumentVerifier.assertNotNull(task, "task");
        ArgumentVerifier.assertNotNegative(delayInMs, "delayInMs");
        if (delayInMs == 0L) {
            this.addTask(threadKey, task, this.executor);
        } else {
            this.scheduler.schedule(new AddTask(threadKey, task), delayInMs);
        }
    }

    public ListenableFuture<?> submitScheduled(Object threadKey, Runnable task, long delayInMs) {
        return this.submitScheduled(threadKey, task, null, delayInMs);
    }

    public <T> ListenableFuture<T> submitScheduled(Object threadKey, Runnable task, T result, long delayInMs) {
        return this.submitScheduled(threadKey, RunnableCallableAdapter.adapt(task, result), delayInMs);
    }

    public <T> ListenableFuture<T> submitScheduled(Object threadKey, Callable<T> task, long delayInMs) {
        ArgumentVerifier.assertNotNull(threadKey, "threadKey");
        ArgumentVerifier.assertNotNull(task, "task");
        ArgumentVerifier.assertNotNegative(delayInMs, "delayInMs");
        ListenableFutureTask<T> rf = new ListenableFutureTask<T>(task);
        if (delayInMs == 0L) {
            this.addTask(threadKey, rf, this.executor);
        } else {
            this.scheduler.schedule(new AddTask(threadKey, rf), delayInMs);
        }
        return rf;
    }

    public void scheduleTaskWithFixedDelay(Object threadKey, Runnable task, long initialDelay, long recurringDelay) {
        ArgumentVerifier.assertNotNull(threadKey, "threadKey");
        ArgumentVerifier.assertNotNull(task, "task");
        ArgumentVerifier.assertNotNegative(initialDelay, "initialDelay");
        ArgumentVerifier.assertNotNegative(recurringDelay, "recurringDelay");
        RecrringDelayTask rdt = new RecrringDelayTask(threadKey, task, recurringDelay);
        if (initialDelay == 0L) {
            this.addTask(threadKey, rdt, this.executor);
        } else {
            this.scheduler.schedule(rdt.addTask, initialDelay);
        }
    }

    public void scheduleTaskAtFixedRate(Object threadKey, Runnable task, long initialDelay, long period) {
        ArgumentVerifier.assertNotNull(threadKey, "threadKey");
        ArgumentVerifier.assertNotNull(task, "task");
        ArgumentVerifier.assertNotNegative(initialDelay, "initialDelay");
        ArgumentVerifier.assertGreaterThanZero(period, "period");
        RecrringRateTask rrt = new RecrringRateTask(threadKey, task, period);
        if (initialDelay == 0L) {
            this.addTask(threadKey, rrt, this.executor);
        } else {
            this.scheduler.schedule(rrt.addTask, initialDelay);
        }
    }

    protected class KeyScheduler
    extends KeyDistributedExecutor.KeySubmitter
    implements SubmitterScheduler {
        protected KeyScheduler(Object threadKey) {
            super(KeyDistributedScheduler.this, threadKey);
        }

        @Override
        public void schedule(Runnable task, long delayInMs) {
            KeyDistributedScheduler.this.schedule(this.threadKey, task, delayInMs);
        }

        @Override
        public ListenableFuture<?> submitScheduled(Runnable task, long delayInMs) {
            return this.submitScheduled(task, null, delayInMs);
        }

        @Override
        public <T> ListenableFuture<T> submitScheduled(Runnable task, T result, long delayInMs) {
            return KeyDistributedScheduler.this.submitScheduled(this.threadKey, task, result, delayInMs);
        }

        @Override
        public <T> ListenableFuture<T> submitScheduled(Callable<T> task, long delayInMs) {
            return KeyDistributedScheduler.this.submitScheduled(this.threadKey, task, delayInMs);
        }

        @Override
        public void scheduleWithFixedDelay(Runnable task, long initialDelay, long recurringDelay) {
            KeyDistributedScheduler.this.scheduleTaskWithFixedDelay(this.threadKey, task, initialDelay, recurringDelay);
        }

        @Override
        public void scheduleAtFixedRate(Runnable task, long initialDelay, long period) {
            KeyDistributedScheduler.this.scheduleTaskAtFixedRate(this.threadKey, task, initialDelay, period);
        }
    }

    protected class RecrringRateTask
    implements Runnable,
    RunnableContainer {
        protected final AddTask addTask;
        protected final Runnable task;
        protected final long recurringPeriod;

        protected RecrringRateTask(Object key, Runnable task, long recurringPeriod) {
            this.addTask = new AddTask(key, this);
            this.task = task;
            this.recurringPeriod = recurringPeriod;
        }

        @Override
        public void run() {
            KeyDistributedScheduler.this.scheduler.schedule(this.addTask, this.recurringPeriod);
            this.task.run();
        }

        @Override
        public Runnable getContainedRunnable() {
            return this.task;
        }
    }

    protected class RecrringDelayTask
    implements Runnable,
    RunnableContainer {
        protected final AddTask addTask;
        protected final Runnable task;
        protected final long recurringDelay;

        protected RecrringDelayTask(Object key, Runnable task, long recurringDelay) {
            this.addTask = new AddTask(key, this);
            this.task = task;
            this.recurringDelay = recurringDelay;
        }

        @Override
        public void run() {
            try {
                this.task.run();
            }
            finally {
                KeyDistributedScheduler.this.scheduler.schedule(this.addTask, this.recurringDelay);
            }
        }

        @Override
        public Runnable getContainedRunnable() {
            return this.task;
        }
    }

    protected class AddTask
    implements Runnable,
    RunnableContainer {
        protected final Object key;
        protected final Runnable task;

        protected AddTask(Object key, Runnable task) {
            this.key = key;
            this.task = task;
        }

        @Override
        public void run() {
            KeyDistributedScheduler.this.addTask(this.key, this.task, SameThreadSubmitterExecutor.instance());
        }

        @Override
        public Runnable getContainedRunnable() {
            return this.task;
        }
    }
}

