/*
 * Decompiled with CFR 0.152.
 */
package org.threadly.concurrent.future.watchdog;

import java.util.Collection;
import java.util.Iterator;
import java.util.function.Supplier;
import org.threadly.concurrent.ReschedulingOperation;
import org.threadly.concurrent.SubmitterScheduler;
import org.threadly.concurrent.future.ListenableFuture;
import org.threadly.concurrent.future.watchdog.AbstractWatchdog;
import org.threadly.util.ArgumentVerifier;
import org.threadly.util.ExceptionUtils;

public class PollingWatchdog
extends AbstractWatchdog {
    public PollingWatchdog(long pollFrequencyMillis, boolean sendInterruptOnFutureCancel) {
        this(PollingWatchdog.getStaticScheduler(), pollFrequencyMillis, sendInterruptOnFutureCancel);
    }

    public PollingWatchdog(SubmitterScheduler scheduler, long pollFrequencyMillis, boolean sendInterruptOnFutureCancel) {
        super(futures -> new CheckRunner(scheduler, pollFrequencyMillis, sendInterruptOnFutureCancel, (Collection<PollingFutureWrapper>)futures));
        ArgumentVerifier.assertGreaterThanZero(pollFrequencyMillis, "pollFrequencyMillis");
    }

    public void watch(Supplier<Boolean> cancelTest, ListenableFuture<?> future) {
        if (future == null || future.isDone()) {
            return;
        }
        this.watchWrapper(new PollingFutureWrapper(cancelTest, future), future);
    }

    protected static class CheckRunner
    extends ReschedulingOperation {
        protected final boolean sendInterruptToTrackedThreads;
        protected final Collection<PollingFutureWrapper> futures;

        public CheckRunner(SubmitterScheduler scheduler, long scheduleDelay, boolean sendInterruptToTrackedThreads, Collection<PollingFutureWrapper> futures) {
            super(scheduler, scheduleDelay);
            this.sendInterruptToTrackedThreads = sendInterruptToTrackedThreads;
            this.futures = futures;
        }

        @Override
        protected void run() {
            PollingFutureWrapper fw = null;
            Iterator<PollingFutureWrapper> it = this.futures.iterator();
            while (it.hasNext()) {
                try {
                    fw = it.next();
                    if (!fw.future.isDone() && !fw.cancelTest.get().booleanValue()) continue;
                    it.remove();
                    fw.future.cancel(this.sendInterruptToTrackedThreads);
                }
                catch (Throwable t) {
                    ExceptionUtils.handleException(t);
                }
            }
            if (!this.futures.isEmpty()) {
                this.signalToRun();
            }
        }
    }

    protected class PollingFutureWrapper {
        protected final Supplier<Boolean> cancelTest;
        protected final ListenableFuture<?> future;

        public PollingFutureWrapper(Supplier<Boolean> cancelTest, ListenableFuture<?> future) {
            this.cancelTest = cancelTest;
            this.future = future;
        }
    }
}

