/*
 * Decompiled with CFR 0.152.
 */
package org.threadly.concurrent.future;

import java.util.concurrent.CancellationException;
import java.util.concurrent.Executor;
import org.threadly.concurrent.future.AbstractCompletableListenableFuture;
import org.threadly.concurrent.future.FutureCallback;
import org.threadly.concurrent.future.ListenableFuture;

public class SettableListenableFuture<T>
extends AbstractCompletableListenableFuture<T>
implements ListenableFuture<T>,
FutureCallback<T> {
    protected final boolean throwIfAlreadyComplete;
    private volatile String cancelStateMessage;

    public SettableListenableFuture() {
        this(true);
    }

    public SettableListenableFuture(boolean throwIfAlreadyComplete) {
        this(throwIfAlreadyComplete, null);
    }

    protected SettableListenableFuture(boolean throwIfAlreadyComplete, Executor executingExecutor) {
        super(executingExecutor);
        this.throwIfAlreadyComplete = throwIfAlreadyComplete;
        this.cancelStateMessage = null;
    }

    @Override
    public void handleResult(T result) {
        if (!this.completeWithResult(result) && this.throwIfAlreadyComplete) {
            throw new IllegalStateException("Future already done");
        }
    }

    @Override
    public void handleFailure(Throwable t) {
        if (this.isDone()) {
            return;
        }
        if (t instanceof CancellationException) {
            if (this.cancelStateMessage == null) {
                this.cancelStateMessage = t.getMessage();
                boolean interrupt = Thread.currentThread().isInterrupted();
                if (!this.cancel(interrupt)) {
                    super.cancel(interrupt);
                }
            }
        } else if (!this.completeWithFailure(t) && this.throwIfAlreadyComplete) {
            throw new IllegalStateException("Future already done", t);
        }
    }

    public boolean setResult(T result) {
        boolean set = this.completeWithResult(result);
        if (this.throwIfAlreadyComplete && !set) {
            throw new IllegalStateException("Future already done");
        }
        return set;
    }

    public boolean setFailure(Throwable failure) {
        boolean set = this.completeWithFailure(failure);
        if (this.throwIfAlreadyComplete && !set) {
            throw new IllegalStateException("Future already done", failure);
        }
        return set;
    }

    public void setRunningThread(Thread thread) {
        if (!this.isDone()) {
            this.execThread = thread;
        }
    }

    @Override
    protected String getCancellationExceptionMessage() {
        return this.cancelStateMessage;
    }

    @Override
    protected void handleCompleteState() {
        this.execThread = null;
    }
}

