/*
 * Decompiled with CFR 0.152.
 */
package org.threadly.concurrent.future;

import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.function.Function;
import org.threadly.concurrent.future.AbstractCompletedListenableFuture;
import org.threadly.concurrent.future.FutureCallback;
import org.threadly.concurrent.future.InternalFutureUtils;
import org.threadly.concurrent.future.ListenableFuture;

public class ImmediateResultListenableFuture<T>
extends AbstractCompletedListenableFuture<T> {
    public static final ImmediateResultListenableFuture<?> NULL_RESULT = new ImmediateResultListenableFuture<Object>(null);
    public static final ImmediateResultListenableFuture<Boolean> BOOLEAN_TRUE_RESULT = new ImmediateResultListenableFuture<Boolean>(Boolean.TRUE);
    public static final ImmediateResultListenableFuture<Boolean> BOOLEAN_FALSE_RESULT = new ImmediateResultListenableFuture<Boolean>(Boolean.FALSE);
    public static final ImmediateResultListenableFuture<String> EMPTY_STRING_RESULT = new ImmediateResultListenableFuture<String>("");
    public static final ImmediateResultListenableFuture<? extends Optional<?>> EMPTY_OPTIONAL_RESULT = new ImmediateResultListenableFuture(Optional.empty());
    public static final ImmediateResultListenableFuture<? extends List<?>> EMPTY_LIST_RESULT = new ImmediateResultListenableFuture(Collections.emptyList());
    public static final ImmediateResultListenableFuture<? extends Map<?, ?>> EMPTY_MAP_RESULT = new ImmediateResultListenableFuture(Collections.emptyMap());
    public static final ImmediateResultListenableFuture<? extends SortedMap<?, ?>> EMPTY_SORTED_MAP_RESULT = new ImmediateResultListenableFuture(Collections.emptySortedMap());
    public static final ImmediateResultListenableFuture<? extends Set<?>> EMPTY_SET_RESULT = new ImmediateResultListenableFuture(Collections.emptySet());
    public static final ImmediateResultListenableFuture<? extends SortedSet<?>> EMPTY_SORTED_SET_RESULT = new ImmediateResultListenableFuture(Collections.emptySortedSet());
    public static final ImmediateResultListenableFuture<? extends Iterator<?>> EMPTY_ITERATOR_RESULT = new ImmediateResultListenableFuture(Collections.emptyIterator());
    public static final ImmediateResultListenableFuture<? extends ListIterator<?>> EMPTY_LIST_ITERATOR_RESULT = new ImmediateResultListenableFuture(Collections.emptyListIterator());
    public static final ImmediateResultListenableFuture<? extends Enumeration<?>> EMPTY_ENUMERATION_RESULT = new ImmediateResultListenableFuture(Collections.emptyEnumeration());
    protected final T result;

    public ImmediateResultListenableFuture(T result) {
        this.result = result;
    }

    @Override
    public boolean isCompletedExceptionally() {
        return false;
    }

    @Override
    public <TT extends Throwable> ListenableFuture<T> mapFailure(Class<TT> throwableType, Function<? super TT, ? extends T> mapper) {
        return this;
    }

    @Override
    public <TT extends Throwable> ListenableFuture<T> mapFailure(Class<TT> throwableType, Function<? super TT, ? extends T> mapper, Executor executor) {
        return this;
    }

    @Override
    public <TT extends Throwable> ListenableFuture<T> mapFailure(Class<TT> throwableType, Function<? super TT, ? extends T> mapper, Executor executor, ListenableFuture.ListenerOptimizationStrategy optimizeExecution) {
        return this;
    }

    @Override
    public <TT extends Throwable> ListenableFuture<T> flatMapFailure(Class<TT> throwableType, Function<? super TT, ListenableFuture<T>> mapper) {
        return this;
    }

    @Override
    public <TT extends Throwable> ListenableFuture<T> flatMapFailure(Class<TT> throwableType, Function<? super TT, ListenableFuture<T>> mapper, Executor executor) {
        return this;
    }

    @Override
    public <TT extends Throwable> ListenableFuture<T> flatMapFailure(Class<TT> throwableType, Function<? super TT, ListenableFuture<T>> mapper, Executor executor, ListenableFuture.ListenerOptimizationStrategy optimizeExecution) {
        return this;
    }

    @Override
    public ListenableFuture<T> callback(FutureCallback<? super T> callback, Executor executor, ListenableFuture.ListenerOptimizationStrategy optimize) {
        if (InternalFutureUtils.invokeCompletedDirectly(executor, optimize)) {
            callback.handleResult(this.result);
        } else {
            executor.execute(() -> callback.handleResult(this.result));
        }
        return this;
    }

    @Override
    public ListenableFuture<T> resultCallback(Consumer<? super T> callback, Executor executor, ListenableFuture.ListenerOptimizationStrategy optimize) {
        if (InternalFutureUtils.invokeCompletedDirectly(executor, optimize)) {
            callback.accept(this.result);
        } else {
            executor.execute(() -> callback.accept(this.result));
        }
        return this;
    }

    @Override
    public ListenableFuture<T> failureCallback(Consumer<Throwable> callback, Executor executor, ListenableFuture.ListenerOptimizationStrategy optimize) {
        return this;
    }

    @Override
    public T get() {
        return this.result;
    }

    @Override
    public T get(long timeout, TimeUnit unit) {
        return this.result;
    }

    @Override
    public Throwable getFailure() {
        return null;
    }

    @Override
    public Throwable getFailure(long timeout, TimeUnit unit) {
        return null;
    }
}

